# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include organizations_service.R
NULL

#' Sends a response to the originator of a handshake agreeing to the action
#' proposed by the handshake request
#'
#' @description
#' Sends a response to the originator of a handshake agreeing to the action proposed by the handshake request.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_accept_handshake/](https://www.paws-r-sdk.com/docs/organizations_accept_handshake/) for full documentation.
#'
#' @param HandshakeId &#91;required&#93; The unique identifier (ID) of the handshake that you want to accept.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for handshake
#' ID string requires "h-" followed by from 8 to 32 lowercase letters or
#' digits.
#'
#' @keywords internal
#'
#' @rdname organizations_accept_handshake
organizations_accept_handshake <- function(HandshakeId) {
  op <- new_operation(
    name = "AcceptHandshake",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$accept_handshake_input(HandshakeId = HandshakeId)
  output <- .organizations$accept_handshake_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$accept_handshake <- organizations_accept_handshake

#' Attaches a policy to a root, an organizational unit (OU), or an
#' individual account
#'
#' @description
#' Attaches a policy to a root, an organizational unit (OU), or an individual account. How the policy affects accounts depends on the type of policy. Refer to the *Organizations User Guide* for information about each policy type:
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_attach_policy/](https://www.paws-r-sdk.com/docs/organizations_attach_policy/) for full documentation.
#'
#' @param PolicyId &#91;required&#93; The unique identifier (ID) of the policy that you want to attach to the
#' target. You can get the ID for the policy by calling the
#' [`list_policies`][organizations_list_policies] operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a policy ID
#' string requires "p-" followed by from 8 to 128 lowercase or uppercase
#' letters, digits, or the underscore character (_).
#' @param TargetId &#91;required&#93; The unique identifier (ID) of the root, OU, or account that you want to
#' attach the policy to. You can get the ID by calling the
#' [`list_roots`][organizations_list_roots],
#' [`list_organizational_units_for_parent`][organizations_list_organizational_units_for_parent],
#' or [`list_accounts`][organizations_list_accounts] operations.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a target ID
#' string requires one of the following:
#' 
#' -   **Root** - A string that begins with "r-" followed by from 4 to 32
#'     lowercase letters or digits.
#' 
#' -   **Account** - A string that consists of exactly 12 digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that the OU is in). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#'
#' @keywords internal
#'
#' @rdname organizations_attach_policy
organizations_attach_policy <- function(PolicyId, TargetId) {
  op <- new_operation(
    name = "AttachPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$attach_policy_input(PolicyId = PolicyId, TargetId = TargetId)
  output <- .organizations$attach_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$attach_policy <- organizations_attach_policy

#' Cancels a handshake
#'
#' @description
#' Cancels a handshake. Canceling a handshake sets the handshake state to `CANCELED`.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_cancel_handshake/](https://www.paws-r-sdk.com/docs/organizations_cancel_handshake/) for full documentation.
#'
#' @param HandshakeId &#91;required&#93; The unique identifier (ID) of the handshake that you want to cancel. You
#' can get the ID from the
#' [`list_handshakes_for_organization`][organizations_list_handshakes_for_organization]
#' operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for handshake
#' ID string requires "h-" followed by from 8 to 32 lowercase letters or
#' digits.
#'
#' @keywords internal
#'
#' @rdname organizations_cancel_handshake
organizations_cancel_handshake <- function(HandshakeId) {
  op <- new_operation(
    name = "CancelHandshake",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$cancel_handshake_input(HandshakeId = HandshakeId)
  output <- .organizations$cancel_handshake_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$cancel_handshake <- organizations_cancel_handshake

#' Closes an Amazon Web Services member account within an organization
#'
#' @description
#' Closes an Amazon Web Services member account within an organization. You can close an account when [all features are enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html) . You can't close the management account with this API. This is an asynchronous request that Amazon Web Services performs in the background. Because [`close_account`][organizations_close_account] operates asynchronously, it can return a successful completion message even though account closure might still be in progress. You need to wait a few minutes before the account is fully closed. To check the status of the request, do one of the following:
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_close_account/](https://www.paws-r-sdk.com/docs/organizations_close_account/) for full documentation.
#'
#' @param AccountId &#91;required&#93; Retrieves the Amazon Web Services account Id for the current
#' [`close_account`][organizations_close_account] API request.
#'
#' @keywords internal
#'
#' @rdname organizations_close_account
organizations_close_account <- function(AccountId) {
  op <- new_operation(
    name = "CloseAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$close_account_input(AccountId = AccountId)
  output <- .organizations$close_account_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$close_account <- organizations_close_account

#' Creates an Amazon Web Services account that is automatically a member of
#' the organization whose credentials made the request
#'
#' @description
#' Creates an Amazon Web Services account that is automatically a member of the organization whose credentials made the request. This is an asynchronous request that Amazon Web Services performs in the background. Because [`create_account`][organizations_create_account] operates asynchronously, it can return a successful completion message even though account initialization might still be in progress. You might need to wait a few minutes before you can successfully access the account. To check the status of the request, do one of the following:
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_create_account/](https://www.paws-r-sdk.com/docs/organizations_create_account/) for full documentation.
#'
#' @param Email &#91;required&#93; The email address of the owner to assign to the new member account. This
#' email address must not already be associated with another Amazon Web
#' Services account. You must use a valid email address to complete account
#' creation.
#' 
#' The rules for a valid email address:
#' 
#' -   The address must be a minimum of 6 and a maximum of 64 characters
#'     long.
#' 
#' -   All characters must be 7-bit ASCII characters.
#' 
#' -   There must be one and only one @@ symbol, which separates the local
#'     name from the domain name.
#' 
#' -   The local name can't contain any of the following characters:
#' 
#'     whitespace, " ' ( ) \< \> \[ \] : ; , \\ | % &
#' 
#' -   The local name can't begin with a dot (.)
#' 
#' -   The domain name can consist of only the characters
#'     \[a-z\],\[A-Z\],\[0-9\], hyphen (-), or dot (.)
#' 
#' -   The domain name can't begin or end with a hyphen (-) or dot (.)
#' 
#' -   The domain name must contain at least one dot
#' 
#' You can't access the root user of the account or remove an account that
#' was created with an invalid email address.
#' @param AccountName &#91;required&#93; The friendly name of the member account.
#' @param RoleName The name of an IAM role that Organizations automatically preconfigures
#' in the new member account. This role trusts the management account,
#' allowing users in the management account to assume the role, as
#' permitted by the management account administrator. The role has
#' administrator permissions in the new member account.
#' 
#' If you don't specify this parameter, the role name defaults to
#' `OrganizationAccountAccessRole`.
#' 
#' For more information about how to use this role to access the member
#' account, see the following links:
#' 
#' -   [Creating the OrganizationAccountAccessRole in an invited member
#'     account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role)
#'     in the *Organizations User Guide*
#' 
#' -   Steps 2 and 3 in [IAM Tutorial: Delegate access across Amazon Web
#'     Services accounts using IAM
#'     roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html)
#'     in the *IAM User Guide*
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) that is used to
#' validate this parameter. The pattern can include uppercase letters,
#' lowercase letters, digits with no spaces, and any of the following
#' characters: =,.@@-
#' @param IamUserAccessToBilling If set to `ALLOW`, the new account enables IAM users to access account
#' billing information *if* they have the required permissions. If set to
#' `DENY`, only the root user of the new account can access account billing
#' information. For more information, see [About IAM access to the Billing
#' and Cost Management
#' console](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/control-access-billing.html#ControllingAccessWebsite-Activate)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#' 
#' If you don't specify this parameter, the value defaults to `ALLOW`, and
#' IAM users and roles with the required permissions can access billing
#' information for the new account.
#' @param Tags A list of tags that you want to attach to the newly created account. For
#' each tag in the list, you must specify both a tag key and a value. You
#' can set the value to an empty string, but you can't set it to `null`.
#' For more information about tagging, see [Tagging Organizations
#' resources](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html)
#' in the Organizations User Guide.
#' 
#' If any one of the tags is not valid or if you exceed the maximum allowed
#' number of tags for an account, then the entire request fails and the
#' account is not created.
#'
#' @keywords internal
#'
#' @rdname organizations_create_account
organizations_create_account <- function(Email, AccountName, RoleName = NULL, IamUserAccessToBilling = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$create_account_input(Email = Email, AccountName = AccountName, RoleName = RoleName, IamUserAccessToBilling = IamUserAccessToBilling, Tags = Tags)
  output <- .organizations$create_account_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$create_account <- organizations_create_account

#' This action is available if all of the following are true:
#'
#' @description
#' This action is available if all of the following are true:
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_create_gov_cloud_account/](https://www.paws-r-sdk.com/docs/organizations_create_gov_cloud_account/) for full documentation.
#'
#' @param Email &#91;required&#93; Specifies the email address of the owner to assign to the new member
#' account in the commercial Region. This email address must not already be
#' associated with another Amazon Web Services account. You must use a
#' valid email address to complete account creation.
#' 
#' The rules for a valid email address:
#' 
#' -   The address must be a minimum of 6 and a maximum of 64 characters
#'     long.
#' 
#' -   All characters must be 7-bit ASCII characters.
#' 
#' -   There must be one and only one @@ symbol, which separates the local
#'     name from the domain name.
#' 
#' -   The local name can't contain any of the following characters:
#' 
#'     whitespace, " ' ( ) \< \> \[ \] : ; , \\ | % &
#' 
#' -   The local name can't begin with a dot (.)
#' 
#' -   The domain name can consist of only the characters
#'     \[a-z\],\[A-Z\],\[0-9\], hyphen (-), or dot (.)
#' 
#' -   The domain name can't begin or end with a hyphen (-) or dot (.)
#' 
#' -   The domain name must contain at least one dot
#' 
#' You can't access the root user of the account or remove an account that
#' was created with an invalid email address. Like all request parameters
#' for
#' [`create_gov_cloud_account`][organizations_create_gov_cloud_account],
#' the request for the email address for the Amazon Web Services GovCloud
#' (US) account originates from the commercial Region, not from the Amazon
#' Web Services GovCloud (US) Region.
#' @param AccountName &#91;required&#93; The friendly name of the member account.
#' 
#' The account name can consist of only the characters
#' \[a-z\],\[A-Z\],\[0-9\], hyphen (-), or dot (.) You can't separate
#' characters with a dash (–).
#' @param RoleName (Optional)
#' 
#' The name of an IAM role that Organizations automatically preconfigures
#' in the new member accounts in both the Amazon Web Services GovCloud (US)
#' Region and in the commercial Region. This role trusts the management
#' account, allowing users in the management account to assume the role, as
#' permitted by the management account administrator. The role has
#' administrator permissions in the new member account.
#' 
#' If you don't specify this parameter, the role name defaults to
#' `OrganizationAccountAccessRole`.
#' 
#' For more information about how to use this role to access the member
#' account, see the following links:
#' 
#' -   [Creating the OrganizationAccountAccessRole in an invited member
#'     account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role)
#'     in the *Organizations User Guide*
#' 
#' -   Steps 2 and 3 in [IAM Tutorial: Delegate access across Amazon Web
#'     Services accounts using IAM
#'     roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html)
#'     in the *IAM User Guide*
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) that is used to
#' validate this parameter. The pattern can include uppercase letters,
#' lowercase letters, digits with no spaces, and any of the following
#' characters: =,.@@-
#' @param IamUserAccessToBilling If set to `ALLOW`, the new linked account in the commercial Region
#' enables IAM users to access account billing information *if* they have
#' the required permissions. If set to `DENY`, only the root user of the
#' new account can access account billing information. For more
#' information, see [About IAM access to the Billing and Cost Management
#' console](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/control-access-billing.html#ControllingAccessWebsite-Activate)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#' 
#' If you don't specify this parameter, the value defaults to `ALLOW`, and
#' IAM users and roles with the required permissions can access billing
#' information for the new account.
#' @param Tags A list of tags that you want to attach to the newly created account.
#' These tags are attached to the commercial account associated with the
#' GovCloud account, and not to the GovCloud account itself. To add tags to
#' the actual GovCloud account, call the
#' [`tag_resource`][organizations_tag_resource] operation in the GovCloud
#' region after the new GovCloud account exists.
#' 
#' For each tag in the list, you must specify both a tag key and a value.
#' You can set the value to an empty string, but you can't set it to
#' `null`. For more information about tagging, see [Tagging Organizations
#' resources](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html)
#' in the Organizations User Guide.
#' 
#' If any one of the tags is not valid or if you exceed the maximum allowed
#' number of tags for an account, then the entire request fails and the
#' account is not created.
#'
#' @keywords internal
#'
#' @rdname organizations_create_gov_cloud_account
organizations_create_gov_cloud_account <- function(Email, AccountName, RoleName = NULL, IamUserAccessToBilling = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateGovCloudAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$create_gov_cloud_account_input(Email = Email, AccountName = AccountName, RoleName = RoleName, IamUserAccessToBilling = IamUserAccessToBilling, Tags = Tags)
  output <- .organizations$create_gov_cloud_account_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$create_gov_cloud_account <- organizations_create_gov_cloud_account

#' Creates an Amazon Web Services organization
#'
#' @description
#' Creates an Amazon Web Services organization. The account whose user is calling the [`create_organization`][organizations_create_organization] operation automatically becomes the [management account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account) of the new organization.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_create_organization/](https://www.paws-r-sdk.com/docs/organizations_create_organization/) for full documentation.
#'
#' @param FeatureSet Specifies the feature set supported by the new organization. Each
#' feature set supports different levels of functionality.
#' 
#' -   `CONSOLIDATED_BILLING`: All member accounts have their bills
#'     consolidated to and paid by the management account. For more
#'     information, see [Consolidated
#'     billing](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only)
#'     in the *Organizations User Guide*.
#' 
#'     The consolidated billing feature subset isn't available for
#'     organizations in the Amazon Web Services GovCloud (US) Region.
#' 
#' -   `ALL`: In addition to all the features supported by the consolidated
#'     billing feature set, the management account can also apply any
#'     policy type to any member account in the organization. For more
#'     information, see [All
#'     features](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all)
#'     in the *Organizations User Guide*.
#'
#' @keywords internal
#'
#' @rdname organizations_create_organization
organizations_create_organization <- function(FeatureSet = NULL) {
  op <- new_operation(
    name = "CreateOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$create_organization_input(FeatureSet = FeatureSet)
  output <- .organizations$create_organization_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$create_organization <- organizations_create_organization

#' Creates an organizational unit (OU) within a root or parent OU
#'
#' @description
#' Creates an organizational unit (OU) within a root or parent OU. An OU is a container for accounts that enables you to organize your accounts to apply policies according to your business requirements. The number of levels deep that you can nest OUs is dependent upon the policy types enabled for that root. For service control policies, the limit is five.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_create_organizational_unit/](https://www.paws-r-sdk.com/docs/organizations_create_organizational_unit/) for full documentation.
#'
#' @param ParentId &#91;required&#93; The unique identifier (ID) of the parent root or OU that you want to
#' create the new OU in.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a parent ID
#' string requires one of the following:
#' 
#' -   **Root** - A string that begins with "r-" followed by from 4 to 32
#'     lowercase letters or digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that the OU is in). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#' @param Name &#91;required&#93; The friendly name to assign to the new OU.
#' @param Tags A list of tags that you want to attach to the newly created OU. For each
#' tag in the list, you must specify both a tag key and a value. You can
#' set the value to an empty string, but you can't set it to `null`. For
#' more information about tagging, see [Tagging Organizations
#' resources](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html)
#' in the Organizations User Guide.
#' 
#' If any one of the tags is not valid or if you exceed the allowed number
#' of tags for an OU, then the entire request fails and the OU is not
#' created.
#'
#' @keywords internal
#'
#' @rdname organizations_create_organizational_unit
organizations_create_organizational_unit <- function(ParentId, Name, Tags = NULL) {
  op <- new_operation(
    name = "CreateOrganizationalUnit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$create_organizational_unit_input(ParentId = ParentId, Name = Name, Tags = Tags)
  output <- .organizations$create_organizational_unit_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$create_organizational_unit <- organizations_create_organizational_unit

#' Creates a policy of a specified type that you can attach to a root, an
#' organizational unit (OU), or an individual Amazon Web Services account
#'
#' @description
#' Creates a policy of a specified type that you can attach to a root, an organizational unit (OU), or an individual Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_create_policy/](https://www.paws-r-sdk.com/docs/organizations_create_policy/) for full documentation.
#'
#' @param Content &#91;required&#93; The policy text content to add to the new policy. The text that you
#' supply must adhere to the rules of the policy type you specify in the
#' `Type` parameter.
#' 
#' The maximum size of a policy document depends on the policy's type. For
#' more information, see [Maximum and minimum
#' values](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html#min-max-values)
#' in the *Organizations User Guide*.
#' @param Description &#91;required&#93; An optional description to assign to the policy.
#' @param Name &#91;required&#93; The friendly name to assign to the policy.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) that is used to
#' validate this parameter is a string of any of the characters in the
#' ASCII character range.
#' @param Type &#91;required&#93; The type of policy to create. You can specify one of the following
#' values:
#' 
#' -   [AISERVICES_OPT_OUT_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
#' 
#' -   [BACKUP_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
#' 
#' -   [SERVICE_CONTROL_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps.html)
#' 
#' -   [TAG_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
#' @param Tags A list of tags that you want to attach to the newly created policy. For
#' each tag in the list, you must specify both a tag key and a value. You
#' can set the value to an empty string, but you can't set it to `null`.
#' For more information about tagging, see [Tagging Organizations
#' resources](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html)
#' in the Organizations User Guide.
#' 
#' If any one of the tags is not valid or if you exceed the allowed number
#' of tags for a policy, then the entire request fails and the policy is
#' not created.
#'
#' @keywords internal
#'
#' @rdname organizations_create_policy
organizations_create_policy <- function(Content, Description, Name, Type, Tags = NULL) {
  op <- new_operation(
    name = "CreatePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$create_policy_input(Content = Content, Description = Description, Name = Name, Type = Type, Tags = Tags)
  output <- .organizations$create_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$create_policy <- organizations_create_policy

#' Declines a handshake request
#'
#' @description
#' Declines a handshake request. This sets the handshake state to `DECLINED` and effectively deactivates the request.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_decline_handshake/](https://www.paws-r-sdk.com/docs/organizations_decline_handshake/) for full documentation.
#'
#' @param HandshakeId &#91;required&#93; The unique identifier (ID) of the handshake that you want to decline.
#' You can get the ID from the
#' [`list_handshakes_for_account`][organizations_list_handshakes_for_account]
#' operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for handshake
#' ID string requires "h-" followed by from 8 to 32 lowercase letters or
#' digits.
#'
#' @keywords internal
#'
#' @rdname organizations_decline_handshake
organizations_decline_handshake <- function(HandshakeId) {
  op <- new_operation(
    name = "DeclineHandshake",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$decline_handshake_input(HandshakeId = HandshakeId)
  output <- .organizations$decline_handshake_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$decline_handshake <- organizations_decline_handshake

#' Deletes the organization
#'
#' @description
#' Deletes the organization. You can delete an organization only by using credentials from the management account. The organization must be empty of member accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_delete_organization/](https://www.paws-r-sdk.com/docs/organizations_delete_organization/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname organizations_delete_organization
organizations_delete_organization <- function() {
  op <- new_operation(
    name = "DeleteOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$delete_organization_input()
  output <- .organizations$delete_organization_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$delete_organization <- organizations_delete_organization

#' Deletes an organizational unit (OU) from a root or another OU
#'
#' @description
#' Deletes an organizational unit (OU) from a root or another OU. You must first remove all accounts and child OUs from the OU that you want to delete.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_delete_organizational_unit/](https://www.paws-r-sdk.com/docs/organizations_delete_organizational_unit/) for full documentation.
#'
#' @param OrganizationalUnitId &#91;required&#93; The unique identifier (ID) of the organizational unit that you want to
#' delete. You can get the ID from the
#' [`list_organizational_units_for_parent`][organizations_list_organizational_units_for_parent]
#' operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for an
#' organizational unit ID string requires "ou-" followed by from 4 to 32
#' lowercase letters or digits (the ID of the root that contains the OU).
#' This string is followed by a second "-" dash and from 8 to 32 additional
#' lowercase letters or digits.
#'
#' @keywords internal
#'
#' @rdname organizations_delete_organizational_unit
organizations_delete_organizational_unit <- function(OrganizationalUnitId) {
  op <- new_operation(
    name = "DeleteOrganizationalUnit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$delete_organizational_unit_input(OrganizationalUnitId = OrganizationalUnitId)
  output <- .organizations$delete_organizational_unit_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$delete_organizational_unit <- organizations_delete_organizational_unit

#' Deletes the specified policy from your organization
#'
#' @description
#' Deletes the specified policy from your organization. Before you perform this operation, you must first detach the policy from all organizational units (OUs), roots, and accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_delete_policy/](https://www.paws-r-sdk.com/docs/organizations_delete_policy/) for full documentation.
#'
#' @param PolicyId &#91;required&#93; The unique identifier (ID) of the policy that you want to delete. You
#' can get the ID from the [`list_policies`][organizations_list_policies]
#' or [`list_policies_for_target`][organizations_list_policies_for_target]
#' operations.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a policy ID
#' string requires "p-" followed by from 8 to 128 lowercase or uppercase
#' letters, digits, or the underscore character (_).
#'
#' @keywords internal
#'
#' @rdname organizations_delete_policy
organizations_delete_policy <- function(PolicyId) {
  op <- new_operation(
    name = "DeletePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$delete_policy_input(PolicyId = PolicyId)
  output <- .organizations$delete_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$delete_policy <- organizations_delete_policy

#' Deletes the resource policy from your organization
#'
#' @description
#' Deletes the resource policy from your organization.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_delete_resource_policy/](https://www.paws-r-sdk.com/docs/organizations_delete_resource_policy/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname organizations_delete_resource_policy
organizations_delete_resource_policy <- function() {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$delete_resource_policy_input()
  output <- .organizations$delete_resource_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$delete_resource_policy <- organizations_delete_resource_policy

#' Removes the specified member Amazon Web Services account as a delegated
#' administrator for the specified Amazon Web Services service
#'
#' @description
#' Removes the specified member Amazon Web Services account as a delegated administrator for the specified Amazon Web Services service.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_deregister_delegated_administrator/](https://www.paws-r-sdk.com/docs/organizations_deregister_delegated_administrator/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID number of the member account in the organization that you
#' want to deregister as a delegated administrator.
#' @param ServicePrincipal &#91;required&#93; The service principal name of an Amazon Web Services service for which
#' the account is a delegated administrator.
#' 
#' Delegated administrator privileges are revoked for only the specified
#' Amazon Web Services service from the member account. If the specified
#' service is the only service for which the member account is a delegated
#' administrator, the operation also revokes Organizations read action
#' permissions.
#'
#' @keywords internal
#'
#' @rdname organizations_deregister_delegated_administrator
organizations_deregister_delegated_administrator <- function(AccountId, ServicePrincipal) {
  op <- new_operation(
    name = "DeregisterDelegatedAdministrator",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$deregister_delegated_administrator_input(AccountId = AccountId, ServicePrincipal = ServicePrincipal)
  output <- .organizations$deregister_delegated_administrator_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$deregister_delegated_administrator <- organizations_deregister_delegated_administrator

#' Retrieves Organizations-related information about the specified account
#'
#' @description
#' Retrieves Organizations-related information about the specified account.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_describe_account/](https://www.paws-r-sdk.com/docs/organizations_describe_account/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The unique identifier (ID) of the Amazon Web Services account that you
#' want information about. You can get the ID from the
#' [`list_accounts`][organizations_list_accounts] or
#' [`list_accounts_for_parent`][organizations_list_accounts_for_parent]
#' operations.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for an account
#' ID string requires exactly 12 digits.
#'
#' @keywords internal
#'
#' @rdname organizations_describe_account
organizations_describe_account <- function(AccountId) {
  op <- new_operation(
    name = "DescribeAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$describe_account_input(AccountId = AccountId)
  output <- .organizations$describe_account_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$describe_account <- organizations_describe_account

#' Retrieves the current status of an asynchronous request to create an
#' account
#'
#' @description
#' Retrieves the current status of an asynchronous request to create an account.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_describe_create_account_status/](https://www.paws-r-sdk.com/docs/organizations_describe_create_account_status/) for full documentation.
#'
#' @param CreateAccountRequestId &#91;required&#93; Specifies the `Id` value that uniquely identifies the
#' [`create_account`][organizations_create_account] request. You can get
#' the value from the `CreateAccountStatus.Id` response in an earlier
#' [`create_account`][organizations_create_account] request, or from the
#' [`list_create_account_status`][organizations_list_create_account_status]
#' operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a create
#' account request ID string requires "car-" followed by from 8 to 32
#' lowercase letters or digits.
#'
#' @keywords internal
#'
#' @rdname organizations_describe_create_account_status
organizations_describe_create_account_status <- function(CreateAccountRequestId) {
  op <- new_operation(
    name = "DescribeCreateAccountStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$describe_create_account_status_input(CreateAccountRequestId = CreateAccountRequestId)
  output <- .organizations$describe_create_account_status_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$describe_create_account_status <- organizations_describe_create_account_status

#' Returns the contents of the effective policy for specified policy type
#' and account
#'
#' @description
#' Returns the contents of the effective policy for specified policy type and account. The effective policy is the aggregation of any policies of the specified type that the account inherits, plus any policy of that type that is directly attached to the account.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_describe_effective_policy/](https://www.paws-r-sdk.com/docs/organizations_describe_effective_policy/) for full documentation.
#'
#' @param PolicyType &#91;required&#93; The type of policy that you want information about. You can specify one
#' of the following values:
#' 
#' -   [AISERVICES_OPT_OUT_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
#' 
#' -   [BACKUP_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
#' 
#' -   [TAG_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
#' @param TargetId When you're signed in as the management account, specify the ID of the
#' account that you want details about. Specifying an organization root or
#' organizational unit (OU) as the target is not supported.
#'
#' @keywords internal
#'
#' @rdname organizations_describe_effective_policy
organizations_describe_effective_policy <- function(PolicyType, TargetId = NULL) {
  op <- new_operation(
    name = "DescribeEffectivePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$describe_effective_policy_input(PolicyType = PolicyType, TargetId = TargetId)
  output <- .organizations$describe_effective_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$describe_effective_policy <- organizations_describe_effective_policy

#' Retrieves information about a previously requested handshake
#'
#' @description
#' Retrieves information about a previously requested handshake. The handshake ID comes from the response to the original [`invite_account_to_organization`][organizations_invite_account_to_organization] operation that generated the handshake.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_describe_handshake/](https://www.paws-r-sdk.com/docs/organizations_describe_handshake/) for full documentation.
#'
#' @param HandshakeId &#91;required&#93; The unique identifier (ID) of the handshake that you want information
#' about. You can get the ID from the original call to
#' [`invite_account_to_organization`][organizations_invite_account_to_organization],
#' or from a call to
#' [`list_handshakes_for_account`][organizations_list_handshakes_for_account]
#' or
#' [`list_handshakes_for_organization`][organizations_list_handshakes_for_organization].
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for handshake
#' ID string requires "h-" followed by from 8 to 32 lowercase letters or
#' digits.
#'
#' @keywords internal
#'
#' @rdname organizations_describe_handshake
organizations_describe_handshake <- function(HandshakeId) {
  op <- new_operation(
    name = "DescribeHandshake",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$describe_handshake_input(HandshakeId = HandshakeId)
  output <- .organizations$describe_handshake_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$describe_handshake <- organizations_describe_handshake

#' Retrieves information about the organization that the user's account
#' belongs to
#'
#' @description
#' Retrieves information about the organization that the user's account belongs to.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_describe_organization/](https://www.paws-r-sdk.com/docs/organizations_describe_organization/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname organizations_describe_organization
organizations_describe_organization <- function() {
  op <- new_operation(
    name = "DescribeOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$describe_organization_input()
  output <- .organizations$describe_organization_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$describe_organization <- organizations_describe_organization

#' Retrieves information about an organizational unit (OU)
#'
#' @description
#' Retrieves information about an organizational unit (OU).
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_describe_organizational_unit/](https://www.paws-r-sdk.com/docs/organizations_describe_organizational_unit/) for full documentation.
#'
#' @param OrganizationalUnitId &#91;required&#93; The unique identifier (ID) of the organizational unit that you want
#' details about. You can get the ID from the
#' [`list_organizational_units_for_parent`][organizations_list_organizational_units_for_parent]
#' operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for an
#' organizational unit ID string requires "ou-" followed by from 4 to 32
#' lowercase letters or digits (the ID of the root that contains the OU).
#' This string is followed by a second "-" dash and from 8 to 32 additional
#' lowercase letters or digits.
#'
#' @keywords internal
#'
#' @rdname organizations_describe_organizational_unit
organizations_describe_organizational_unit <- function(OrganizationalUnitId) {
  op <- new_operation(
    name = "DescribeOrganizationalUnit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$describe_organizational_unit_input(OrganizationalUnitId = OrganizationalUnitId)
  output <- .organizations$describe_organizational_unit_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$describe_organizational_unit <- organizations_describe_organizational_unit

#' Retrieves information about a policy
#'
#' @description
#' Retrieves information about a policy.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_describe_policy/](https://www.paws-r-sdk.com/docs/organizations_describe_policy/) for full documentation.
#'
#' @param PolicyId &#91;required&#93; The unique identifier (ID) of the policy that you want details about.
#' You can get the ID from the
#' [`list_policies`][organizations_list_policies] or
#' [`list_policies_for_target`][organizations_list_policies_for_target]
#' operations.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a policy ID
#' string requires "p-" followed by from 8 to 128 lowercase or uppercase
#' letters, digits, or the underscore character (_).
#'
#' @keywords internal
#'
#' @rdname organizations_describe_policy
organizations_describe_policy <- function(PolicyId) {
  op <- new_operation(
    name = "DescribePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$describe_policy_input(PolicyId = PolicyId)
  output <- .organizations$describe_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$describe_policy <- organizations_describe_policy

#' Retrieves information about a resource policy
#'
#' @description
#' Retrieves information about a resource policy.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_describe_resource_policy/](https://www.paws-r-sdk.com/docs/organizations_describe_resource_policy/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname organizations_describe_resource_policy
organizations_describe_resource_policy <- function() {
  op <- new_operation(
    name = "DescribeResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$describe_resource_policy_input()
  output <- .organizations$describe_resource_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$describe_resource_policy <- organizations_describe_resource_policy

#' Detaches a policy from a target root, organizational unit (OU), or
#' account
#'
#' @description
#' Detaches a policy from a target root, organizational unit (OU), or account.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_detach_policy/](https://www.paws-r-sdk.com/docs/organizations_detach_policy/) for full documentation.
#'
#' @param PolicyId &#91;required&#93; The unique identifier (ID) of the policy you want to detach. You can get
#' the ID from the [`list_policies`][organizations_list_policies] or
#' [`list_policies_for_target`][organizations_list_policies_for_target]
#' operations.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a policy ID
#' string requires "p-" followed by from 8 to 128 lowercase or uppercase
#' letters, digits, or the underscore character (_).
#' @param TargetId &#91;required&#93; The unique identifier (ID) of the root, OU, or account that you want to
#' detach the policy from. You can get the ID from the
#' [`list_roots`][organizations_list_roots],
#' [`list_organizational_units_for_parent`][organizations_list_organizational_units_for_parent],
#' or [`list_accounts`][organizations_list_accounts] operations.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a target ID
#' string requires one of the following:
#' 
#' -   **Root** - A string that begins with "r-" followed by from 4 to 32
#'     lowercase letters or digits.
#' 
#' -   **Account** - A string that consists of exactly 12 digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that the OU is in). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#'
#' @keywords internal
#'
#' @rdname organizations_detach_policy
organizations_detach_policy <- function(PolicyId, TargetId) {
  op <- new_operation(
    name = "DetachPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$detach_policy_input(PolicyId = PolicyId, TargetId = TargetId)
  output <- .organizations$detach_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$detach_policy <- organizations_detach_policy

#' Disables the integration of an Amazon Web Services service (the service
#' that is specified by ServicePrincipal) with Organizations
#'
#' @description
#' Disables the integration of an Amazon Web Services service (the service that is specified by `ServicePrincipal`) with Organizations. When you disable integration, the specified service no longer can create a [service-linked role](https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html) in *new* accounts in your organization. This means the service can't perform operations on your behalf on any new accounts in your organization. The service can still perform operations in older accounts until the service completes its clean-up from Organizations.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_disable_aws_service_access/](https://www.paws-r-sdk.com/docs/organizations_disable_aws_service_access/) for full documentation.
#'
#' @param ServicePrincipal &#91;required&#93; The service principal name of the Amazon Web Services service for which
#' you want to disable integration with your organization. This is
#' typically in the form of a URL, such as
#' ` service-abbreviation.amazonaws.com`.
#'
#' @keywords internal
#'
#' @rdname organizations_disable_aws_service_access
organizations_disable_aws_service_access <- function(ServicePrincipal) {
  op <- new_operation(
    name = "DisableAWSServiceAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$disable_aws_service_access_input(ServicePrincipal = ServicePrincipal)
  output <- .organizations$disable_aws_service_access_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$disable_aws_service_access <- organizations_disable_aws_service_access

#' Disables an organizational policy type in a root
#'
#' @description
#' Disables an organizational policy type in a root. A policy of a certain type can be attached to entities in a root only if that type is enabled in the root. After you perform this operation, you no longer can attach policies of the specified type to that root or to any organizational unit (OU) or account in that root. You can undo this by using the [`enable_policy_type`][organizations_enable_policy_type] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_disable_policy_type/](https://www.paws-r-sdk.com/docs/organizations_disable_policy_type/) for full documentation.
#'
#' @param RootId &#91;required&#93; The unique identifier (ID) of the root in which you want to disable a
#' policy type. You can get the ID from the
#' [`list_roots`][organizations_list_roots] operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a root ID
#' string requires "r-" followed by from 4 to 32 lowercase letters or
#' digits.
#' @param PolicyType &#91;required&#93; The policy type that you want to disable in this root. You can specify
#' one of the following values:
#' 
#' -   [AISERVICES_OPT_OUT_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
#' 
#' -   [BACKUP_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
#' 
#' -   [SERVICE_CONTROL_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps.html)
#' 
#' -   [TAG_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
#'
#' @keywords internal
#'
#' @rdname organizations_disable_policy_type
organizations_disable_policy_type <- function(RootId, PolicyType) {
  op <- new_operation(
    name = "DisablePolicyType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$disable_policy_type_input(RootId = RootId, PolicyType = PolicyType)
  output <- .organizations$disable_policy_type_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$disable_policy_type <- organizations_disable_policy_type

#' Enables the integration of an Amazon Web Services service (the service
#' that is specified by ServicePrincipal) with Organizations
#'
#' @description
#' Enables the integration of an Amazon Web Services service (the service that is specified by `ServicePrincipal`) with Organizations. When you enable integration, you allow the specified service to create a [service-linked role](https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html) in all the accounts in your organization. This allows the service to perform operations on your behalf in your organization and its accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_enable_aws_service_access/](https://www.paws-r-sdk.com/docs/organizations_enable_aws_service_access/) for full documentation.
#'
#' @param ServicePrincipal &#91;required&#93; The service principal name of the Amazon Web Services service for which
#' you want to enable integration with your organization. This is typically
#' in the form of a URL, such as ` service-abbreviation.amazonaws.com`.
#'
#' @keywords internal
#'
#' @rdname organizations_enable_aws_service_access
organizations_enable_aws_service_access <- function(ServicePrincipal) {
  op <- new_operation(
    name = "EnableAWSServiceAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$enable_aws_service_access_input(ServicePrincipal = ServicePrincipal)
  output <- .organizations$enable_aws_service_access_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$enable_aws_service_access <- organizations_enable_aws_service_access

#' Enables all features in an organization
#'
#' @description
#' Enables all features in an organization. This enables the use of organization policies that can restrict the services and actions that can be called in each account. Until you enable all features, you have access only to consolidated billing, and you can't use any of the advanced account administration features that Organizations supports. For more information, see [Enabling all features in your organization](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html) in the *Organizations User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_enable_all_features/](https://www.paws-r-sdk.com/docs/organizations_enable_all_features/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname organizations_enable_all_features
organizations_enable_all_features <- function() {
  op <- new_operation(
    name = "EnableAllFeatures",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$enable_all_features_input()
  output <- .organizations$enable_all_features_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$enable_all_features <- organizations_enable_all_features

#' Enables a policy type in a root
#'
#' @description
#' Enables a policy type in a root. After you enable a policy type in a root, you can attach policies of that type to the root, any organizational unit (OU), or account in that root. You can undo this by using the [`disable_policy_type`][organizations_disable_policy_type] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_enable_policy_type/](https://www.paws-r-sdk.com/docs/organizations_enable_policy_type/) for full documentation.
#'
#' @param RootId &#91;required&#93; The unique identifier (ID) of the root in which you want to enable a
#' policy type. You can get the ID from the
#' [`list_roots`][organizations_list_roots] operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a root ID
#' string requires "r-" followed by from 4 to 32 lowercase letters or
#' digits.
#' @param PolicyType &#91;required&#93; The policy type that you want to enable. You can specify one of the
#' following values:
#' 
#' -   [AISERVICES_OPT_OUT_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
#' 
#' -   [BACKUP_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
#' 
#' -   [SERVICE_CONTROL_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps.html)
#' 
#' -   [TAG_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
#'
#' @keywords internal
#'
#' @rdname organizations_enable_policy_type
organizations_enable_policy_type <- function(RootId, PolicyType) {
  op <- new_operation(
    name = "EnablePolicyType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$enable_policy_type_input(RootId = RootId, PolicyType = PolicyType)
  output <- .organizations$enable_policy_type_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$enable_policy_type <- organizations_enable_policy_type

#' Sends an invitation to another account to join your organization as a
#' member account
#'
#' @description
#' Sends an invitation to another account to join your organization as a member account. Organizations sends email on your behalf to the email address that is associated with the other account's owner. The invitation is implemented as a Handshake whose details are in the response.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_invite_account_to_organization/](https://www.paws-r-sdk.com/docs/organizations_invite_account_to_organization/) for full documentation.
#'
#' @param Target &#91;required&#93; The identifier (ID) of the Amazon Web Services account that you want to
#' invite to join your organization. This is a JSON object that contains
#' the following elements:
#' 
#' `{ "Type": "ACCOUNT", "Id": "< account id number >" }`
#' 
#' If you use the CLI, you can submit this as a single string, similar to
#' the following example:
#' 
#' `--target Id=123456789012,Type=ACCOUNT`
#' 
#' If you specify `"Type": "ACCOUNT"`, you must provide the Amazon Web
#' Services account ID number as the `Id`. If you specify
#' `"Type": "EMAIL"`, you must specify the email address that is associated
#' with the account.
#' 
#' `--target Id=diego@@example.com,Type=EMAIL`
#' @param Notes Additional information that you want to include in the generated email
#' to the recipient account owner.
#' @param Tags A list of tags that you want to attach to the account when it becomes a
#' member of the organization. For each tag in the list, you must specify
#' both a tag key and a value. You can set the value to an empty string,
#' but you can't set it to `null`. For more information about tagging, see
#' [Tagging Organizations
#' resources](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html)
#' in the Organizations User Guide.
#' 
#' Any tags in the request are checked for compliance with any applicable
#' tag policies when the request is made. The request is rejected if the
#' tags in the request don't match the requirements of the policy at that
#' time. Tag policy compliance is *not* checked again when the invitation
#' is accepted and the tags are actually attached to the account. That
#' means that if the tag policy changes between the invitation and the
#' acceptance, then that tags could potentially be non-compliant.
#' 
#' If any one of the tags is not valid or if you exceed the allowed number
#' of tags for an account, then the entire request fails and invitations
#' are not sent.
#'
#' @keywords internal
#'
#' @rdname organizations_invite_account_to_organization
organizations_invite_account_to_organization <- function(Target, Notes = NULL, Tags = NULL) {
  op <- new_operation(
    name = "InviteAccountToOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$invite_account_to_organization_input(Target = Target, Notes = Notes, Tags = Tags)
  output <- .organizations$invite_account_to_organization_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$invite_account_to_organization <- organizations_invite_account_to_organization

#' Removes a member account from its parent organization
#'
#' @description
#' Removes a member account from its parent organization. This version of the operation is performed by the account that wants to leave. To remove a member account as a user in the management account, use [`remove_account_from_organization`][organizations_remove_account_from_organization] instead.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_leave_organization/](https://www.paws-r-sdk.com/docs/organizations_leave_organization/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname organizations_leave_organization
organizations_leave_organization <- function() {
  op <- new_operation(
    name = "LeaveOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$leave_organization_input()
  output <- .organizations$leave_organization_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$leave_organization <- organizations_leave_organization

#' Returns a list of the Amazon Web Services services that you enabled to
#' integrate with your organization
#'
#' @description
#' Returns a list of the Amazon Web Services services that you enabled to integrate with your organization. After a service on this list creates the resources that it requires for the integration, it can perform operations on your organization and its accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_list_aws_service_access_for_organization/](https://www.paws-r-sdk.com/docs/organizations_list_aws_service_access_for_organization/) for full documentation.
#'
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @keywords internal
#'
#' @rdname organizations_list_aws_service_access_for_organization
organizations_list_aws_service_access_for_organization <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAWSServiceAccessForOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .organizations$list_aws_service_access_for_organization_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_aws_service_access_for_organization_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_aws_service_access_for_organization <- organizations_list_aws_service_access_for_organization

#' Lists all the accounts in the organization
#'
#' @description
#' Lists all the accounts in the organization. To request only the accounts in a specified root or organizational unit (OU), use the [`list_accounts_for_parent`][organizations_list_accounts_for_parent] operation instead.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_list_accounts/](https://www.paws-r-sdk.com/docs/organizations_list_accounts/) for full documentation.
#'
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @keywords internal
#'
#' @rdname organizations_list_accounts
organizations_list_accounts <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAccounts",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .organizations$list_accounts_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_accounts_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_accounts <- organizations_list_accounts

#' Lists the accounts in an organization that are contained by the
#' specified target root or organizational unit (OU)
#'
#' @description
#' Lists the accounts in an organization that are contained by the specified target root or organizational unit (OU). If you specify the root, you get a list of all the accounts that aren't in any OU. If you specify an OU, you get a list of all the accounts in only that OU and not in any child OUs. To get a list of all accounts in the organization, use the [`list_accounts`][organizations_list_accounts] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_list_accounts_for_parent/](https://www.paws-r-sdk.com/docs/organizations_list_accounts_for_parent/) for full documentation.
#'
#' @param ParentId &#91;required&#93; The unique identifier (ID) for the parent root or organization unit (OU)
#' whose accounts you want to list.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @keywords internal
#'
#' @rdname organizations_list_accounts_for_parent
organizations_list_accounts_for_parent <- function(ParentId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAccountsForParent",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .organizations$list_accounts_for_parent_input(ParentId = ParentId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_accounts_for_parent_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_accounts_for_parent <- organizations_list_accounts_for_parent

#' Lists all of the organizational units (OUs) or accounts that are
#' contained in the specified parent OU or root
#'
#' @description
#' Lists all of the organizational units (OUs) or accounts that are contained in the specified parent OU or root. This operation, along with [`list_parents`][organizations_list_parents] enables you to traverse the tree structure that makes up this root.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_list_children/](https://www.paws-r-sdk.com/docs/organizations_list_children/) for full documentation.
#'
#' @param ParentId &#91;required&#93; The unique identifier (ID) for the parent root or OU whose children you
#' want to list.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a parent ID
#' string requires one of the following:
#' 
#' -   **Root** - A string that begins with "r-" followed by from 4 to 32
#'     lowercase letters or digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that the OU is in). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#' @param ChildType &#91;required&#93; Filters the output to include only the specified child type.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @keywords internal
#'
#' @rdname organizations_list_children
organizations_list_children <- function(ParentId, ChildType, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListChildren",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .organizations$list_children_input(ParentId = ParentId, ChildType = ChildType, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_children_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_children <- organizations_list_children

#' Lists the account creation requests that match the specified status that
#' is currently being tracked for the organization
#'
#' @description
#' Lists the account creation requests that match the specified status that is currently being tracked for the organization.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_list_create_account_status/](https://www.paws-r-sdk.com/docs/organizations_list_create_account_status/) for full documentation.
#'
#' @param States A list of one or more states that you want included in the response. If
#' this parameter isn't present, all requests are included in the response.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @keywords internal
#'
#' @rdname organizations_list_create_account_status
organizations_list_create_account_status <- function(States = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListCreateAccountStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .organizations$list_create_account_status_input(States = States, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_create_account_status_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_create_account_status <- organizations_list_create_account_status

#' Lists the Amazon Web Services accounts that are designated as delegated
#' administrators in this organization
#'
#' @description
#' Lists the Amazon Web Services accounts that are designated as delegated administrators in this organization.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_list_delegated_administrators/](https://www.paws-r-sdk.com/docs/organizations_list_delegated_administrators/) for full documentation.
#'
#' @param ServicePrincipal Specifies a service principal name. If specified, then the operation
#' lists the delegated administrators only for the specified service.
#' 
#' If you don't specify a service principal, the operation lists all
#' delegated administrators for all services in your organization.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @keywords internal
#'
#' @rdname organizations_list_delegated_administrators
organizations_list_delegated_administrators <- function(ServicePrincipal = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDelegatedAdministrators",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "DelegatedAdministrators")
  )
  input <- .organizations$list_delegated_administrators_input(ServicePrincipal = ServicePrincipal, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_delegated_administrators_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_delegated_administrators <- organizations_list_delegated_administrators

#' List the Amazon Web Services services for which the specified account is
#' a delegated administrator
#'
#' @description
#' List the Amazon Web Services services for which the specified account is a delegated administrator.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_list_delegated_services_for_account/](https://www.paws-r-sdk.com/docs/organizations_list_delegated_services_for_account/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID number of a delegated administrator account in the
#' organization.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @keywords internal
#'
#' @rdname organizations_list_delegated_services_for_account
organizations_list_delegated_services_for_account <- function(AccountId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDelegatedServicesForAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "DelegatedServices")
  )
  input <- .organizations$list_delegated_services_for_account_input(AccountId = AccountId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_delegated_services_for_account_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_delegated_services_for_account <- organizations_list_delegated_services_for_account

#' Lists the current handshakes that are associated with the account of the
#' requesting user
#'
#' @description
#' Lists the current handshakes that are associated with the account of the requesting user.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_list_handshakes_for_account/](https://www.paws-r-sdk.com/docs/organizations_list_handshakes_for_account/) for full documentation.
#'
#' @param Filter Filters the handshakes that you want included in the response. The
#' default is all types. Use the `ActionType` element to limit the output
#' to only a specified type, such as `INVITE`, `ENABLE_ALL_FEATURES`, or
#' `APPROVE_ALL_FEATURES`. Alternatively, for the `ENABLE_ALL_FEATURES`
#' handshake that generates a separate child handshake for each member
#' account, you can specify `ParentHandshakeId` to see only the handshakes
#' that were generated by that parent request.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @keywords internal
#'
#' @rdname organizations_list_handshakes_for_account
organizations_list_handshakes_for_account <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListHandshakesForAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .organizations$list_handshakes_for_account_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_handshakes_for_account_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_handshakes_for_account <- organizations_list_handshakes_for_account

#' Lists the handshakes that are associated with the organization that the
#' requesting user is part of
#'
#' @description
#' Lists the handshakes that are associated with the organization that the requesting user is part of. The [`list_handshakes_for_organization`][organizations_list_handshakes_for_organization] operation returns a list of handshake structures. Each structure contains details and status about a handshake.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_list_handshakes_for_organization/](https://www.paws-r-sdk.com/docs/organizations_list_handshakes_for_organization/) for full documentation.
#'
#' @param Filter A filter of the handshakes that you want included in the response. The
#' default is all types. Use the `ActionType` element to limit the output
#' to only a specified type, such as `INVITE`, `ENABLE-ALL-FEATURES`, or
#' `APPROVE-ALL-FEATURES`. Alternatively, for the `ENABLE-ALL-FEATURES`
#' handshake that generates a separate child handshake for each member
#' account, you can specify the `ParentHandshakeId` to see only the
#' handshakes that were generated by that parent request.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @keywords internal
#'
#' @rdname organizations_list_handshakes_for_organization
organizations_list_handshakes_for_organization <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListHandshakesForOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .organizations$list_handshakes_for_organization_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_handshakes_for_organization_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_handshakes_for_organization <- organizations_list_handshakes_for_organization

#' Lists the organizational units (OUs) in a parent organizational unit or
#' root
#'
#' @description
#' Lists the organizational units (OUs) in a parent organizational unit or root.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_list_organizational_units_for_parent/](https://www.paws-r-sdk.com/docs/organizations_list_organizational_units_for_parent/) for full documentation.
#'
#' @param ParentId &#91;required&#93; The unique identifier (ID) of the root or OU whose child OUs you want to
#' list.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a parent ID
#' string requires one of the following:
#' 
#' -   **Root** - A string that begins with "r-" followed by from 4 to 32
#'     lowercase letters or digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that the OU is in). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @keywords internal
#'
#' @rdname organizations_list_organizational_units_for_parent
organizations_list_organizational_units_for_parent <- function(ParentId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListOrganizationalUnitsForParent",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .organizations$list_organizational_units_for_parent_input(ParentId = ParentId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_organizational_units_for_parent_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_organizational_units_for_parent <- organizations_list_organizational_units_for_parent

#' Lists the root or organizational units (OUs) that serve as the immediate
#' parent of the specified child OU or account
#'
#' @description
#' Lists the root or organizational units (OUs) that serve as the immediate parent of the specified child OU or account. This operation, along with [`list_children`][organizations_list_children] enables you to traverse the tree structure that makes up this root.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_list_parents/](https://www.paws-r-sdk.com/docs/organizations_list_parents/) for full documentation.
#'
#' @param ChildId &#91;required&#93; The unique identifier (ID) of the OU or account whose parent containers
#' you want to list. Don't specify a root.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a child ID
#' string requires one of the following:
#' 
#' -   **Account** - A string that consists of exactly 12 digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that contains the OU). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @keywords internal
#'
#' @rdname organizations_list_parents
organizations_list_parents <- function(ChildId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListParents",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .organizations$list_parents_input(ChildId = ChildId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_parents_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_parents <- organizations_list_parents

#' Retrieves the list of all policies in an organization of a specified
#' type
#'
#' @description
#' Retrieves the list of all policies in an organization of a specified type.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_list_policies/](https://www.paws-r-sdk.com/docs/organizations_list_policies/) for full documentation.
#'
#' @param Filter &#91;required&#93; Specifies the type of policy that you want to include in the response.
#' You must specify one of the following values:
#' 
#' -   [AISERVICES_OPT_OUT_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
#' 
#' -   [BACKUP_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
#' 
#' -   [SERVICE_CONTROL_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps.html)
#' 
#' -   [TAG_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @keywords internal
#'
#' @rdname organizations_list_policies
organizations_list_policies <- function(Filter, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .organizations$list_policies_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_policies_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_policies <- organizations_list_policies

#' Lists the policies that are directly attached to the specified target
#' root, organizational unit (OU), or account
#'
#' @description
#' Lists the policies that are directly attached to the specified target root, organizational unit (OU), or account. You must specify the policy type that you want included in the returned list.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_list_policies_for_target/](https://www.paws-r-sdk.com/docs/organizations_list_policies_for_target/) for full documentation.
#'
#' @param TargetId &#91;required&#93; The unique identifier (ID) of the root, organizational unit, or account
#' whose policies you want to list.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a target ID
#' string requires one of the following:
#' 
#' -   **Root** - A string that begins with "r-" followed by from 4 to 32
#'     lowercase letters or digits.
#' 
#' -   **Account** - A string that consists of exactly 12 digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that the OU is in). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#' @param Filter &#91;required&#93; The type of policy that you want to include in the returned list. You
#' must specify one of the following values:
#' 
#' -   [AISERVICES_OPT_OUT_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
#' 
#' -   [BACKUP_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
#' 
#' -   [SERVICE_CONTROL_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps.html)
#' 
#' -   [TAG_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @keywords internal
#'
#' @rdname organizations_list_policies_for_target
organizations_list_policies_for_target <- function(TargetId, Filter, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPoliciesForTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .organizations$list_policies_for_target_input(TargetId = TargetId, Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_policies_for_target_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_policies_for_target <- organizations_list_policies_for_target

#' Lists the roots that are defined in the current organization
#'
#' @description
#' Lists the roots that are defined in the current organization.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_list_roots/](https://www.paws-r-sdk.com/docs/organizations_list_roots/) for full documentation.
#'
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @keywords internal
#'
#' @rdname organizations_list_roots
organizations_list_roots <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListRoots",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .organizations$list_roots_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_roots_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_roots <- organizations_list_roots

#' Lists tags that are attached to the specified resource
#'
#' @description
#' Lists tags that are attached to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/organizations_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The ID of the resource with the tags to list.
#' 
#' You can specify any of the following taggable resources.
#' 
#' -   Amazon Web Services account – specify the account ID number.
#' 
#' -   Organizational unit – specify the OU ID that begins with `ou-` and
#'     looks similar to: `ou-1a2b-34uvwxyz `
#' 
#' -   Root – specify the root ID that begins with `r-` and looks similar
#'     to: `r-1a2b `
#' 
#' -   Policy – specify the policy ID that begins with `p-` andlooks
#'     similar to: `p-12abcdefg3 `
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#'
#' @keywords internal
#'
#' @rdname organizations_list_tags_for_resource
organizations_list_tags_for_resource <- function(ResourceId, NextToken = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "Tags")
  )
  input <- .organizations$list_tags_for_resource_input(ResourceId = ResourceId, NextToken = NextToken)
  output <- .organizations$list_tags_for_resource_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_tags_for_resource <- organizations_list_tags_for_resource

#' Lists all the roots, organizational units (OUs), and accounts that the
#' specified policy is attached to
#'
#' @description
#' Lists all the roots, organizational units (OUs), and accounts that the specified policy is attached to.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_list_targets_for_policy/](https://www.paws-r-sdk.com/docs/organizations_list_targets_for_policy/) for full documentation.
#'
#' @param PolicyId &#91;required&#93; The unique identifier (ID) of the policy whose attachments you want to
#' know.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a policy ID
#' string requires "p-" followed by from 8 to 128 lowercase or uppercase
#' letters, digits, or the underscore character (_).
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @keywords internal
#'
#' @rdname organizations_list_targets_for_policy
organizations_list_targets_for_policy <- function(PolicyId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTargetsForPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .organizations$list_targets_for_policy_input(PolicyId = PolicyId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_targets_for_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_targets_for_policy <- organizations_list_targets_for_policy

#' Moves an account from its current source parent root or organizational
#' unit (OU) to the specified destination parent root or OU
#'
#' @description
#' Moves an account from its current source parent root or organizational unit (OU) to the specified destination parent root or OU.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_move_account/](https://www.paws-r-sdk.com/docs/organizations_move_account/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The unique identifier (ID) of the account that you want to move.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for an account
#' ID string requires exactly 12 digits.
#' @param SourceParentId &#91;required&#93; The unique identifier (ID) of the root or organizational unit that you
#' want to move the account from.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a parent ID
#' string requires one of the following:
#' 
#' -   **Root** - A string that begins with "r-" followed by from 4 to 32
#'     lowercase letters or digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that the OU is in). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#' @param DestinationParentId &#91;required&#93; The unique identifier (ID) of the root or organizational unit that you
#' want to move the account to.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a parent ID
#' string requires one of the following:
#' 
#' -   **Root** - A string that begins with "r-" followed by from 4 to 32
#'     lowercase letters or digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that the OU is in). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#'
#' @keywords internal
#'
#' @rdname organizations_move_account
organizations_move_account <- function(AccountId, SourceParentId, DestinationParentId) {
  op <- new_operation(
    name = "MoveAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$move_account_input(AccountId = AccountId, SourceParentId = SourceParentId, DestinationParentId = DestinationParentId)
  output <- .organizations$move_account_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$move_account <- organizations_move_account

#' Creates or updates a resource policy
#'
#' @description
#' Creates or updates a resource policy.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_put_resource_policy/](https://www.paws-r-sdk.com/docs/organizations_put_resource_policy/) for full documentation.
#'
#' @param Content &#91;required&#93; If provided, the new content for the resource policy. The text must be
#' correctly formatted JSON that complies with the syntax for the resource
#' policy's type. For more information, see [SCP
#' syntax](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps_syntax.html)
#' in the *Organizations User Guide*.
#' @param Tags A list of tags that you want to attach to the newly created resource
#' policy. For each tag in the list, you must specify both a tag key and a
#' value. You can set the value to an empty string, but you can't set it to
#' `null`. For more information about tagging, see [Tagging Organizations
#' resources](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html)
#' in the Organizations User Guide.
#' 
#' Calls with tags apply to the initial creation of the resource policy,
#' otherwise an exception is thrown. If any one of the tags is not valid or
#' if you exceed the allowed number of tags for the resource policy, then
#' the entire request fails and the resource policy is not created.
#'
#' @keywords internal
#'
#' @rdname organizations_put_resource_policy
organizations_put_resource_policy <- function(Content, Tags = NULL) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$put_resource_policy_input(Content = Content, Tags = Tags)
  output <- .organizations$put_resource_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$put_resource_policy <- organizations_put_resource_policy

#' Enables the specified member account to administer the Organizations
#' features of the specified Amazon Web Services service
#'
#' @description
#' Enables the specified member account to administer the Organizations features of the specified Amazon Web Services service. It grants read-only access to Organizations service data. The account still requires IAM permissions to access and administer the Amazon Web Services service.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_register_delegated_administrator/](https://www.paws-r-sdk.com/docs/organizations_register_delegated_administrator/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID number of the member account in the organization to
#' register as a delegated administrator.
#' @param ServicePrincipal &#91;required&#93; The service principal of the Amazon Web Services service for which you
#' want to make the member account a delegated administrator.
#'
#' @keywords internal
#'
#' @rdname organizations_register_delegated_administrator
organizations_register_delegated_administrator <- function(AccountId, ServicePrincipal) {
  op <- new_operation(
    name = "RegisterDelegatedAdministrator",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$register_delegated_administrator_input(AccountId = AccountId, ServicePrincipal = ServicePrincipal)
  output <- .organizations$register_delegated_administrator_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$register_delegated_administrator <- organizations_register_delegated_administrator

#' Removes the specified account from the organization
#'
#' @description
#' Removes the specified account from the organization.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_remove_account_from_organization/](https://www.paws-r-sdk.com/docs/organizations_remove_account_from_organization/) for full documentation.
#'
#' @param AccountId &#91;required&#93; The unique identifier (ID) of the member account that you want to remove
#' from the organization.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for an account
#' ID string requires exactly 12 digits.
#'
#' @keywords internal
#'
#' @rdname organizations_remove_account_from_organization
organizations_remove_account_from_organization <- function(AccountId) {
  op <- new_operation(
    name = "RemoveAccountFromOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$remove_account_from_organization_input(AccountId = AccountId)
  output <- .organizations$remove_account_from_organization_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$remove_account_from_organization <- organizations_remove_account_from_organization

#' Adds one or more tags to the specified resource
#'
#' @description
#' Adds one or more tags to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_tag_resource/](https://www.paws-r-sdk.com/docs/organizations_tag_resource/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The ID of the resource to add a tag to.
#' 
#' You can specify any of the following taggable resources.
#' 
#' -   Amazon Web Services account – specify the account ID number.
#' 
#' -   Organizational unit – specify the OU ID that begins with `ou-` and
#'     looks similar to: `ou-1a2b-34uvwxyz `
#' 
#' -   Root – specify the root ID that begins with `r-` and looks similar
#'     to: `r-1a2b `
#' 
#' -   Policy – specify the policy ID that begins with `p-` andlooks
#'     similar to: `p-12abcdefg3 `
#' @param Tags &#91;required&#93; A list of tags to add to the specified resource.
#' 
#' For each tag in the list, you must specify both a tag key and a value.
#' The value can be an empty string, but you can't set it to `null`.
#' 
#' If any one of the tags is not valid or if you exceed the maximum allowed
#' number of tags for a resource, then the entire request fails.
#'
#' @keywords internal
#'
#' @rdname organizations_tag_resource
organizations_tag_resource <- function(ResourceId, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$tag_resource_input(ResourceId = ResourceId, Tags = Tags)
  output <- .organizations$tag_resource_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$tag_resource <- organizations_tag_resource

#' Removes any tags with the specified keys from the specified resource
#'
#' @description
#' Removes any tags with the specified keys from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_untag_resource/](https://www.paws-r-sdk.com/docs/organizations_untag_resource/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The ID of the resource to remove a tag from.
#' 
#' You can specify any of the following taggable resources.
#' 
#' -   Amazon Web Services account – specify the account ID number.
#' 
#' -   Organizational unit – specify the OU ID that begins with `ou-` and
#'     looks similar to: `ou-1a2b-34uvwxyz `
#' 
#' -   Root – specify the root ID that begins with `r-` and looks similar
#'     to: `r-1a2b `
#' 
#' -   Policy – specify the policy ID that begins with `p-` andlooks
#'     similar to: `p-12abcdefg3 `
#' @param TagKeys &#91;required&#93; The list of keys for tags to remove from the specified resource.
#'
#' @keywords internal
#'
#' @rdname organizations_untag_resource
organizations_untag_resource <- function(ResourceId, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$untag_resource_input(ResourceId = ResourceId, TagKeys = TagKeys)
  output <- .organizations$untag_resource_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$untag_resource <- organizations_untag_resource

#' Renames the specified organizational unit (OU)
#'
#' @description
#' Renames the specified organizational unit (OU). The ID and ARN don't change. The child OUs and accounts remain in place, and any attached policies of the OU remain attached.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_update_organizational_unit/](https://www.paws-r-sdk.com/docs/organizations_update_organizational_unit/) for full documentation.
#'
#' @param OrganizationalUnitId &#91;required&#93; The unique identifier (ID) of the OU that you want to rename. You can
#' get the ID from the
#' [`list_organizational_units_for_parent`][organizations_list_organizational_units_for_parent]
#' operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for an
#' organizational unit ID string requires "ou-" followed by from 4 to 32
#' lowercase letters or digits (the ID of the root that contains the OU).
#' This string is followed by a second "-" dash and from 8 to 32 additional
#' lowercase letters or digits.
#' @param Name The new name that you want to assign to the OU.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) that is used to
#' validate this parameter is a string of any of the characters in the
#' ASCII character range.
#'
#' @keywords internal
#'
#' @rdname organizations_update_organizational_unit
organizations_update_organizational_unit <- function(OrganizationalUnitId, Name = NULL) {
  op <- new_operation(
    name = "UpdateOrganizationalUnit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$update_organizational_unit_input(OrganizationalUnitId = OrganizationalUnitId, Name = Name)
  output <- .organizations$update_organizational_unit_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$update_organizational_unit <- organizations_update_organizational_unit

#' Updates an existing policy with a new name, description, or content
#'
#' @description
#' Updates an existing policy with a new name, description, or content. If you don't supply any parameter, that value remains unchanged. You can't change a policy's type.
#'
#' See [https://www.paws-r-sdk.com/docs/organizations_update_policy/](https://www.paws-r-sdk.com/docs/organizations_update_policy/) for full documentation.
#'
#' @param PolicyId &#91;required&#93; The unique identifier (ID) of the policy that you want to update.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a policy ID
#' string requires "p-" followed by from 8 to 128 lowercase or uppercase
#' letters, digits, or the underscore character (_).
#' @param Name If provided, the new name for the policy.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) that is used to
#' validate this parameter is a string of any of the characters in the
#' ASCII character range.
#' @param Description If provided, the new description for the policy.
#' @param Content If provided, the new content for the policy. The text must be correctly
#' formatted JSON that complies with the syntax for the policy's type. For
#' more information, see [SCP
#' syntax](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps_syntax.html)
#' in the *Organizations User Guide*.
#' 
#' The maximum size of a policy document depends on the policy's type. For
#' more information, see [Maximum and minimum
#' values](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html#min-max-values)
#' in the *Organizations User Guide*.
#'
#' @keywords internal
#'
#' @rdname organizations_update_policy
organizations_update_policy <- function(PolicyId, Name = NULL, Description = NULL, Content = NULL) {
  op <- new_operation(
    name = "UpdatePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$update_policy_input(PolicyId = PolicyId, Name = Name, Description = Description, Content = Content)
  output <- .organizations$update_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$update_policy <- organizations_update_policy
