% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finspace_operations.R
\name{finspace_create_kx_dataview}
\alias{finspace_create_kx_dataview}
\title{Creates a snapshot of kdb database with tiered storage capabilities and
a pre-warmed cache, ready for mounting on kdb clusters}
\usage{
finspace_create_kx_dataview(
  environmentId,
  databaseName,
  dataviewName,
  azMode,
  availabilityZoneId = NULL,
  changesetId = NULL,
  segmentConfigurations = NULL,
  autoUpdate = NULL,
  description = NULL,
  tags = NULL,
  clientToken
)
}
\arguments{
\item{environmentId}{[required] A unique identifier for the kdb environment, where you want to create
the dataview.}

\item{databaseName}{[required] The name of the database where you want to create a dataview.}

\item{dataviewName}{[required] A unique identifier for the dataview.}

\item{azMode}{[required] The number of availability zones you want to assign per cluster. This
can be one of the following
\itemize{
\item \code{SINGLE} – Assigns one availability zone per cluster.
\item \code{MULTI} – Assigns all the availability zones per cluster.
}}

\item{availabilityZoneId}{The identifier of the availability zones.}

\item{changesetId}{A unique identifier of the changeset that you want to use to ingest
data.}

\item{segmentConfigurations}{The configuration that contains the database path of the data that you
want to place on each selected volume. Each segment must have a unique
database path for each volume. If you do not explicitly specify any
database path for a volume, they are accessible from the cluster through
the default S3/object store segment.}

\item{autoUpdate}{The option to specify whether you want to apply all the future additions
and corrections automatically to the dataview, when you ingest new
changesets. The default value is false.}

\item{description}{A description of the dataview.}

\item{tags}{A list of key-value pairs to label the dataview. You can add up to 50
tags to a dataview.}

\item{clientToken}{[required] A token that ensures idempotency. This token expires in 10 minutes.}
}
\description{
Creates a snapshot of kdb database with tiered storage capabilities and a pre-warmed cache, ready for mounting on kdb clusters. Dataviews are only available for clusters running on a scaling group. They are not supported on dedicated clusters.

See \url{https://www.paws-r-sdk.com/docs/finspace_create_kx_dataview/} for full documentation.
}
\keyword{internal}
