# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include applicationinsights_service.R
NULL

#' Adds a workload to a component
#'
#' @description
#' Adds a workload to a component. Each component can have at most five workloads.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_add_workload/](https://www.paws-r-sdk.com/docs/applicationinsights_add_workload/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param WorkloadConfiguration &#91;required&#93; The configuration settings of the workload. The value is the escaped
#' JSON of the configuration.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_add_workload
applicationinsights_add_workload <- function(ResourceGroupName, ComponentName, WorkloadConfiguration) {
  op <- new_operation(
    name = "AddWorkload",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$add_workload_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, WorkloadConfiguration = WorkloadConfiguration)
  output <- .applicationinsights$add_workload_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$add_workload <- applicationinsights_add_workload

#' Adds an application that is created from a resource group
#'
#' @description
#' Adds an application that is created from a resource group.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_create_application/](https://www.paws-r-sdk.com/docs/applicationinsights_create_application/) for full documentation.
#'
#' @param ResourceGroupName The name of the resource group.
#' @param OpsCenterEnabled When set to `true`, creates opsItems for any problems detected on an
#' application.
#' @param CWEMonitorEnabled Indicates whether Application Insights can listen to CloudWatch events
#' for the application resources, such as `instance terminated`,
#' `failed deployment`, and others.
#' @param OpsItemSNSTopicArn The SNS topic provided to Application Insights that is associated to the
#' created opsItem. Allows you to receive notifications for updates to the
#' opsItem.
#' @param Tags List of tags to add to the application. tag key (`Key`) and an
#' associated tag value (`Value`). The maximum length of a tag key is 128
#' characters. The maximum length of a tag value is 256 characters.
#' @param AutoConfigEnabled Indicates whether Application Insights automatically configures
#' unmonitored resources in the resource group.
#' @param AutoCreate Configures all of the resources in the resource group by applying the
#' recommended configurations.
#' @param GroupingType Application Insights can create applications based on a resource group
#' or on an account. To create an account-based application using all of
#' the resources in the account, set this parameter to `ACCOUNT_BASED`.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_create_application
applicationinsights_create_application <- function(ResourceGroupName = NULL, OpsCenterEnabled = NULL, CWEMonitorEnabled = NULL, OpsItemSNSTopicArn = NULL, Tags = NULL, AutoConfigEnabled = NULL, AutoCreate = NULL, GroupingType = NULL) {
  op <- new_operation(
    name = "CreateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$create_application_input(ResourceGroupName = ResourceGroupName, OpsCenterEnabled = OpsCenterEnabled, CWEMonitorEnabled = CWEMonitorEnabled, OpsItemSNSTopicArn = OpsItemSNSTopicArn, Tags = Tags, AutoConfigEnabled = AutoConfigEnabled, AutoCreate = AutoCreate, GroupingType = GroupingType)
  output <- .applicationinsights$create_application_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$create_application <- applicationinsights_create_application

#' Creates a custom component by grouping similar standalone instances to
#' monitor
#'
#' @description
#' Creates a custom component by grouping similar standalone instances to monitor.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_create_component/](https://www.paws-r-sdk.com/docs/applicationinsights_create_component/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param ResourceList &#91;required&#93; The list of resource ARNs that belong to the component.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_create_component
applicationinsights_create_component <- function(ResourceGroupName, ComponentName, ResourceList) {
  op <- new_operation(
    name = "CreateComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$create_component_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, ResourceList = ResourceList)
  output <- .applicationinsights$create_component_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$create_component <- applicationinsights_create_component

#' Adds an log pattern to a LogPatternSet
#'
#' @description
#' Adds an log pattern to a `LogPatternSet`.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_create_log_pattern/](https://www.paws-r-sdk.com/docs/applicationinsights_create_log_pattern/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param PatternSetName &#91;required&#93; The name of the log pattern set.
#' @param PatternName &#91;required&#93; The name of the log pattern.
#' @param Pattern &#91;required&#93; The log pattern. The pattern must be DFA compatible. Patterns that
#' utilize forward lookahead or backreference constructions are not
#' supported.
#' @param Rank &#91;required&#93; Rank of the log pattern. Must be a value between `1` and `1,000,000`.
#' The patterns are sorted by rank, so we recommend that you set your
#' highest priority patterns with the lowest rank. A pattern of rank `1`
#' will be the first to get matched to a log line. A pattern of rank
#' `1,000,000` will be last to get matched. When you configure custom log
#' patterns from the console, a `Low` severity pattern translates to a
#' `750,000` rank. A `Medium` severity pattern translates to a `500,000`
#' rank. And a `High` severity pattern translates to a `250,000` rank. Rank
#' values less than `1` or greater than `1,000,000` are reserved for
#' AWS-provided patterns.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_create_log_pattern
applicationinsights_create_log_pattern <- function(ResourceGroupName, PatternSetName, PatternName, Pattern, Rank) {
  op <- new_operation(
    name = "CreateLogPattern",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$create_log_pattern_input(ResourceGroupName = ResourceGroupName, PatternSetName = PatternSetName, PatternName = PatternName, Pattern = Pattern, Rank = Rank)
  output <- .applicationinsights$create_log_pattern_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$create_log_pattern <- applicationinsights_create_log_pattern

#' Removes the specified application from monitoring
#'
#' @description
#' Removes the specified application from monitoring. Does not delete the application.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_delete_application/](https://www.paws-r-sdk.com/docs/applicationinsights_delete_application/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_delete_application
applicationinsights_delete_application <- function(ResourceGroupName) {
  op <- new_operation(
    name = "DeleteApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$delete_application_input(ResourceGroupName = ResourceGroupName)
  output <- .applicationinsights$delete_application_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$delete_application <- applicationinsights_delete_application

#' Ungroups a custom component
#'
#' @description
#' Ungroups a custom component. When you ungroup custom components, all applicable monitors that are set up for the component are removed and the instances revert to their standalone status.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_delete_component/](https://www.paws-r-sdk.com/docs/applicationinsights_delete_component/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_delete_component
applicationinsights_delete_component <- function(ResourceGroupName, ComponentName) {
  op <- new_operation(
    name = "DeleteComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$delete_component_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName)
  output <- .applicationinsights$delete_component_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$delete_component <- applicationinsights_delete_component

#' Removes the specified log pattern from a LogPatternSet
#'
#' @description
#' Removes the specified log pattern from a `LogPatternSet`.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_delete_log_pattern/](https://www.paws-r-sdk.com/docs/applicationinsights_delete_log_pattern/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param PatternSetName &#91;required&#93; The name of the log pattern set.
#' @param PatternName &#91;required&#93; The name of the log pattern.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_delete_log_pattern
applicationinsights_delete_log_pattern <- function(ResourceGroupName, PatternSetName, PatternName) {
  op <- new_operation(
    name = "DeleteLogPattern",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$delete_log_pattern_input(ResourceGroupName = ResourceGroupName, PatternSetName = PatternSetName, PatternName = PatternName)
  output <- .applicationinsights$delete_log_pattern_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$delete_log_pattern <- applicationinsights_delete_log_pattern

#' Describes the application
#'
#' @description
#' Describes the application.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_describe_application/](https://www.paws-r-sdk.com/docs/applicationinsights_describe_application/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param AccountId The AWS account ID for the resource group owner.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_application
applicationinsights_describe_application <- function(ResourceGroupName, AccountId = NULL) {
  op <- new_operation(
    name = "DescribeApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_application_input(ResourceGroupName = ResourceGroupName, AccountId = AccountId)
  output <- .applicationinsights$describe_application_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_application <- applicationinsights_describe_application

#' Describes a component and lists the resources that are grouped together
#' in a component
#'
#' @description
#' Describes a component and lists the resources that are grouped together in a component.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_describe_component/](https://www.paws-r-sdk.com/docs/applicationinsights_describe_component/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param AccountId The AWS account ID for the resource group owner.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_component
applicationinsights_describe_component <- function(ResourceGroupName, ComponentName, AccountId = NULL) {
  op <- new_operation(
    name = "DescribeComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_component_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, AccountId = AccountId)
  output <- .applicationinsights$describe_component_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_component <- applicationinsights_describe_component

#' Describes the monitoring configuration of the component
#'
#' @description
#' Describes the monitoring configuration of the component.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_describe_component_configuration/](https://www.paws-r-sdk.com/docs/applicationinsights_describe_component_configuration/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param AccountId The AWS account ID for the resource group owner.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_component_configuration
applicationinsights_describe_component_configuration <- function(ResourceGroupName, ComponentName, AccountId = NULL) {
  op <- new_operation(
    name = "DescribeComponentConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_component_configuration_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, AccountId = AccountId)
  output <- .applicationinsights$describe_component_configuration_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_component_configuration <- applicationinsights_describe_component_configuration

#' Describes the recommended monitoring configuration of the component
#'
#' @description
#' Describes the recommended monitoring configuration of the component.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_describe_component_configuration_recommendation/](https://www.paws-r-sdk.com/docs/applicationinsights_describe_component_configuration_recommendation/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param Tier &#91;required&#93; The tier of the application component.
#' @param RecommendationType The recommended configuration type.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_descri_compon_config_recomm
applicationinsights_describe_component_configuration_recommendation <- function(ResourceGroupName, ComponentName, Tier, RecommendationType = NULL) {
  op <- new_operation(
    name = "DescribeComponentConfigurationRecommendation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_component_configuration_recommendation_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, Tier = Tier, RecommendationType = RecommendationType)
  output <- .applicationinsights$describe_component_configuration_recommendation_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_component_configuration_recommendation <- applicationinsights_describe_component_configuration_recommendation

#' Describe a specific log pattern from a LogPatternSet
#'
#' @description
#' Describe a specific log pattern from a `LogPatternSet`.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_describe_log_pattern/](https://www.paws-r-sdk.com/docs/applicationinsights_describe_log_pattern/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param PatternSetName &#91;required&#93; The name of the log pattern set.
#' @param PatternName &#91;required&#93; The name of the log pattern.
#' @param AccountId The AWS account ID for the resource group owner.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_log_pattern
applicationinsights_describe_log_pattern <- function(ResourceGroupName, PatternSetName, PatternName, AccountId = NULL) {
  op <- new_operation(
    name = "DescribeLogPattern",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_log_pattern_input(ResourceGroupName = ResourceGroupName, PatternSetName = PatternSetName, PatternName = PatternName, AccountId = AccountId)
  output <- .applicationinsights$describe_log_pattern_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_log_pattern <- applicationinsights_describe_log_pattern

#' Describes an anomaly or error with the application
#'
#' @description
#' Describes an anomaly or error with the application.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_describe_observation/](https://www.paws-r-sdk.com/docs/applicationinsights_describe_observation/) for full documentation.
#'
#' @param ObservationId &#91;required&#93; The ID of the observation.
#' @param AccountId The AWS account ID for the resource group owner.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_observation
applicationinsights_describe_observation <- function(ObservationId, AccountId = NULL) {
  op <- new_operation(
    name = "DescribeObservation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_observation_input(ObservationId = ObservationId, AccountId = AccountId)
  output <- .applicationinsights$describe_observation_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_observation <- applicationinsights_describe_observation

#' Describes an application problem
#'
#' @description
#' Describes an application problem.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_describe_problem/](https://www.paws-r-sdk.com/docs/applicationinsights_describe_problem/) for full documentation.
#'
#' @param ProblemId &#91;required&#93; The ID of the problem.
#' @param AccountId The AWS account ID for the owner of the resource group affected by the
#' problem.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_problem
applicationinsights_describe_problem <- function(ProblemId, AccountId = NULL) {
  op <- new_operation(
    name = "DescribeProblem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_problem_input(ProblemId = ProblemId, AccountId = AccountId)
  output <- .applicationinsights$describe_problem_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_problem <- applicationinsights_describe_problem

#' Describes the anomalies or errors associated with the problem
#'
#' @description
#' Describes the anomalies or errors associated with the problem.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_describe_problem_observations/](https://www.paws-r-sdk.com/docs/applicationinsights_describe_problem_observations/) for full documentation.
#'
#' @param ProblemId &#91;required&#93; The ID of the problem.
#' @param AccountId The AWS account ID for the resource group owner.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_problem_observations
applicationinsights_describe_problem_observations <- function(ProblemId, AccountId = NULL) {
  op <- new_operation(
    name = "DescribeProblemObservations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_problem_observations_input(ProblemId = ProblemId, AccountId = AccountId)
  output <- .applicationinsights$describe_problem_observations_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_problem_observations <- applicationinsights_describe_problem_observations

#' Describes a workload and its configuration
#'
#' @description
#' Describes a workload and its configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_describe_workload/](https://www.paws-r-sdk.com/docs/applicationinsights_describe_workload/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param WorkloadId &#91;required&#93; The ID of the workload.
#' @param AccountId The AWS account ID for the workload owner.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_workload
applicationinsights_describe_workload <- function(ResourceGroupName, ComponentName, WorkloadId, AccountId = NULL) {
  op <- new_operation(
    name = "DescribeWorkload",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_workload_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, WorkloadId = WorkloadId, AccountId = AccountId)
  output <- .applicationinsights$describe_workload_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_workload <- applicationinsights_describe_workload

#' Lists the IDs of the applications that you are monitoring
#'
#' @description
#' Lists the IDs of the applications that you are monitoring.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_list_applications/](https://www.paws-r-sdk.com/docs/applicationinsights_list_applications/) for full documentation.
#'
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token to request the next page of results.
#' @param AccountId The AWS account ID for the resource group owner.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_applications
applicationinsights_list_applications <- function(MaxResults = NULL, NextToken = NULL, AccountId = NULL) {
  op <- new_operation(
    name = "ListApplications",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .applicationinsights$list_applications_input(MaxResults = MaxResults, NextToken = NextToken, AccountId = AccountId)
  output <- .applicationinsights$list_applications_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_applications <- applicationinsights_list_applications

#' Lists the auto-grouped, standalone, and custom components of the
#' application
#'
#' @description
#' Lists the auto-grouped, standalone, and custom components of the application.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_list_components/](https://www.paws-r-sdk.com/docs/applicationinsights_list_components/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token to request the next page of results.
#' @param AccountId The AWS account ID for the resource group owner.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_components
applicationinsights_list_components <- function(ResourceGroupName, MaxResults = NULL, NextToken = NULL, AccountId = NULL) {
  op <- new_operation(
    name = "ListComponents",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .applicationinsights$list_components_input(ResourceGroupName = ResourceGroupName, MaxResults = MaxResults, NextToken = NextToken, AccountId = AccountId)
  output <- .applicationinsights$list_components_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_components <- applicationinsights_list_components

#' Lists the INFO, WARN, and ERROR events for periodic configuration
#' updates performed by Application Insights
#'
#' @description
#' Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights. Examples of events represented are:
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_list_configuration_history/](https://www.paws-r-sdk.com/docs/applicationinsights_list_configuration_history/) for full documentation.
#'
#' @param ResourceGroupName Resource group to which the application belongs.
#' @param StartTime The start time of the event.
#' @param EndTime The end time of the event.
#' @param EventStatus The status of the configuration update event. Possible values include
#' INFO, WARN, and ERROR.
#' @param MaxResults The maximum number of results returned by
#' [`list_configuration_history`][applicationinsights_list_configuration_history]
#' in paginated output. When this parameter is used,
#' [`list_configuration_history`][applicationinsights_list_configuration_history]
#' returns only `MaxResults` in a single page along with a `NextToken`
#' response element. The remaining results of the initial request can be
#' seen by sending another
#' [`list_configuration_history`][applicationinsights_list_configuration_history]
#' request with the returned `NextToken` value. If this parameter is not
#' used, then
#' [`list_configuration_history`][applicationinsights_list_configuration_history]
#' returns all results.
#' @param NextToken The `NextToken` value returned from a previous paginated
#' [`list_configuration_history`][applicationinsights_list_configuration_history]
#' request where `MaxResults` was used and the results exceeded the value
#' of that parameter. Pagination continues from the end of the previous
#' results that returned the `NextToken` value. This value is `null` when
#' there are no more results to return.
#' @param AccountId The AWS account ID for the resource group owner.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_configuration_history
applicationinsights_list_configuration_history <- function(ResourceGroupName = NULL, StartTime = NULL, EndTime = NULL, EventStatus = NULL, MaxResults = NULL, NextToken = NULL, AccountId = NULL) {
  op <- new_operation(
    name = "ListConfigurationHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .applicationinsights$list_configuration_history_input(ResourceGroupName = ResourceGroupName, StartTime = StartTime, EndTime = EndTime, EventStatus = EventStatus, MaxResults = MaxResults, NextToken = NextToken, AccountId = AccountId)
  output <- .applicationinsights$list_configuration_history_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_configuration_history <- applicationinsights_list_configuration_history

#' Lists the log pattern sets in the specific application
#'
#' @description
#' Lists the log pattern sets in the specific application.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_list_log_pattern_sets/](https://www.paws-r-sdk.com/docs/applicationinsights_list_log_pattern_sets/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token to request the next page of results.
#' @param AccountId The AWS account ID for the resource group owner.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_log_pattern_sets
applicationinsights_list_log_pattern_sets <- function(ResourceGroupName, MaxResults = NULL, NextToken = NULL, AccountId = NULL) {
  op <- new_operation(
    name = "ListLogPatternSets",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .applicationinsights$list_log_pattern_sets_input(ResourceGroupName = ResourceGroupName, MaxResults = MaxResults, NextToken = NextToken, AccountId = AccountId)
  output <- .applicationinsights$list_log_pattern_sets_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_log_pattern_sets <- applicationinsights_list_log_pattern_sets

#' Lists the log patterns in the specific log LogPatternSet
#'
#' @description
#' Lists the log patterns in the specific log `LogPatternSet`.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_list_log_patterns/](https://www.paws-r-sdk.com/docs/applicationinsights_list_log_patterns/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param PatternSetName The name of the log pattern set.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token to request the next page of results.
#' @param AccountId The AWS account ID for the resource group owner.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_log_patterns
applicationinsights_list_log_patterns <- function(ResourceGroupName, PatternSetName = NULL, MaxResults = NULL, NextToken = NULL, AccountId = NULL) {
  op <- new_operation(
    name = "ListLogPatterns",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .applicationinsights$list_log_patterns_input(ResourceGroupName = ResourceGroupName, PatternSetName = PatternSetName, MaxResults = MaxResults, NextToken = NextToken, AccountId = AccountId)
  output <- .applicationinsights$list_log_patterns_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_log_patterns <- applicationinsights_list_log_patterns

#' Lists the problems with your application
#'
#' @description
#' Lists the problems with your application.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_list_problems/](https://www.paws-r-sdk.com/docs/applicationinsights_list_problems/) for full documentation.
#'
#' @param AccountId The AWS account ID for the resource group owner.
#' @param ResourceGroupName The name of the resource group.
#' @param StartTime The time when the problem was detected, in epoch seconds. If you don't
#' specify a time frame for the request, problems within the past seven
#' days are returned.
#' @param EndTime The time when the problem ended, in epoch seconds. If not specified,
#' problems within the past seven days are returned.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token to request the next page of results.
#' @param ComponentName The name of the component.
#' @param Visibility Specifies whether or not you can view the problem. If not specified,
#' visible and ignored problems are returned.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_problems
applicationinsights_list_problems <- function(AccountId = NULL, ResourceGroupName = NULL, StartTime = NULL, EndTime = NULL, MaxResults = NULL, NextToken = NULL, ComponentName = NULL, Visibility = NULL) {
  op <- new_operation(
    name = "ListProblems",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .applicationinsights$list_problems_input(AccountId = AccountId, ResourceGroupName = ResourceGroupName, StartTime = StartTime, EndTime = EndTime, MaxResults = MaxResults, NextToken = NextToken, ComponentName = ComponentName, Visibility = Visibility)
  output <- .applicationinsights$list_problems_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_problems <- applicationinsights_list_problems

#' Retrieve a list of the tags (keys and values) that are associated with a
#' specified application
#'
#' @description
#' Retrieve a list of the tags (keys and values) that are associated with a specified application. A *tag* is a label that you optionally define and associate with an application. Each tag consists of a required *tag key* and an optional associated *tag value*. A tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor within a tag key.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/applicationinsights_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the application that you want to
#' retrieve tag information for.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_tags_for_resource
applicationinsights_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .applicationinsights$list_tags_for_resource_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_tags_for_resource <- applicationinsights_list_tags_for_resource

#' Lists the workloads that are configured on a given component
#'
#' @description
#' Lists the workloads that are configured on a given component.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_list_workloads/](https://www.paws-r-sdk.com/docs/applicationinsights_list_workloads/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token to request the next page of results.
#' @param AccountId The AWS account ID of the owner of the workload.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_workloads
applicationinsights_list_workloads <- function(ResourceGroupName, ComponentName, MaxResults = NULL, NextToken = NULL, AccountId = NULL) {
  op <- new_operation(
    name = "ListWorkloads",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .applicationinsights$list_workloads_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, MaxResults = MaxResults, NextToken = NextToken, AccountId = AccountId)
  output <- .applicationinsights$list_workloads_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_workloads <- applicationinsights_list_workloads

#' Remove workload from a component
#'
#' @description
#' Remove workload from a component.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_remove_workload/](https://www.paws-r-sdk.com/docs/applicationinsights_remove_workload/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param WorkloadId &#91;required&#93; The ID of the workload.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_remove_workload
applicationinsights_remove_workload <- function(ResourceGroupName, ComponentName, WorkloadId) {
  op <- new_operation(
    name = "RemoveWorkload",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$remove_workload_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, WorkloadId = WorkloadId)
  output <- .applicationinsights$remove_workload_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$remove_workload <- applicationinsights_remove_workload

#' Add one or more tags (keys and values) to a specified application
#'
#' @description
#' Add one or more tags (keys and values) to a specified application. A *tag* is a label that you optionally define and associate with an application. Tags can help you categorize and manage application in different ways, such as by purpose, owner, environment, or other criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_tag_resource/](https://www.paws-r-sdk.com/docs/applicationinsights_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the application that you want to add
#' one or more tags to.
#' @param Tags &#91;required&#93; A list of tags that to add to the application. A tag consists of a
#' required tag key (`Key`) and an associated tag value (`Value`). The
#' maximum length of a tag key is 128 characters. The maximum length of a
#' tag value is 256 characters.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_tag_resource
applicationinsights_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .applicationinsights$tag_resource_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$tag_resource <- applicationinsights_tag_resource

#' Remove one or more tags (keys and values) from a specified application
#'
#' @description
#' Remove one or more tags (keys and values) from a specified application.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_untag_resource/](https://www.paws-r-sdk.com/docs/applicationinsights_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the application that you want to
#' remove one or more tags from.
#' @param TagKeys &#91;required&#93; The tags (tag keys) that you want to remove from the resource. When you
#' specify a tag key, the action removes both that key and its associated
#' tag value.
#' 
#' To remove more than one tag from the application, append the `TagKeys`
#' parameter and argument for each additional tag to remove, separated by
#' an ampersand.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_untag_resource
applicationinsights_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .applicationinsights$untag_resource_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$untag_resource <- applicationinsights_untag_resource

#' Updates the application
#'
#' @description
#' Updates the application.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_update_application/](https://www.paws-r-sdk.com/docs/applicationinsights_update_application/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param OpsCenterEnabled When set to `true`, creates opsItems for any problems detected on an
#' application.
#' @param CWEMonitorEnabled Indicates whether Application Insights can listen to CloudWatch events
#' for the application resources, such as `instance terminated`,
#' `failed deployment`, and others.
#' @param OpsItemSNSTopicArn The SNS topic provided to Application Insights that is associated to the
#' created opsItem. Allows you to receive notifications for updates to the
#' opsItem.
#' @param RemoveSNSTopic Disassociates the SNS topic from the opsItem created for detected
#' problems.
#' @param AutoConfigEnabled Turns auto-configuration on or off.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_update_application
applicationinsights_update_application <- function(ResourceGroupName, OpsCenterEnabled = NULL, CWEMonitorEnabled = NULL, OpsItemSNSTopicArn = NULL, RemoveSNSTopic = NULL, AutoConfigEnabled = NULL) {
  op <- new_operation(
    name = "UpdateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$update_application_input(ResourceGroupName = ResourceGroupName, OpsCenterEnabled = OpsCenterEnabled, CWEMonitorEnabled = CWEMonitorEnabled, OpsItemSNSTopicArn = OpsItemSNSTopicArn, RemoveSNSTopic = RemoveSNSTopic, AutoConfigEnabled = AutoConfigEnabled)
  output <- .applicationinsights$update_application_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$update_application <- applicationinsights_update_application

#' Updates the custom component name and/or the list of resources that make
#' up the component
#'
#' @description
#' Updates the custom component name and/or the list of resources that make up the component.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_update_component/](https://www.paws-r-sdk.com/docs/applicationinsights_update_component/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param NewComponentName The new name of the component.
#' @param ResourceList The list of resource ARNs that belong to the component.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_update_component
applicationinsights_update_component <- function(ResourceGroupName, ComponentName, NewComponentName = NULL, ResourceList = NULL) {
  op <- new_operation(
    name = "UpdateComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$update_component_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, NewComponentName = NewComponentName, ResourceList = ResourceList)
  output <- .applicationinsights$update_component_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$update_component <- applicationinsights_update_component

#' Updates the monitoring configurations for the component
#'
#' @description
#' Updates the monitoring configurations for the component. The configuration input parameter is an escaped JSON of the configuration and should match the schema of what is returned by [`describe_component_configuration_recommendation`][applicationinsights_describe_component_configuration_recommendation].
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_update_component_configuration/](https://www.paws-r-sdk.com/docs/applicationinsights_update_component_configuration/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param Monitor Indicates whether the application component is monitored.
#' @param Tier The tier of the application component.
#' @param ComponentConfiguration The configuration settings of the component. The value is the escaped
#' JSON of the configuration. For more information about the JSON format,
#' see [Working with
#' JSON](https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html).
#' You can send a request to
#' [`describe_component_configuration_recommendation`][applicationinsights_describe_component_configuration_recommendation]
#' to see the recommended configuration for a component. For the complete
#' format of the component configuration file, see [Component
#' Configuration](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html).
#' @param AutoConfigEnabled Automatically configures the component by applying the recommended
#' configurations.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_update_component_configuration
applicationinsights_update_component_configuration <- function(ResourceGroupName, ComponentName, Monitor = NULL, Tier = NULL, ComponentConfiguration = NULL, AutoConfigEnabled = NULL) {
  op <- new_operation(
    name = "UpdateComponentConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$update_component_configuration_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, Monitor = Monitor, Tier = Tier, ComponentConfiguration = ComponentConfiguration, AutoConfigEnabled = AutoConfigEnabled)
  output <- .applicationinsights$update_component_configuration_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$update_component_configuration <- applicationinsights_update_component_configuration

#' Adds a log pattern to a LogPatternSet
#'
#' @description
#' Adds a log pattern to a `LogPatternSet`.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_update_log_pattern/](https://www.paws-r-sdk.com/docs/applicationinsights_update_log_pattern/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param PatternSetName &#91;required&#93; The name of the log pattern set.
#' @param PatternName &#91;required&#93; The name of the log pattern.
#' @param Pattern The log pattern. The pattern must be DFA compatible. Patterns that
#' utilize forward lookahead or backreference constructions are not
#' supported.
#' @param Rank Rank of the log pattern. Must be a value between `1` and `1,000,000`.
#' The patterns are sorted by rank, so we recommend that you set your
#' highest priority patterns with the lowest rank. A pattern of rank `1`
#' will be the first to get matched to a log line. A pattern of rank
#' `1,000,000` will be last to get matched. When you configure custom log
#' patterns from the console, a `Low` severity pattern translates to a
#' `750,000` rank. A `Medium` severity pattern translates to a `500,000`
#' rank. And a `High` severity pattern translates to a `250,000` rank. Rank
#' values less than `1` or greater than `1,000,000` are reserved for
#' AWS-provided patterns.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_update_log_pattern
applicationinsights_update_log_pattern <- function(ResourceGroupName, PatternSetName, PatternName, Pattern = NULL, Rank = NULL) {
  op <- new_operation(
    name = "UpdateLogPattern",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$update_log_pattern_input(ResourceGroupName = ResourceGroupName, PatternSetName = PatternSetName, PatternName = PatternName, Pattern = Pattern, Rank = Rank)
  output <- .applicationinsights$update_log_pattern_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$update_log_pattern <- applicationinsights_update_log_pattern

#' Updates the visibility of the problem or specifies the problem as
#' RESOLVED
#'
#' @description
#' Updates the visibility of the problem or specifies the problem as `RESOLVED`.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_update_problem/](https://www.paws-r-sdk.com/docs/applicationinsights_update_problem/) for full documentation.
#'
#' @param ProblemId &#91;required&#93; The ID of the problem.
#' @param UpdateStatus The status of the problem. Arguments can be passed for only problems
#' that show a status of `RECOVERING`.
#' @param Visibility The visibility of a problem. When you pass a value of `IGNORED`, the
#' problem is removed from the default view, and all notifications for the
#' problem are suspended. When `VISIBLE` is passed, the `IGNORED` action is
#' reversed.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_update_problem
applicationinsights_update_problem <- function(ProblemId, UpdateStatus = NULL, Visibility = NULL) {
  op <- new_operation(
    name = "UpdateProblem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$update_problem_input(ProblemId = ProblemId, UpdateStatus = UpdateStatus, Visibility = Visibility)
  output <- .applicationinsights$update_problem_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$update_problem <- applicationinsights_update_problem

#' Adds a workload to a component
#'
#' @description
#' Adds a workload to a component. Each component can have at most five workloads.
#'
#' See [https://www.paws-r-sdk.com/docs/applicationinsights_update_workload/](https://www.paws-r-sdk.com/docs/applicationinsights_update_workload/) for full documentation.
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param WorkloadId The ID of the workload.
#' @param WorkloadConfiguration &#91;required&#93; The configuration settings of the workload. The value is the escaped
#' JSON of the configuration.
#'
#' @keywords internal
#'
#' @rdname applicationinsights_update_workload
applicationinsights_update_workload <- function(ResourceGroupName, ComponentName, WorkloadId = NULL, WorkloadConfiguration) {
  op <- new_operation(
    name = "UpdateWorkload",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$update_workload_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, WorkloadId = WorkloadId, WorkloadConfiguration = WorkloadConfiguration)
  output <- .applicationinsights$update_workload_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$update_workload <- applicationinsights_update_workload
