% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchrum_operations.R
\name{cloudwatchrum_update_app_monitor}
\alias{cloudwatchrum_update_app_monitor}
\title{Updates the configuration of an existing app monitor}
\usage{
cloudwatchrum_update_app_monitor(
  AppMonitorConfiguration = NULL,
  CwLogEnabled = NULL,
  Domain = NULL,
  Name
)
}
\arguments{
\item{AppMonitorConfiguration}{A structure that contains much of the configuration data for the app
monitor. If you are using Amazon Cognito for authorization, you must
include this structure in your request, and it must include the ID of
the Amazon Cognito identity pool to use for authorization. If you don't
include \code{AppMonitorConfiguration}, you must set up your own
authorization method. For more information, see Authorize your
application to send data to Amazon Web Services.}

\item{CwLogEnabled}{Data collected by RUM is kept by RUM for 30 days and then deleted. This
parameter specifies whether RUM sends a copy of this telemetry data to
Amazon CloudWatch Logs in your account. This enables you to keep the
telemetry data for more than 30 days, but it does incur Amazon
CloudWatch Logs charges.}

\item{Domain}{The top-level internet domain name for which your application has
administrative authority.}

\item{Name}{[required] The name of the app monitor to update.}
}
\description{
Updates the configuration of an existing app monitor. When you use this operation, only the parts of the app monitor configuration that you specify in this operation are changed. For any parameters that you omit, the existing values are kept.

See \url{https://paws-r.github.io/docs/cloudwatchrum/update_app_monitor.html} for full documentation.
}
\keyword{internal}
