% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_put_metric_data}
\alias{cloudwatch_put_metric_data}
\title{Publishes metric data points to Amazon CloudWatch}
\usage{
cloudwatch_put_metric_data(Namespace, MetricData)
}
\arguments{
\item{Namespace}{[required] The namespace for the metric data.

To avoid conflicts with Amazon Web Services service namespaces, you
should not specify a namespace that begins with \verb{AWS/}}

\item{MetricData}{[required] The data for the metric. The array can include no more than 1000 metrics
per call.}
}
\description{
Publishes metric data points to Amazon CloudWatch. CloudWatch associates the data points with the specified metric. If the specified metric does not exist, CloudWatch creates the metric. When CloudWatch creates a metric, it can take up to fifteen minutes for the metric to appear in calls to \code{\link[=cloudwatch_list_metrics]{list_metrics}}.

See \url{https://paws-r.github.io/docs/cloudwatch/put_metric_data.html} for full documentation.
}
\keyword{internal}
