% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_describe_organizational_unit}
\alias{organizations_describe_organizational_unit}
\title{Retrieves information about an organizational unit (OU)}
\usage{
organizations_describe_organizational_unit(OrganizationalUnitId)
}
\arguments{
\item{OrganizationalUnitId}{[required] The unique identifier (ID) of the organizational unit that you want
details about. You can get the ID from the
ListOrganizationalUnitsForParent operation.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for an
organizational unit ID string requires \"ou-\" followed by from 4 to 32
lowercase letters or digits (the ID of the root that contains the OU).
This string is followed by a second \"-\" dash and from 8 to 32
additional lowercase letters or digits.}
}
\description{
Retrieves information about an organizational unit (OU).
}
\details{
This operation can be called only from the organization\'s master
account.
}
\section{Request syntax}{
\preformatted{svc$describe_organizational_unit(
  OrganizationalUnitId = "string"
)
}
}

\examples{
\dontrun{
# The following example shows how to request details about an OU:/n/n
svc$describe_organizational_unit(
  OrganizationalUnitId = "ou-examplerootid111-exampleouid111"
)
}

}
\keyword{internal}
