% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_describe_type}
\alias{cloudformation_describe_type}
\title{Returns detailed information about a type that has been registered}
\usage{
cloudformation_describe_type(Type, TypeName, Arn, VersionId)
}
\arguments{
\item{Type}{The kind of type.

Currently the only valid value is \code{RESOURCE}.}

\item{TypeName}{The name of the type.

Conditional: You must specify \code{TypeName} or \code{Arn}.}

\item{Arn}{The Amazon Resource Name (ARN) of the type.

Conditional: You must specify \code{TypeName} or \code{Arn}.}

\item{VersionId}{The ID of a specific version of the type. The version ID is the value at
the end of the Amazon Resource Name (ARN) assigned to the type version
when it is registered.

If you specify a \code{VersionId}, \code{DescribeType} returns information about
that specific type version. Otherwise, it returns information about the
default type version.}
}
\description{
Returns detailed information about a type that has been registered.
}
\details{
If you specify a \code{VersionId}, \code{DescribeType} returns information about
that specific type version. Otherwise, it returns information about the
default type version.
}
\section{Request syntax}{
\preformatted{svc$describe_type(
  Type = "RESOURCE",
  TypeName = "string",
  Arn = "string",
  VersionId = "string"
)
}
}

\keyword{internal}
