% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_detach_instances}
\alias{autoscaling_detach_instances}
\title{Removes one or more instances from the specified Auto Scaling group}
\usage{
autoscaling_detach_instances(InstanceIds, AutoScalingGroupName,
  ShouldDecrementDesiredCapacity)
}
\arguments{
\item{InstanceIds}{The IDs of the instances. You can specify up to 20 instances.}

\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{ShouldDecrementDesiredCapacity}{[required] Indicates whether the Auto Scaling group decrements the desired capacity
value by the number of instances detached.}
}
\description{
Removes one or more instances from the specified Auto Scaling group.
}
\details{
After the instances are detached, you can manage them independent of the
Auto Scaling group.

If you do not specify the option to decrement the desired capacity,
Amazon EC2 Auto Scaling launches instances to replace the ones that are
detached.

If there is a Classic Load Balancer attached to the Auto Scaling group,
the instances are deregistered from the load balancer. If there are
target groups attached to the Auto Scaling group, the instances are
deregistered from the target groups.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/detach-instance-asg.html}{Detach EC2 Instances from Your Auto Scaling Group}
in the \emph{Amazon EC2 Auto Scaling User Guide}.
}
\section{Request syntax}{
\preformatted{svc$detach_instances(
  InstanceIds = list(
    "string"
  ),
  AutoScalingGroupName = "string",
  ShouldDecrementDesiredCapacity = TRUE|FALSE
)
}
}

\examples{
# This example detaches the specified instance from the specified Auto
# Scaling group.
\donttest{svc$detach_instances(
  AutoScalingGroupName = "my-auto-scaling-group",
  InstanceIds = list(
    "i-93633f9b"
  ),
  ShouldDecrementDesiredCapacity = TRUE
)}

}
\keyword{internal}
