% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_operations.R
\name{support_describe_communications}
\alias{support_describe_communications}
\title{Returns communications (and attachments) for one or more support cases}
\usage{
support_describe_communications(caseId, beforeTime, afterTime,
  nextToken, maxResults)
}
\arguments{
\item{caseId}{[required] The AWS Support case ID requested or returned in the call. The case ID
is an alphanumeric string formatted as shown in this example:
case-\emph{12345678910-2013-c4c1d2bf33c5cf47}}

\item{beforeTime}{The end date for a filtered date search on support case communications.
Case communications are available for 12 months after creation.}

\item{afterTime}{The start date for a filtered date search on support case
communications. Case communications are available for 12 months after
creation.}

\item{nextToken}{A resumption point for pagination.}

\item{maxResults}{The maximum number of results to return before paginating.}
}
\description{
Returns communications (and attachments) for one or more support cases.
You can use the \code{afterTime} and \code{beforeTime} parameters to filter by
date. You can use the \code{caseId} parameter to restrict the results to a
particular case.
}
\details{
Case data is available for 12 months after creation. If a case was
created more than 12 months ago, a request for data might cause an
error.

You can use the \code{maxResults} and \code{nextToken} parameters to control the
pagination of the result set. Set \code{maxResults} to the number of cases
you want displayed on each page, and use \code{nextToken} to specify the
resumption of pagination.
}
\section{Request syntax}{
\preformatted{svc$describe_communications(
  caseId = "string",
  beforeTime = "string",
  afterTime = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
