% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_list_tags_for_resource}
\alias{configservice_list_tags_for_resource}
\title{List the tags for AWS Config resource}
\usage{
configservice_list_tags_for_resource(ResourceArn, Limit, NextToken)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) that identifies the resource for which to
list the tags. Currently, the supported resources are \code{ConfigRule},
\code{ConfigurationAggregator} and \code{AggregatorAuthorization}.}

\item{Limit}{The maximum number of tags returned on each page. The limit maximum is
50. You cannot specify a number greater than 50. If you specify 0, AWS
Config uses the default.}

\item{NextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\value{
A list with the following syntax:\preformatted{list(
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
List the tags for AWS Config resource.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  ResourceArn = "string",
  Limit = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
