% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicequotas_operations.R
\name{servicequotas_list_requested_service_quota_change_history}
\alias{servicequotas_list_requested_service_quota_change_history}
\title{Retrieves the quota increase requests for the specified service}
\usage{
servicequotas_list_requested_service_quota_change_history(ServiceCode,
  Status, NextToken, MaxResults)
}
\arguments{
\item{ServiceCode}{The service identifier.}

\item{Status}{The status of the quota increase request.}

\item{NextToken}{The token for the next page of results.}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, if any, make another call with the token returned
from this call.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  RequestedQuotas = list(
    list(
      Id = "string",
      CaseId = "string",
      ServiceCode = "string",
      ServiceName = "string",
      QuotaCode = "string",
      QuotaName = "string",
      DesiredValue = 123.0,
      Status = "PENDING"|"CASE_OPENED"|"APPROVED"|"DENIED"|"CASE_CLOSED",
      Created = as.POSIXct(
        "2015-01-01"
      ),
      LastUpdated = as.POSIXct(
        "2015-01-01"
      ),
      Requester = "string",
      QuotaArn = "string",
      GlobalQuota = TRUE|FALSE,
      Unit = "string"
    )
  )
)
}
}
\description{
Retrieves the quota increase requests for the specified service.
}
\section{Request syntax}{
\preformatted{svc$list_requested_service_quota_change_history(
  ServiceCode = "string",
  Status = "PENDING"|"CASE_OPENED"|"APPROVED"|"DENIED"|"CASE_CLOSED",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
