% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_list_resources_for_tag_option}
\alias{servicecatalog_list_resources_for_tag_option}
\title{Lists the resources associated with the specified TagOption}
\usage{
servicecatalog_list_resources_for_tag_option(TagOptionId, ResourceType,
  PageSize, PageToken)
}
\arguments{
\item{TagOptionId}{[required] The TagOption identifier.}

\item{ResourceType}{The resource type.
\itemize{
\item \code{Portfolio}
\item \code{Product}
}}

\item{PageSize}{The maximum number of items to return with this call.}

\item{PageToken}{The page token for the next set of results. To retrieve the first set of
results, use null.}
}
\value{
A list with the following syntax:\preformatted{list(
  ResourceDetails = list(
    list(
      Id = "string",
      ARN = "string",
      Name = "string",
      Description = "string",
      CreatedTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  PageToken = "string"
)
}
}
\description{
Lists the resources associated with the specified TagOption.
}
\section{Request syntax}{
\preformatted{svc$list_resources_for_tag_option(
  TagOptionId = "string",
  ResourceType = "string",
  PageSize = 123,
  PageToken = "string"
)
}
}

\keyword{internal}
