% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pi_service.R
\name{pi}
\alias{pi}
\title{AWS Performance Insights}
\usage{
pi(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
Amazon RDS Performance Insights

Amazon RDS Performance Insights enables you to monitor and explore
different dimensions of database load based on data captured from a
running DB instance. The guide provides detailed information about
Performance Insights data types, parameters and errors.

When Performance Insights is enabled, the Amazon RDS Performance
Insights API provides visibility into the performance of your DB
instance. Amazon CloudWatch provides the authoritative source for AWS
service-vended monitoring metrics. Performance Insights offers a
domain-specific view of DB load.

DB load is measured as Average Active Sessions. Performance Insights
provides the data to API consumers as a two-dimensional time-series
dataset. The time dimension provides DB load data for each time point in
the queried time range. Each time point decomposes overall load in
relation to the requested dimensions, measured at that time point.
Examples include SQL, Wait event, User, and Host.
\itemize{
\item To learn more about Performance Insights and Amazon Aurora DB
instances, go to the \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html}{Amazon Aurora User Guide}.
\item To learn more about Performance Insights and Amazon RDS DB
instances, go to the \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html}{Amazon RDS User Guide}.
}
}
\section{Service syntax}{
\preformatted{svc <- pi(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=pi_describe_dimension_keys]{describe_dimension_keys} \tab For a specific time period, retrieve the top N dimension keys for a metric\cr
\link[=pi_get_resource_metrics]{get_resource_metrics} \tab Retrieve Performance Insights metrics for a set of data sources, over a time period
}
}

\examples{
\dontrun{
svc <- pi()
svc$describe_dimension_keys(
  Foo = 123
)
}

}
