% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_service.R
\name{support}
\alias{support}
\title{AWS Support}
\usage{
support(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
The AWS Support API reference is intended for programmers who need
detailed information about the AWS Support operations and data types.
This service enables you to manage your AWS Support cases
programmatically. It uses HTTP methods that return results in JSON
format.
\itemize{
\item You must have a Business or Enterprise support plan to use the AWS
Support API.
\item If you call the AWS Support API from an account that does not have a
Business or Enterprise support plan, the
\code{SubscriptionRequiredException} error message appears. For
information about changing your support plan, see \href{https://aws.amazon.com/premiumsupport/}{AWS Support}.
}

The AWS Support service also exposes a set of \href{https://aws.amazon.com/premiumsupport/technology/trusted-advisor/}{AWS Trusted Advisor}
features. You can retrieve a list of checks and their descriptions, get
check results, specify checks to refresh, and get the refresh status of
checks.

The following list describes the AWS Support case management operations:
\itemize{
\item \strong{Service names, issue categories, and available severity levels.}
The DescribeServices and DescribeSeverityLevels operations return
AWS service names, service codes, service categories, and problem
severity levels. You use these values when you call the CreateCase
operation.
\item \strong{Case creation, case details, and case resolution.} The
CreateCase, DescribeCases, DescribeAttachment, and ResolveCase
operations create AWS Support cases, retrieve information about
cases, and resolve cases.
\item \strong{Case communication.} The DescribeCommunications,
AddCommunicationToCase, and AddAttachmentsToSet operations retrieve
and add communications and attachments to AWS Support cases.
}

The following list describes the operations available from the AWS
Support service for Trusted Advisor:
\itemize{
\item DescribeTrustedAdvisorChecks returns the list of checks that run
against your AWS resources.
\item Using the \code{checkId} for a specific check returned by
DescribeTrustedAdvisorChecks, you can call
DescribeTrustedAdvisorCheckResult to obtain the results for the
check that you specified.
\item DescribeTrustedAdvisorCheckSummaries returns summarized results for
one or more Trusted Advisor checks.
\item RefreshTrustedAdvisorCheck requests that Trusted Advisor rerun a
specified check.
\item DescribeTrustedAdvisorCheckRefreshStatuses reports the refresh
status of one or more checks.
}

For authentication of requests, AWS Support uses \href{https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html}{Signature Version 4 Signing Process}.

See \href{https://docs.aws.amazon.com/awssupport/latest/user/Welcome.html}{About the AWS Support API} in
the \emph{AWS Support User Guide} for information about how to use this
service to create and manage your support cases, and how to call Trusted
Advisor for results of checks on your resources.
}
\section{Service syntax}{
\preformatted{svc <- support(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=support_add_attachments_to_set]{add_attachments_to_set} \tab Adds one or more attachments to an attachment set\cr
\link[=support_add_communication_to_case]{add_communication_to_case} \tab Adds additional customer communication to an AWS Support case\cr
\link[=support_create_case]{create_case} \tab Creates a case in the AWS Support Center\cr
\link[=support_describe_attachment]{describe_attachment} \tab Returns the attachment that has the specified ID\cr
\link[=support_describe_cases]{describe_cases} \tab Returns a list of cases that you specify by passing one or more case IDs\cr
\link[=support_describe_communications]{describe_communications} \tab Returns communications and attachments for one or more support cases\cr
\link[=support_describe_services]{describe_services} \tab Returns the current list of AWS services and a list of service categories for each service\cr
\link[=support_describe_severity_levels]{describe_severity_levels} \tab Returns the list of severity levels that you can assign to an AWS Support case\cr
\link[=support_describe_trusted_advisor_check_refresh_statuses]{describe_trusted_advisor_check_refresh_statuses} \tab Returns the refresh status of the AWS Trusted Advisor checks that have the specified check IDs\cr
\link[=support_describe_trusted_advisor_check_result]{describe_trusted_advisor_check_result} \tab Returns the results of the AWS Trusted Advisor check that has the specified check ID\cr
\link[=support_describe_trusted_advisor_checks]{describe_trusted_advisor_checks} \tab Returns information about all available AWS Trusted Advisor checks, including the name, ID, category, description, and metadata\cr
\link[=support_describe_trusted_advisor_check_summaries]{describe_trusted_advisor_check_summaries} \tab Returns the results for the AWS Trusted Advisor check summaries for the check IDs that you specified\cr
\link[=support_refresh_trusted_advisor_check]{refresh_trusted_advisor_check} \tab Refreshes the AWS Trusted Advisor check that you specify using the check ID\cr
\link[=support_resolve_case]{resolve_case} \tab Resolves a support case
}
}

\examples{
\dontrun{
svc <- support()
svc$add_attachments_to_set(
  Foo = 123
)
}

}
