% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_update_service_setting}
\alias{ssm_update_service_setting}
\title{ServiceSetting is an account-level setting for an AWS service}
\usage{
ssm_update_service_setting(SettingId, SettingValue)
}
\arguments{
\item{SettingId}{[required] The Amazon Resource Name (ARN) of the service setting to reset. For
example,
\code{arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled}.
The setting ID can be one of the following.
\itemize{
\item \verb{/ssm/parameter-store/default-parameter-tier}
\item \verb{/ssm/parameter-store/high-throughput-enabled}
\item \verb{/ssm/managed-instance/activation-tier}
}}

\item{SettingValue}{[required] The new value to specify for the service setting. For the
\verb{/ssm/parameter-store/default-parameter-tier} setting ID, the setting
value can be one of the following.
\itemize{
\item Standard
\item Advanced
\item Intelligent-Tiering
}

For the \verb{/ssm/parameter-store/high-throughput-enabled}, and
\verb{/ssm/managed-instance/activation-tier} setting IDs, the setting value
can be true or false.}
}
\description{
\code{ServiceSetting} is an account-level setting for an AWS service. This
setting defines how a user interacts with or uses a service or a feature
of a service. For example, if an AWS service charges money to the
account based on feature or service usage, then the AWS service team
might create a default setting of "false". This means the user can't use
this feature unless they change the setting to "true" and intentionally
opt in for a paid feature.

Services map a \code{SettingId} object to a setting value. AWS services teams
define the default value for a \code{SettingId}. You can't create a new
\code{SettingId}, but you can overwrite the default value if you have the
\code{ssm:UpdateServiceSetting} permission for the setting. Use the
GetServiceSetting API action to view the current value. Or, use the
ResetServiceSetting to change the value back to the original value
defined by the AWS service team.

Update the service setting for the account.
}
\section{Request syntax}{
\preformatted{svc$update_service_setting(
  SettingId = "string",
  SettingValue = "string"
)
}
}

\keyword{internal}
