% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_update_document}
\alias{ssm_update_document}
\title{Updates one or more values for an SSM document}
\usage{
ssm_update_document(Content, Attachments, Name, VersionName,
  DocumentVersion, DocumentFormat, TargetType)
}
\arguments{
\item{Content}{[required] A valid JSON or YAML string.}

\item{Attachments}{A list of key and value pairs that describe attachments to a version of
a document.}

\item{Name}{[required] The name of the document that you want to update.}

\item{VersionName}{An optional field specifying the version of the artifact you are
updating with the document. For example, "Release 12, Update 6". This
value is unique across all versions of a document, and cannot be
changed.}

\item{DocumentVersion}{(Required) The latest version of the document that you want to update.
The latest document version can be specified using the $LATEST variable
or by the version number. Updating a previous version of a document is
not supported.}

\item{DocumentFormat}{Specify the document format for the new document version. Systems
Manager supports JSON and YAML documents. JSON is the default format.}

\item{TargetType}{Specify a new target type for the document.}
}
\description{
Updates one or more values for an SSM document.
}
\section{Request syntax}{
\preformatted{svc$update_document(
  Content = "string",
  Attachments = list(
    list(
      Key = "SourceUrl"|"S3FileUrl"|"AttachmentReference",
      Values = list(
        "string"
      ),
      Name = "string"
    )
  ),
  Name = "string",
  VersionName = "string",
  DocumentVersion = "string",
  DocumentFormat = "YAML"|"JSON"|"TEXT",
  TargetType = "string"
)
}
}

\keyword{internal}
