% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_copy_product}
\alias{servicecatalog_copy_product}
\title{Copies the specified source product to the specified target product or a
new product}
\usage{
servicecatalog_copy_product(AcceptLanguage, SourceProductArn,
  TargetProductId, TargetProductName,
  SourceProvisioningArtifactIdentifiers, CopyOptions, IdempotencyToken)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{SourceProductArn}{[required] The Amazon Resource Name (ARN) of the source product.}

\item{TargetProductId}{The identifier of the target product. By default, a new product is
created.}

\item{TargetProductName}{A name for the target product. The default is the name of the source
product.}

\item{SourceProvisioningArtifactIdentifiers}{The identifiers of the provisioning artifacts (also known as versions)
of the product to copy. By default, all provisioning artifacts are
copied.}

\item{CopyOptions}{The copy options. If the value is \code{CopyTags}, the tags from the source
product are copied to the target product.}

\item{IdempotencyToken}{[required] A unique identifier that you provide to ensure idempotency. If multiple
requests differ only by the idempotency token, the same response is
returned for each repeated request.}
}
\description{
Copies the specified source product to the specified target product or a
new product.

You can copy a product to the same account or another account. You can
copy a product to the same region or another region.

This operation is performed asynchronously. To track the progress of the
operation, use DescribeCopyProductStatus.
}
\section{Request syntax}{
\preformatted{svc$copy_product(
  AcceptLanguage = "string",
  SourceProductArn = "string",
  TargetProductId = "string",
  TargetProductName = "string",
  SourceProvisioningArtifactIdentifiers = list(
    list(
      "string"
    )
  ),
  CopyOptions = list(
    "CopyTags"
  ),
  IdempotencyToken = "string"
)
}
}

\keyword{internal}
