% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_describe_config_rule_evaluation_status}
\alias{configservice_describe_config_rule_evaluation_status}
\title{Returns status information for each of your AWS managed Config rules}
\usage{
configservice_describe_config_rule_evaluation_status(ConfigRuleNames,
  NextToken, Limit)
}
\arguments{
\item{ConfigRuleNames}{The name of the AWS managed Config rules for which you want status
information. If you do not specify any names, AWS Config returns status
information for all AWS managed Config rules that you use.}

\item{NextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}

\item{Limit}{The number of rule evaluation results that you want returned.

This parameter is required if the rule limit for your account is more
than the default of 150 rules.

For information about requesting a rule limit increase, see \href{https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config}{AWS Config Limits}
in the \emph{AWS General Reference Guide}.}
}
\description{
Returns status information for each of your AWS managed Config rules.
The status includes information such as the last time AWS Config invoked
the rule, the last time AWS Config failed to invoke the rule, and the
related error for the last failure.
}
\section{Request syntax}{
\preformatted{svc$describe_config_rule_evaluation_status(
  ConfigRuleNames = list(
    "string"
  ),
  NextToken = "string",
  Limit = 123
)
}
}

\keyword{internal}
