% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_put_composite_alarm}
\alias{cloudwatch_put_composite_alarm}
\title{Creates or updates a composite alarm}
\usage{
cloudwatch_put_composite_alarm(ActionsEnabled, AlarmActions,
  AlarmDescription, AlarmName, AlarmRule, InsufficientDataActions,
  OKActions, Tags)
}
\arguments{
\item{ActionsEnabled}{Indicates whether actions should be executed during any changes to the
alarm state of the composite alarm. The default is \code{TRUE}.}

\item{AlarmActions}{The actions to execute when this alarm transitions to the \code{ALARM} state
from any other state. Each action is specified as an Amazon Resource
Name (ARN).

Valid Values:
\verb{arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> } |
\verb{arn:aws:ssm:<i>region</i>:<i>account-id</i>:opsitem:<i>severity</i> }}

\item{AlarmDescription}{The description for the composite alarm.}

\item{AlarmName}{[required] The name for the composite alarm. This name must be unique within the
Region.}

\item{AlarmRule}{[required] An expression that specifies which other alarms are to be evaluated to
determine this composite alarm's state. For each alarm that you
reference, you designate a function that specifies whether that alarm
needs to be in ALARM state, OK state, or INSUFFICIENT\\_DATA state. You
can use operators (AND, OR and NOT) to combine multiple functions in a
single expression. You can use parenthesis to logically group the
functions in your expression.

You can use either alarm names or ARNs to reference the other alarms
that are to be evaluated.

Functions can include the following:
\itemize{
\item \code{ALARM("<i>alarm-name</i> or <i>alarm-ARN</i>")} is TRUE if the
named alarm is in ALARM state.
\item \code{OK("<i>alarm-name</i> or <i>alarm-ARN</i>")} is TRUE if the named
alarm is in OK state.
\item \code{INSUFFICIENT_DATA("<i>alarm-name</i> or <i>alarm-ARN</i>")} is TRUE
if the named alarm is in INSUFFICIENT\\_DATA state.
\item \code{TRUE} always evaluates to TRUE.
\item \code{FALSE} always evaluates to FALSE.
}

TRUE and FALSE are useful for testing a complex \code{AlarmRule} structure,
and for testing your alarm actions.

Alarm names specified in \code{AlarmRule} can be surrounded with
double-quotes ("), but do not have to be.

The following are some examples of \code{AlarmRule}:
\itemize{
\item \verb{ALARM(CPUUtilizationTooHigh) AND ALARM(DiskReadOpsTooHigh)}
specifies that the composite alarm goes into ALARM state only if
both CPUUtilizationTooHigh and DiskReadOpsTooHigh alarms are in
ALARM state.
\item \verb{ALARM(CPUUtilizationTooHigh) AND NOT ALARM(DeploymentInProgress)}
specifies that the alarm goes to ALARM state if
CPUUtilizationTooHigh is in ALARM state and DeploymentInProgress is
not in ALARM state. This example reduces alarm noise during a known
deployment window.
\item \verb{(ALARM(CPUUtilizationTooHigh) OR ALARM(DiskReadOpsTooHigh)) AND OK(NetworkOutTooHigh)}
goes into ALARM state if CPUUtilizationTooHigh OR DiskReadOpsTooHigh
is in ALARM state, and if NetworkOutTooHigh is in OK state. This
provides another example of using a composite alarm to prevent
noise. This rule ensures that you are not notified with an alarm
action on high CPU or disk usage if a known network problem is also
occurring.
}

The \code{AlarmRule} can specify as many as 100 "children" alarms. The
\code{AlarmRule} expression can have as many as 500 elements. Elements are
child alarms, TRUE or FALSE statements, and parentheses.}

\item{InsufficientDataActions}{The actions to execute when this alarm transitions to the
\code{INSUFFICIENT_DATA} state from any other state. Each action is specified
as an Amazon Resource Name (ARN).

Valid Values:
\verb{arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> }}

\item{OKActions}{The actions to execute when this alarm transitions to an \code{OK} state from
any other state. Each action is specified as an Amazon Resource Name
(ARN).

Valid Values:
\verb{arn:aws:sns:<i>region</i>:<i>account-id</i>:<i>sns-topic-name</i> }}

\item{Tags}{A list of key-value pairs to associate with the composite alarm. You can
associate as many as 50 tags with an alarm.

Tags can help you organize and categorize your resources. You can also
use them to scope user permissions, by granting a user permission to
access or change only resources with certain tag values.}
}
\description{
Creates or updates a \emph{composite alarm}. When you create a composite
alarm, you specify a rule expression for the alarm that takes into
account the alarm states of other alarms that you have created. The
composite alarm goes into ALARM state only if all conditions of the rule
are met.

The alarms specified in a composite alarm's rule expression can include
metric alarms and other composite alarms.

Using composite alarms can reduce alarm noise. You can create multiple
metric alarms, and also create a composite alarm and set up alerts only
for the composite alarm. For example, you could create a composite alarm
that goes into ALARM state only when more than one of the underlying
metric alarms are in ALARM state.

Currently, the only alarm actions that can be taken by composite alarms
are notifying SNS topics.

It is possible to create a loop or cycle of composite alarms, where
composite alarm A depends on composite alarm B, and composite alarm B
also depends on composite alarm A. In this scenario, you can't delete
any composite alarm that is part of the cycle because there is always
still a composite alarm that depends on that alarm that you want to
delete.

To get out of such a situation, you must break the cycle by changing the
rule of one of the composite alarms in the cycle to remove a dependency
that creates the cycle. The simplest change to make to break a cycle is
to change the \code{AlarmRule} of one of the alarms to \code{False}.

Additionally, the evaluation of composite alarms stops if CloudWatch
detects a cycle in the evaluation path.

When this operation creates an alarm, the alarm state is immediately set
to \code{INSUFFICIENT_DATA}. The alarm is then evaluated and its state is set
appropriately. Any actions associated with the new state are then
executed. For a composite alarm, this initial time after creation is the
only time that the alarm can be in \code{INSUFFICIENT_DATA} state.

When you update an existing alarm, its state is left unchanged, but the
update completely overwrites the previous configuration of the alarm.

If you are an IAM user, you must have \code{iam:CreateServiceLinkedRole} to
create a composite alarm that has Systems Manager OpsItem actions.
}
\section{Request syntax}{
\preformatted{svc$put_composite_alarm(
  ActionsEnabled = TRUE|FALSE,
  AlarmActions = list(
    "string"
  ),
  AlarmDescription = "string",
  AlarmName = "string",
  AlarmRule = "string",
  InsufficientDataActions = list(
    "string"
  ),
  OKActions = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
