% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_put_parameter}
\alias{ssm_put_parameter}
\title{Add a parameter to the system}
\usage{
ssm_put_parameter(Name, Description, Value, Type, KeyId, Overwrite,
  AllowedPattern, Tags)
}
\arguments{
\item{Name}{[required] The fully qualified name of the parameter that you want to add to the
system. The fully qualified name includes the complete hierarchy of the
parameter path and name. For example: \code{/Dev/DBServer/MySQL/db-string13}

Naming Constraints:
\itemize{
\item Parameter names are case sensitive.
\item A parameter name must be unique within an AWS Region
\item A parameter name can't be prefixed with "aws" or "ssm"
(case-insensitive).
\item Parameter names can include only the following symbols and letters:
\code{a-zA-Z0-9_.-/}
\item A parameter name can't include spaces.
\item Parameter hierarchies are limited to a maximum depth of fifteen
levels.
}

For additional information about valid values for parameter names, see
\href{http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html}{Requirements and Constraints for Parameter Names}
in the \emph{AWS Systems Manager User Guide}.

The maximum length constraint listed below includes capacity for
additional system attributes that are not part of the name. The maximum
length for the fully qualified parameter name is 1011 characters.}

\item{Description}{Information about the parameter that you want to add to the system.
Optional but recommended.

Do not enter personally identifiable information in this field.}

\item{Value}{[required] The parameter value that you want to add to the system.}

\item{Type}{[required] The type of parameter that you want to add to the system.

Items in a \code{StringList} must be separated by a comma (,). You can't use
other punctuation or special character to escape items in the list. If
you have a parameter value that requires a comma, then use the \code{String}
data type.

\code{SecureString} is not currently supported for AWS CloudFormation
templates or in the China Regions.}

\item{KeyId}{The KMS Key ID that you want to use to encrypt a parameter. Either the
default AWS Key Management Service (AWS KMS) key automatically assigned
to your AWS account or a custom key. Required for parameters that use
the \code{SecureString} data type.

If you don't specify a key ID, the system uses the default key
associated with your AWS account.
\itemize{
\item To use your default AWS KMS key, choose the \code{SecureString} data
type, and do \emph{not} specify the \code{Key ID} when you create the
parameter. The system automatically populates \code{Key ID} with your
default KMS key.
\item To use a custom KMS key, choose the \code{SecureString} data type with
the \code{Key ID} parameter.
}}

\item{Overwrite}{Overwrite an existing parameter. If not specified, will default to
"false".}

\item{AllowedPattern}{A regular expression used to validate the parameter value. For example,
for String types with values restricted to numbers, you can specify the
following: AllowedPattern=\^\code{\\d}+\$}

\item{Tags}{Optional metadata that you assign to a resource. Tags enable you to
categorize a resource in different ways, such as by purpose, owner, or
environment. For example, you might want to tag a Systems Manager
parameter to identify the type of resource to which it applies, the
environment, or the type of configuration data referenced by the
parameter. In this case, you could specify the following key name/value
pairs:
\itemize{
\item \code{Key=Resource,Value=S3bucket}
\item \code{Key=OS,Value=Windows}
\item \code{Key=ParameterType,Value=LicenseKey}
}

To add tags to an existing Systems Manager parameter, use the
AddTagsToResource action.}
}
\description{
Add a parameter to the system.
}
\section{Request syntax}{
\preformatted{svc$put_parameter(
  Name = "string",
  Description = "string",
  Value = "string",
  Type = "String"|"StringList"|"SecureString",
  KeyId = "string",
  Overwrite = TRUE|FALSE,
  AllowedPattern = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
