% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_describe_stack_resources}
\alias{cloudformation_describe_stack_resources}
\title{Returns AWS resource descriptions for running and deleted stacks}
\usage{
cloudformation_describe_stack_resources(StackName, LogicalResourceId,
  PhysicalResourceId)
}
\arguments{
\item{StackName}{The name or the unique stack ID that is associated with the stack, which
are not always interchangeable:
\itemize{
\item Running stacks: You can specify either the stack's name or its
unique stack ID.
\item Deleted stacks: You must specify the unique stack ID.
}

Default: There is no default value.

Required: Conditional. If you do not specify \code{StackName}, you must
specify \code{PhysicalResourceId}.}

\item{LogicalResourceId}{The logical name of the resource as specified in the template.

Default: There is no default value.}

\item{PhysicalResourceId}{The name or unique identifier that corresponds to a physical instance ID
of a resource supported by AWS CloudFormation.

For example, for an Amazon Elastic Compute Cloud (EC2) instance,
\code{PhysicalResourceId} corresponds to the \code{InstanceId}. You can pass the
EC2 \code{InstanceId} to \code{DescribeStackResources} to find which stack the
instance belongs to and what other resources are part of the stack.

Required: Conditional. If you do not specify \code{PhysicalResourceId}, you
must specify \code{StackName}.

Default: There is no default value.}
}
\description{
Returns AWS resource descriptions for running and deleted stacks. If
\code{StackName} is specified, all the associated resources that are part of
the stack are returned. If \code{PhysicalResourceId} is specified, the
associated resources of the stack that the resource belongs to are
returned.
}
\details{
Only the first 100 resources will be returned. If your stack has more
resources than this, you should use \code{ListStackResources} instead.

For deleted stacks, \code{DescribeStackResources} returns resource
information for up to 90 days after the stack has been deleted.

You must specify either \code{StackName} or \code{PhysicalResourceId}, but not
both. In addition, you can specify \code{LogicalResourceId} to filter the
returned result. For more information about resources, the
\code{LogicalResourceId} and \code{PhysicalResourceId}, go to the \href{http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/}{AWS CloudFormation User Guide}.

A \code{ValidationError} is returned if you specify both \code{StackName} and
\code{PhysicalResourceId} in the same request.
}
\section{Request syntax}{
\preformatted{svc$describe_stack_resources(
  StackName = "string",
  LogicalResourceId = "string",
  PhysicalResourceId = "string"
)
}
}

\keyword{internal}
