# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include cloudwatchevents_service.R
NULL

#' Deletes the specified rule
#'
#' Deletes the specified rule.
#' 
#' Before you can delete the rule, you must remove all targets, using
#' RemoveTargets.
#' 
#' When you delete a rule, incoming events might continue to match to the
#' deleted rule. Allow a short period of time for changes to take effect.
#' 
#' Managed rules are rules created and managed by another AWS service on
#' your behalf. These rules are created by those other AWS services to
#' support functionality in those services. You can delete these rules
#' using the `Force` option, but you should do so only if you are sure the
#' other service is not still using that rule.
#'
#' @usage
#' cloudwatchevents_delete_rule(Name, Force)
#'
#' @param Name &#91;required&#93; The name of the rule.
#' @param Force If this is a managed rule, created by an AWS service on your behalf, you
#' must specify `Force` as `True` to delete the rule. This parameter is
#' ignored for rules that are not managed rules. You can check whether a
#' rule is a managed rule by using `DescribeRule` or `ListRules` and
#' checking the `ManagedBy` field of the response.
#'
#' @section Request syntax:
#' ```
#' svc$delete_rule(
#'   Name = "string",
#'   Force = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_delete_rule
cloudwatchevents_delete_rule <- function(Name, Force = NULL) {
  op <- new_operation(
    name = "DeleteRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$delete_rule_input(Name = Name, Force = Force)
  output <- .cloudwatchevents$delete_rule_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$delete_rule <- cloudwatchevents_delete_rule

#' Displays the external AWS accounts that are permitted to write events to
#' your account using your account's event bus, and the associated policy
#'
#' Displays the external AWS accounts that are permitted to write events to
#' your account using your account\'s event bus, and the associated policy.
#' To enable your account to receive events from other accounts, use
#' PutPermission.
#'
#' @usage
#' cloudwatchevents_describe_event_bus()
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_bus()
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_describe_event_bus
cloudwatchevents_describe_event_bus <- function() {
  op <- new_operation(
    name = "DescribeEventBus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$describe_event_bus_input()
  output <- .cloudwatchevents$describe_event_bus_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$describe_event_bus <- cloudwatchevents_describe_event_bus

#' Describes the specified rule
#'
#' Describes the specified rule.
#' 
#' DescribeRule does not list the targets of a rule. To see the targets
#' associated with a rule, use ListTargetsByRule.
#'
#' @usage
#' cloudwatchevents_describe_rule(Name)
#'
#' @param Name &#91;required&#93; The name of the rule.
#'
#' @section Request syntax:
#' ```
#' svc$describe_rule(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_describe_rule
cloudwatchevents_describe_rule <- function(Name) {
  op <- new_operation(
    name = "DescribeRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$describe_rule_input(Name = Name)
  output <- .cloudwatchevents$describe_rule_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$describe_rule <- cloudwatchevents_describe_rule

#' Disables the specified rule
#'
#' Disables the specified rule. A disabled rule won\'t match any events,
#' and won\'t self-trigger if it has a schedule expression.
#' 
#' When you disable a rule, incoming events might continue to match to the
#' disabled rule. Allow a short period of time for changes to take effect.
#'
#' @usage
#' cloudwatchevents_disable_rule(Name)
#'
#' @param Name &#91;required&#93; The name of the rule.
#'
#' @section Request syntax:
#' ```
#' svc$disable_rule(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_disable_rule
cloudwatchevents_disable_rule <- function(Name) {
  op <- new_operation(
    name = "DisableRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$disable_rule_input(Name = Name)
  output <- .cloudwatchevents$disable_rule_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$disable_rule <- cloudwatchevents_disable_rule

#' Enables the specified rule
#'
#' Enables the specified rule. If the rule does not exist, the operation
#' fails.
#' 
#' When you enable a rule, incoming events might not immediately start
#' matching to a newly enabled rule. Allow a short period of time for
#' changes to take effect.
#'
#' @usage
#' cloudwatchevents_enable_rule(Name)
#'
#' @param Name &#91;required&#93; The name of the rule.
#'
#' @section Request syntax:
#' ```
#' svc$enable_rule(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_enable_rule
cloudwatchevents_enable_rule <- function(Name) {
  op <- new_operation(
    name = "EnableRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$enable_rule_input(Name = Name)
  output <- .cloudwatchevents$enable_rule_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$enable_rule <- cloudwatchevents_enable_rule

#' Lists the rules for the specified target
#'
#' Lists the rules for the specified target. You can see which of the rules
#' in Amazon CloudWatch Events can invoke a specific target in your
#' account.
#'
#' @usage
#' cloudwatchevents_list_rule_names_by_target(TargetArn, NextToken, Limit)
#'
#' @param TargetArn &#91;required&#93; The Amazon Resource Name (ARN) of the target resource.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_rule_names_by_target(
#'   TargetArn = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_rule_names_by_target
cloudwatchevents_list_rule_names_by_target <- function(TargetArn, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRuleNamesByTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$list_rule_names_by_target_input(TargetArn = TargetArn, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_rule_names_by_target_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_rule_names_by_target <- cloudwatchevents_list_rule_names_by_target

#' Lists your Amazon CloudWatch Events rules
#'
#' Lists your Amazon CloudWatch Events rules. You can either list all the
#' rules or you can provide a prefix to match to the rule names.
#' 
#' ListRules does not list the targets of a rule. To see the targets
#' associated with a rule, use ListTargetsByRule.
#'
#' @usage
#' cloudwatchevents_list_rules(NamePrefix, NextToken, Limit)
#'
#' @param NamePrefix The prefix matching the rule name.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_rules(
#'   NamePrefix = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_rules
cloudwatchevents_list_rules <- function(NamePrefix = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$list_rules_input(NamePrefix = NamePrefix, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_rules_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_rules <- cloudwatchevents_list_rules

#' Displays the tags associated with a CloudWatch Events resource
#'
#' Displays the tags associated with a CloudWatch Events resource. In
#' CloudWatch Events, rules can be tagged.
#'
#' @usage
#' cloudwatchevents_list_tags_for_resource(ResourceARN)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the CloudWatch Events rule for which you want to view tags.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_tags_for_resource
cloudwatchevents_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .cloudwatchevents$list_tags_for_resource_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_tags_for_resource <- cloudwatchevents_list_tags_for_resource

#' Lists the targets assigned to the specified rule
#'
#' Lists the targets assigned to the specified rule.
#'
#' @usage
#' cloudwatchevents_list_targets_by_rule(Rule, NextToken, Limit)
#'
#' @param Rule &#91;required&#93; The name of the rule.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_targets_by_rule(
#'   Rule = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_targets_by_rule
cloudwatchevents_list_targets_by_rule <- function(Rule, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListTargetsByRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$list_targets_by_rule_input(Rule = Rule, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_targets_by_rule_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_targets_by_rule <- cloudwatchevents_list_targets_by_rule

#' Sends custom events to Amazon CloudWatch Events so that they can be
#' matched to rules
#'
#' Sends custom events to Amazon CloudWatch Events so that they can be
#' matched to rules.
#'
#' @usage
#' cloudwatchevents_put_events(Entries)
#'
#' @param Entries &#91;required&#93; The entry that defines an event in your system. You can specify several
#' parameters for the entry such as the source and type of the event,
#' resources associated with the event, and so on.
#'
#' @section Request syntax:
#' ```
#' svc$put_events(
#'   Entries = list(
#'     list(
#'       Time = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Source = "string",
#'       Resources = list(
#'         "string"
#'       ),
#'       DetailType = "string",
#'       Detail = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_put_events
cloudwatchevents_put_events <- function(Entries) {
  op <- new_operation(
    name = "PutEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$put_events_input(Entries = Entries)
  output <- .cloudwatchevents$put_events_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$put_events <- cloudwatchevents_put_events

#' Running PutPermission permits the specified AWS account or AWS
#' organization to put events to your account's default _event bus_
#'
#' Running `PutPermission` permits the specified AWS account or AWS
#' organization to put events to your account\'s default *event bus*.
#' CloudWatch Events rules in your account are triggered by these events
#' arriving to your default event bus.
#' 
#' For another account to send events to your account, that external
#' account must have a CloudWatch Events rule with your account\'s default
#' event bus as a target.
#' 
#' To enable multiple AWS accounts to put events to your default event bus,
#' run `PutPermission` once for each of these accounts. Or, if all the
#' accounts are members of the same AWS organization, you can run
#' `PutPermission` once specifying `Principal` as \"\*\" and specifying the
#' AWS organization ID in `Condition`, to grant permissions to all accounts
#' in that organization.
#' 
#' If you grant permissions using an organization, then accounts in that
#' organization must specify a `RoleArn` with proper permissions when they
#' use `PutTarget` to add your account\'s event bus as a target. For more
#' information, see [Sending and Receiving Events Between AWS
#' Accounts](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEvents-CrossAccountEventDelivery.html)
#' in the *Amazon CloudWatch Events User Guide*.
#' 
#' The permission policy on the default event bus cannot exceed 10 KB in
#' size.
#'
#' @usage
#' cloudwatchevents_put_permission(Action, Principal, StatementId,
#'   Condition)
#'
#' @param Action &#91;required&#93; The action that you are enabling the other account to perform.
#' Currently, this must be `events:PutEvents`.
#' @param Principal &#91;required&#93; The 12-digit AWS account ID that you are permitting to put events to
#' your default event bus. Specify \"\*\" to permit any account to put
#' events to your default event bus.
#' 
#' If you specify \"\*\" without specifying `Condition`, avoid creating
#' rules that may match undesirable events. To create more secure rules,
#' make sure that the event pattern for each rule contains an `account`
#' field with a specific account ID from which to receive events. Rules
#' with an account field do not match any events sent from other accounts.
#' @param StatementId &#91;required&#93; An identifier string for the external account that you are granting
#' permissions to. If you later want to revoke the permission for this
#' external account, specify this `StatementId` when you run
#' RemovePermission.
#' @param Condition This parameter enables you to limit the permission to accounts that
#' fulfill a certain condition, such as being a member of a certain AWS
#' organization. For more information about AWS Organizations, see [What Is
#' AWS
#' Organizations](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html)
#' in the *AWS Organizations User Guide*.
#' 
#' If you specify `Condition` with an AWS organization ID, and specify
#' \"\*\" as the value for `Principal`, you grant permission to all the
#' accounts in the named organization.
#' 
#' The `Condition` is a JSON string which must contain `Type`, `Key`, and
#' `Value` fields.
#'
#' @section Request syntax:
#' ```
#' svc$put_permission(
#'   Action = "string",
#'   Principal = "string",
#'   StatementId = "string",
#'   Condition = list(
#'     Type = "string",
#'     Key = "string",
#'     Value = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_put_permission
cloudwatchevents_put_permission <- function(Action, Principal, StatementId, Condition = NULL) {
  op <- new_operation(
    name = "PutPermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$put_permission_input(Action = Action, Principal = Principal, StatementId = StatementId, Condition = Condition)
  output <- .cloudwatchevents$put_permission_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$put_permission <- cloudwatchevents_put_permission

#' Creates or updates the specified rule
#'
#' Creates or updates the specified rule. Rules are enabled by default, or
#' based on value of the state. You can disable a rule using DisableRule.
#' 
#' If you are updating an existing rule, the rule is replaced with what you
#' specify in this `PutRule` command. If you omit arguments in `PutRule`,
#' the old values for those arguments are not kept. Instead, they are
#' replaced with null values.
#' 
#' When you create or update a rule, incoming events might not immediately
#' start matching to new or updated rules. Allow a short period of time for
#' changes to take effect.
#' 
#' A rule must contain at least an EventPattern or ScheduleExpression.
#' Rules with EventPatterns are triggered when a matching event is
#' observed. Rules with ScheduleExpressions self-trigger based on the given
#' schedule. A rule can have both an EventPattern and a ScheduleExpression,
#' in which case the rule triggers on matching events as well as on a
#' schedule.
#' 
#' When you initially create a rule, you can optionally assign one or more
#' tags to the rule. Tags can help you organize and categorize your
#' resources. You can also use them to scope user permissions, by granting
#' a user permission to access or change only rules with certain tag
#' values. To use the `PutRule` operation and assign tags, you must have
#' both the `events:PutRule` and `events:TagResource` permissions.
#' 
#' If you are updating an existing rule, any tags you specify in the
#' `PutRule` operation are ignored. To update the tags of an existing rule,
#' use TagResource and UntagResource.
#' 
#' Most services in AWS treat : or / as the same character in Amazon
#' Resource Names (ARNs). However, CloudWatch Events uses an exact match in
#' event patterns and rules. Be sure to use the correct ARN characters when
#' creating event patterns so that they match the ARN syntax in the event
#' you want to match.
#' 
#' In CloudWatch Events, it is possible to create rules that lead to
#' infinite loops, where a rule is fired repeatedly. For example, a rule
#' might detect that ACLs have changed on an S3 bucket, and trigger
#' software to change them to the desired state. If the rule is not written
#' carefully, the subsequent change to the ACLs fires the rule again,
#' creating an infinite loop.
#' 
#' To prevent this, write the rules so that the triggered actions do not
#' re-fire the same rule. For example, your rule could fire only if ACLs
#' are found to be in a bad state, instead of after any change.
#' 
#' An infinite loop can quickly cause higher than expected charges. We
#' recommend that you use budgeting, which alerts you when charges exceed
#' your specified limit. For more information, see [Managing Your Costs
#' with
#' Budgets](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html).
#'
#' @usage
#' cloudwatchevents_put_rule(Name, ScheduleExpression, EventPattern, State,
#'   Description, RoleArn, Tags)
#'
#' @param Name &#91;required&#93; The name of the rule that you are creating or updating.
#' @param ScheduleExpression The scheduling expression. For example, \"cron(0 20 \* \* ? \*)\" or
#' \"rate(5 minutes)\".
#' @param EventPattern The event pattern. For more information, see [Events and Event
#' Patterns](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html)
#' in the *Amazon CloudWatch Events User Guide*.
#' @param State Indicates whether the rule is enabled or disabled.
#' @param Description A description of the rule.
#' @param RoleArn The Amazon Resource Name (ARN) of the IAM role associated with the rule.
#' @param Tags The list of key-value pairs to associate with the rule.
#'
#' @section Request syntax:
#' ```
#' svc$put_rule(
#'   Name = "string",
#'   ScheduleExpression = "string",
#'   EventPattern = "string",
#'   State = "ENABLED"|"DISABLED",
#'   Description = "string",
#'   RoleArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_put_rule
cloudwatchevents_put_rule <- function(Name, ScheduleExpression = NULL, EventPattern = NULL, State = NULL, Description = NULL, RoleArn = NULL, Tags = NULL) {
  op <- new_operation(
    name = "PutRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$put_rule_input(Name = Name, ScheduleExpression = ScheduleExpression, EventPattern = EventPattern, State = State, Description = Description, RoleArn = RoleArn, Tags = Tags)
  output <- .cloudwatchevents$put_rule_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$put_rule <- cloudwatchevents_put_rule

#' Adds the specified targets to the specified rule, or updates the targets
#' if they are already associated with the rule
#'
#' Adds the specified targets to the specified rule, or updates the targets
#' if they are already associated with the rule.
#' 
#' Targets are the resources that are invoked when a rule is triggered.
#' 
#' You can configure the following as targets for CloudWatch Events:
#' 
#' -   EC2 instances
#' 
#' -   SSM Run Command
#' 
#' -   SSM Automation
#' 
#' -   AWS Lambda functions
#' 
#' -   Data streams in Amazon Kinesis Data Streams
#' 
#' -   Data delivery streams in Amazon Kinesis Data Firehose
#' 
#' -   Amazon ECS tasks
#' 
#' -   AWS Step Functions state machines
#' 
#' -   AWS Batch jobs
#' 
#' -   AWS CodeBuild projects
#' 
#' -   Pipelines in AWS CodePipeline
#' 
#' -   Amazon Inspector assessment templates
#' 
#' -   Amazon SNS topics
#' 
#' -   Amazon SQS queues, including FIFO queues
#' 
#' -   The default event bus of another AWS account
#' 
#' Creating rules with built-in targets is supported only in the AWS
#' Management Console. The built-in targets are
#' `EC2 CreateSnapshot API call`, `EC2 RebootInstances API call`,
#' `EC2 StopInstances API call`, and `EC2 TerminateInstances API call`.
#' 
#' For some target types, `PutTargets` provides target-specific parameters.
#' If the target is a Kinesis data stream, you can optionally specify which
#' shard the event goes to by using the `KinesisParameters` argument. To
#' invoke a command on multiple EC2 instances with one rule, you can use
#' the `RunCommandParameters` field.
#' 
#' To be able to make API calls against the resources that you own, Amazon
#' CloudWatch Events needs the appropriate permissions. For AWS Lambda and
#' Amazon SNS resources, CloudWatch Events relies on resource-based
#' policies. For EC2 instances, Kinesis data streams, and AWS Step
#' Functions state machines, CloudWatch Events relies on IAM roles that you
#' specify in the `RoleARN` argument in `PutTargets`. For more information,
#' see [Authentication and Access
#' Control](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/auth-and-access-control-cwe.html)
#' in the *Amazon CloudWatch Events User Guide*.
#' 
#' If another AWS account is in the same region and has granted you
#' permission (using `PutPermission`), you can send events to that account.
#' Set that account\'s event bus as a target of the rules in your account.
#' To send the matched events to the other account, specify that account\'s
#' event bus as the `Arn` value when you run `PutTargets`. If your account
#' sends events to another account, your account is charged for each sent
#' event. Each event sent to another account is charged as a custom event.
#' The account receiving the event is not charged. For more information,
#' see [Amazon CloudWatch
#' Pricing](https://aws.amazon.com/cloudwatch/pricing/).
#' 
#' If you are setting the event bus of another account as the target, and
#' that account granted permission to your account through an organization
#' instead of directly by the account ID, then you must specify a `RoleArn`
#' with proper permissions in the `Target` structure. For more information,
#' see [Sending and Receiving Events Between AWS
#' Accounts](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEvents-CrossAccountEventDelivery.html)
#' in the *Amazon CloudWatch Events User Guide*.
#' 
#' For more information about enabling cross-account events, see
#' PutPermission.
#' 
#' **Input**, **InputPath**, and **InputTransformer** are mutually
#' exclusive and optional parameters of a target. When a rule is triggered
#' due to a matched event:
#' 
#' -   If none of the following arguments are specified for a target, then
#'     the entire event is passed to the target in JSON format (unless the
#'     target is Amazon EC2 Run Command or Amazon ECS task, in which case
#'     nothing from the event is passed to the target).
#' 
#' -   If **Input** is specified in the form of valid JSON, then the
#'     matched event is overridden with this constant.
#' 
#' -   If **InputPath** is specified in the form of JSONPath (for example,
#'     `$.detail`), then only the part of the event specified in the path
#'     is passed to the target (for example, only the detail part of the
#'     event is passed).
#' 
#' -   If **InputTransformer** is specified, then one or more specified
#'     JSONPaths are extracted from the event and used as values in a
#'     template that you specify as the input to the target.
#' 
#' When you specify `InputPath` or `InputTransformer`, you must use JSON
#' dot notation, not bracket notation.
#' 
#' When you add targets to a rule and the associated rule triggers soon
#' after, new or updated targets might not be immediately invoked. Allow a
#' short period of time for changes to take effect.
#' 
#' This action can partially fail if too many requests are made at the same
#' time. If that happens, `FailedEntryCount` is non-zero in the response
#' and each entry in `FailedEntries` provides the ID of the failed target
#' and the error code.
#'
#' @usage
#' cloudwatchevents_put_targets(Rule, Targets)
#'
#' @param Rule &#91;required&#93; The name of the rule.
#' @param Targets &#91;required&#93; The targets to update or add to the rule.
#'
#' @section Request syntax:
#' ```
#' svc$put_targets(
#'   Rule = "string",
#'   Targets = list(
#'     list(
#'       Id = "string",
#'       Arn = "string",
#'       RoleArn = "string",
#'       Input = "string",
#'       InputPath = "string",
#'       InputTransformer = list(
#'         InputPathsMap = list(
#'           "string"
#'         ),
#'         InputTemplate = "string"
#'       ),
#'       KinesisParameters = list(
#'         PartitionKeyPath = "string"
#'       ),
#'       RunCommandParameters = list(
#'         RunCommandTargets = list(
#'           list(
#'             Key = "string",
#'             Values = list(
#'               "string"
#'             )
#'           )
#'         )
#'       ),
#'       EcsParameters = list(
#'         TaskDefinitionArn = "string",
#'         TaskCount = 123,
#'         LaunchType = "EC2"|"FARGATE",
#'         NetworkConfiguration = list(
#'           awsvpcConfiguration = list(
#'             Subnets = list(
#'               "string"
#'             ),
#'             SecurityGroups = list(
#'               "string"
#'             ),
#'             AssignPublicIp = "ENABLED"|"DISABLED"
#'           )
#'         ),
#'         PlatformVersion = "string",
#'         Group = "string"
#'       ),
#'       BatchParameters = list(
#'         JobDefinition = "string",
#'         JobName = "string",
#'         ArrayProperties = list(
#'           Size = 123
#'         ),
#'         RetryStrategy = list(
#'           Attempts = 123
#'         )
#'       ),
#'       SqsParameters = list(
#'         MessageGroupId = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_put_targets
cloudwatchevents_put_targets <- function(Rule, Targets) {
  op <- new_operation(
    name = "PutTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$put_targets_input(Rule = Rule, Targets = Targets)
  output <- .cloudwatchevents$put_targets_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$put_targets <- cloudwatchevents_put_targets

#' Revokes the permission of another AWS account to be able to put events
#' to your default event bus
#'
#' Revokes the permission of another AWS account to be able to put events
#' to your default event bus. Specify the account to revoke by the
#' `StatementId` value that you associated with the account when you
#' granted it permission with `PutPermission`. You can find the
#' `StatementId` by using DescribeEventBus.
#'
#' @usage
#' cloudwatchevents_remove_permission(StatementId)
#'
#' @param StatementId &#91;required&#93; The statement ID corresponding to the account that is no longer allowed
#' to put events to the default event bus.
#'
#' @section Request syntax:
#' ```
#' svc$remove_permission(
#'   StatementId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_remove_permission
cloudwatchevents_remove_permission <- function(StatementId) {
  op <- new_operation(
    name = "RemovePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$remove_permission_input(StatementId = StatementId)
  output <- .cloudwatchevents$remove_permission_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$remove_permission <- cloudwatchevents_remove_permission

#' Removes the specified targets from the specified rule
#'
#' Removes the specified targets from the specified rule. When the rule is
#' triggered, those targets are no longer be invoked.
#' 
#' When you remove a target, when the associated rule triggers, removed
#' targets might continue to be invoked. Allow a short period of time for
#' changes to take effect.
#' 
#' This action can partially fail if too many requests are made at the same
#' time. If that happens, `FailedEntryCount` is non-zero in the response
#' and each entry in `FailedEntries` provides the ID of the failed target
#' and the error code.
#'
#' @usage
#' cloudwatchevents_remove_targets(Rule, Ids, Force)
#'
#' @param Rule &#91;required&#93; The name of the rule.
#' @param Ids &#91;required&#93; The IDs of the targets to remove from the rule.
#' @param Force If this is a managed rule, created by an AWS service on your behalf, you
#' must specify `Force` as `True` to remove targets. This parameter is
#' ignored for rules that are not managed rules. You can check whether a
#' rule is a managed rule by using `DescribeRule` or `ListRules` and
#' checking the `ManagedBy` field of the response.
#'
#' @section Request syntax:
#' ```
#' svc$remove_targets(
#'   Rule = "string",
#'   Ids = list(
#'     "string"
#'   ),
#'   Force = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_remove_targets
cloudwatchevents_remove_targets <- function(Rule, Ids, Force = NULL) {
  op <- new_operation(
    name = "RemoveTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$remove_targets_input(Rule = Rule, Ids = Ids, Force = Force)
  output <- .cloudwatchevents$remove_targets_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$remove_targets <- cloudwatchevents_remove_targets

#' Assigns one or more tags (key-value pairs) to the specified CloudWatch
#' Events resource
#'
#' Assigns one or more tags (key-value pairs) to the specified CloudWatch
#' Events resource. Tags can help you organize and categorize your
#' resources. You can also use them to scope user permissions by granting a
#' user permission to access or change only resources with certain tag
#' values. In CloudWatch Events, rules can be tagged.
#' 
#' Tags don\'t have any semantic meaning to AWS and are interpreted
#' strictly as strings of characters.
#' 
#' You can use the `TagResource` action with a rule that already has tags.
#' If you specify a new tag key for the rule, this tag is appended to the
#' list of tags associated with the rule. If you specify a tag key that is
#' already associated with the rule, the new tag value that you specify
#' replaces the previous value for that tag.
#' 
#' You can associate as many as 50 tags with a resource.
#'
#' @usage
#' cloudwatchevents_tag_resource(ResourceARN, Tags)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the CloudWatch Events rule that you\'re adding tags to.
#' @param Tags &#91;required&#93; The list of key-value pairs to associate with the rule.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceARN = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_tag_resource
cloudwatchevents_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .cloudwatchevents$tag_resource_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$tag_resource <- cloudwatchevents_tag_resource

#' Tests whether the specified event pattern matches the provided event
#'
#' Tests whether the specified event pattern matches the provided event.
#' 
#' Most services in AWS treat : or / as the same character in Amazon
#' Resource Names (ARNs). However, CloudWatch Events uses an exact match in
#' event patterns and rules. Be sure to use the correct ARN characters when
#' creating event patterns so that they match the ARN syntax in the event
#' you want to match.
#'
#' @usage
#' cloudwatchevents_test_event_pattern(EventPattern, Event)
#'
#' @param EventPattern &#91;required&#93; The event pattern. For more information, see [Events and Event
#' Patterns](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html)
#' in the *Amazon CloudWatch Events User Guide*.
#' @param Event &#91;required&#93; The event, in JSON format, to test against the event pattern.
#'
#' @section Request syntax:
#' ```
#' svc$test_event_pattern(
#'   EventPattern = "string",
#'   Event = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_test_event_pattern
cloudwatchevents_test_event_pattern <- function(EventPattern, Event) {
  op <- new_operation(
    name = "TestEventPattern",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$test_event_pattern_input(EventPattern = EventPattern, Event = Event)
  output <- .cloudwatchevents$test_event_pattern_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$test_event_pattern <- cloudwatchevents_test_event_pattern

#' Removes one or more tags from the specified CloudWatch Events resource
#'
#' Removes one or more tags from the specified CloudWatch Events resource.
#' In CloudWatch Events, rules can be tagged.
#'
#' @usage
#' cloudwatchevents_untag_resource(ResourceARN, TagKeys)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the CloudWatch Events rule from which you are removing tags.
#' @param TagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_untag_resource
cloudwatchevents_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudwatchevents$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .cloudwatchevents$untag_resource_output()
  svc <- .cloudwatchevents$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$untag_resource <- cloudwatchevents_untag_resource
