% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockagent_operations.R
\name{bedrockagent_associate_agent_knowledge_base}
\alias{bedrockagent_associate_agent_knowledge_base}
\title{Associates a knowledge base with an agent}
\usage{
bedrockagent_associate_agent_knowledge_base(
  agentId,
  agentVersion,
  description,
  knowledgeBaseId,
  knowledgeBaseState = NULL
)
}
\arguments{
\item{agentId}{[required] The unique identifier of the agent with which you want to associate the
knowledge base.}

\item{agentVersion}{[required] The version of the agent with which you want to associate the knowledge
base.}

\item{description}{[required] A description of what the agent should use the knowledge base for.}

\item{knowledgeBaseId}{[required] The unique identifier of the knowledge base to associate with the agent.}

\item{knowledgeBaseState}{Specifies whether to use the knowledge base or not when sending an
\href{https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html}{InvokeAgent}
request.}
}
\description{
Associates a knowledge base with an agent. If a knowledge base is associated and its \code{indexState} is set to \code{Enabled}, the agent queries the knowledge base for information to augment its response to the user.

See \url{https://www.paws-r-sdk.com/docs/bedrockagent_associate_agent_knowledge_base/} for full documentation.
}
\keyword{internal}
