% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_optimization_job}
\alias{sagemaker_create_optimization_job}
\title{Creates a job that optimizes a model for inference performance}
\usage{
sagemaker_create_optimization_job(
  OptimizationJobName,
  RoleArn,
  ModelSource,
  DeploymentInstanceType,
  OptimizationEnvironment = NULL,
  OptimizationConfigs,
  OutputConfig,
  StoppingCondition,
  Tags = NULL,
  VpcConfig = NULL
)
}
\arguments{
\item{OptimizationJobName}{[required] A custom name for the new optimization job.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of an IAM role that enables Amazon
SageMaker to perform tasks on your behalf.

During model optimization, Amazon SageMaker needs your permission to:
\itemize{
\item Read input data from an S3 bucket
\item Write model artifacts to an S3 bucket
\item Write logs to Amazon CloudWatch Logs
\item Publish metrics to Amazon CloudWatch
}

You grant permissions for all of these tasks to an IAM role. To pass
this role to Amazon SageMaker, the caller of this API must have the
\code{iam:PassRole} permission. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html}{Amazon SageMaker Roles.}}

\item{ModelSource}{[required] The location of the source model to optimize with an optimization job.}

\item{DeploymentInstanceType}{[required] The type of instance that hosts the optimized model that you create with
the optimization job.}

\item{OptimizationEnvironment}{The environment variables to set in the model container.}

\item{OptimizationConfigs}{[required] Settings for each of the optimization techniques that the job applies.}

\item{OutputConfig}{[required] Details for where to store the optimized model that you create with the
optimization job.}

\item{StoppingCondition}{[required]}

\item{Tags}{A list of key-value pairs associated with the optimization job. For more
information, see \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services resources}
in the \emph{Amazon Web Services General Reference Guide}.}

\item{VpcConfig}{A VPC in Amazon VPC that your optimized model has access to.}
}
\description{
Creates a job that optimizes a model for inference performance. To create the job, you provide the location of a source model, and you provide the settings for the optimization techniques that you want the job to apply. When the job completes successfully, SageMaker uploads the new optimized model to the output destination that you specify.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_optimization_job/} for full documentation.
}
\keyword{internal}
