# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include frauddetector_service.R
NULL

#' Creates a batch of variables
#'
#' @description
#' Creates a batch of variables.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_batch_create_variable/](https://www.paws-r-sdk.com/docs/frauddetector_batch_create_variable/) for full documentation.
#'
#' @param variableEntries &#91;required&#93; The list of variables for the batch create variable request.
#' @param tags A collection of key and value pairs.
#'
#' @keywords internal
#'
#' @rdname frauddetector_batch_create_variable
frauddetector_batch_create_variable <- function(variableEntries, tags = NULL) {
  op <- new_operation(
    name = "BatchCreateVariable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$batch_create_variable_input(variableEntries = variableEntries, tags = tags)
  output <- .frauddetector$batch_create_variable_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$batch_create_variable <- frauddetector_batch_create_variable

#' Gets a batch of variables
#'
#' @description
#' Gets a batch of variables.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_batch_get_variable/](https://www.paws-r-sdk.com/docs/frauddetector_batch_get_variable/) for full documentation.
#'
#' @param names &#91;required&#93; The list of variable names to get.
#'
#' @keywords internal
#'
#' @rdname frauddetector_batch_get_variable
frauddetector_batch_get_variable <- function(names) {
  op <- new_operation(
    name = "BatchGetVariable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$batch_get_variable_input(names = names)
  output <- .frauddetector$batch_get_variable_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$batch_get_variable <- frauddetector_batch_get_variable

#' Cancels an in-progress batch import job
#'
#' @description
#' Cancels an in-progress batch import job.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_cancel_batch_import_job/](https://www.paws-r-sdk.com/docs/frauddetector_cancel_batch_import_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The ID of an in-progress batch import job to cancel.
#' 
#' Amazon Fraud Detector will throw an error if the batch import job is in
#' `FAILED`, `CANCELED`, or `COMPLETED` state.
#'
#' @keywords internal
#'
#' @rdname frauddetector_cancel_batch_import_job
frauddetector_cancel_batch_import_job <- function(jobId) {
  op <- new_operation(
    name = "CancelBatchImportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$cancel_batch_import_job_input(jobId = jobId)
  output <- .frauddetector$cancel_batch_import_job_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$cancel_batch_import_job <- frauddetector_cancel_batch_import_job

#' Cancels the specified batch prediction job
#'
#' @description
#' Cancels the specified batch prediction job.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_cancel_batch_prediction_job/](https://www.paws-r-sdk.com/docs/frauddetector_cancel_batch_prediction_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The ID of the batch prediction job to cancel.
#'
#' @keywords internal
#'
#' @rdname frauddetector_cancel_batch_prediction_job
frauddetector_cancel_batch_prediction_job <- function(jobId) {
  op <- new_operation(
    name = "CancelBatchPredictionJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$cancel_batch_prediction_job_input(jobId = jobId)
  output <- .frauddetector$cancel_batch_prediction_job_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$cancel_batch_prediction_job <- frauddetector_cancel_batch_prediction_job

#' Creates a batch import job
#'
#' @description
#' Creates a batch import job.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_create_batch_import_job/](https://www.paws-r-sdk.com/docs/frauddetector_create_batch_import_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The ID of the batch import job. The ID cannot be of a past job, unless
#' the job exists in `CREATE_FAILED` state.
#' @param inputPath &#91;required&#93; The URI that points to the Amazon S3 location of your data file.
#' @param outputPath &#91;required&#93; The URI that points to the Amazon S3 location for storing your results.
#' @param eventTypeName &#91;required&#93; The name of the event type.
#' @param iamRoleArn &#91;required&#93; The ARN of the IAM role created for Amazon S3 bucket that holds your
#' data file.
#' 
#' The IAM role must have read permissions to your input S3 bucket and
#' write permissions to your output S3 bucket. For more information about
#' bucket permissions, see [User policy
#' examples](https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-policies-s3.html)
#' in the *Amazon S3 User Guide*.
#' @param tags A collection of key-value pairs associated with this request.
#'
#' @keywords internal
#'
#' @rdname frauddetector_create_batch_import_job
frauddetector_create_batch_import_job <- function(jobId, inputPath, outputPath, eventTypeName, iamRoleArn, tags = NULL) {
  op <- new_operation(
    name = "CreateBatchImportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$create_batch_import_job_input(jobId = jobId, inputPath = inputPath, outputPath = outputPath, eventTypeName = eventTypeName, iamRoleArn = iamRoleArn, tags = tags)
  output <- .frauddetector$create_batch_import_job_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$create_batch_import_job <- frauddetector_create_batch_import_job

#' Creates a batch prediction job
#'
#' @description
#' Creates a batch prediction job.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_create_batch_prediction_job/](https://www.paws-r-sdk.com/docs/frauddetector_create_batch_prediction_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The ID of the batch prediction job.
#' @param inputPath &#91;required&#93; The Amazon S3 location of your training file.
#' @param outputPath &#91;required&#93; The Amazon S3 location of your output file.
#' @param eventTypeName &#91;required&#93; The name of the event type.
#' @param detectorName &#91;required&#93; The name of the detector.
#' @param detectorVersion The detector version.
#' @param iamRoleArn &#91;required&#93; The ARN of the IAM role to use for this job request.
#' 
#' The IAM Role must have read permissions to your input S3 bucket and
#' write permissions to your output S3 bucket. For more information about
#' bucket permissions, see [User policy
#' examples](https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-policies-s3.html)
#' in the *Amazon S3 User Guide*.
#' @param tags A collection of key and value pairs.
#'
#' @keywords internal
#'
#' @rdname frauddetector_create_batch_prediction_job
frauddetector_create_batch_prediction_job <- function(jobId, inputPath, outputPath, eventTypeName, detectorName, detectorVersion = NULL, iamRoleArn, tags = NULL) {
  op <- new_operation(
    name = "CreateBatchPredictionJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$create_batch_prediction_job_input(jobId = jobId, inputPath = inputPath, outputPath = outputPath, eventTypeName = eventTypeName, detectorName = detectorName, detectorVersion = detectorVersion, iamRoleArn = iamRoleArn, tags = tags)
  output <- .frauddetector$create_batch_prediction_job_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$create_batch_prediction_job <- frauddetector_create_batch_prediction_job

#' Creates a detector version
#'
#' @description
#' Creates a detector version. The detector version starts in a `DRAFT` status.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_create_detector_version/](https://www.paws-r-sdk.com/docs/frauddetector_create_detector_version/) for full documentation.
#'
#' @param detectorId &#91;required&#93; The ID of the detector under which you want to create a new version.
#' @param description The description of the detector version.
#' @param externalModelEndpoints The Amazon Sagemaker model endpoints to include in the detector version.
#' @param rules &#91;required&#93; The rules to include in the detector version.
#' @param modelVersions The model versions to include in the detector version.
#' @param ruleExecutionMode The rule execution mode for the rules included in the detector version.
#' 
#' You can define and edit the rule mode at the detector version level,
#' when it is in draft status.
#' 
#' If you specify `FIRST_MATCHED`, Amazon Fraud Detector evaluates rules
#' sequentially, first to last, stopping at the first matched rule. Amazon
#' Fraud dectector then provides the outcomes for that single rule.
#' 
#' If you specifiy `ALL_MATCHED`, Amazon Fraud Detector evaluates all rules
#' and returns the outcomes for all matched rules.
#' 
#' The default behavior is `FIRST_MATCHED`.
#' @param tags A collection of key and value pairs.
#'
#' @keywords internal
#'
#' @rdname frauddetector_create_detector_version
frauddetector_create_detector_version <- function(detectorId, description = NULL, externalModelEndpoints = NULL, rules, modelVersions = NULL, ruleExecutionMode = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateDetectorVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$create_detector_version_input(detectorId = detectorId, description = description, externalModelEndpoints = externalModelEndpoints, rules = rules, modelVersions = modelVersions, ruleExecutionMode = ruleExecutionMode, tags = tags)
  output <- .frauddetector$create_detector_version_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$create_detector_version <- frauddetector_create_detector_version

#' Creates a list
#'
#' @description
#' Creates a list.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_create_list/](https://www.paws-r-sdk.com/docs/frauddetector_create_list/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the list.
#' @param elements The names of the elements, if providing. You can also create an empty
#' list and add elements later using the
#' [`update_list`][frauddetector_update_list] API.
#' @param variableType The variable type of the list. You can only assign the variable type
#' with String data type. For more information, see [Variable
#' types](https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types).
#' @param description The description of the list.
#' @param tags A collection of the key and value pairs.
#'
#' @keywords internal
#'
#' @rdname frauddetector_create_list
frauddetector_create_list <- function(name, elements = NULL, variableType = NULL, description = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateList",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$create_list_input(name = name, elements = elements, variableType = variableType, description = description, tags = tags)
  output <- .frauddetector$create_list_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$create_list <- frauddetector_create_list

#' Creates a model using the specified model type
#'
#' @description
#' Creates a model using the specified model type.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_create_model/](https://www.paws-r-sdk.com/docs/frauddetector_create_model/) for full documentation.
#'
#' @param modelId &#91;required&#93; The model ID.
#' @param modelType &#91;required&#93; The model type.
#' @param description The model description.
#' @param eventTypeName &#91;required&#93; The name of the event type.
#' @param tags A collection of key and value pairs.
#'
#' @keywords internal
#'
#' @rdname frauddetector_create_model
frauddetector_create_model <- function(modelId, modelType, description = NULL, eventTypeName, tags = NULL) {
  op <- new_operation(
    name = "CreateModel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$create_model_input(modelId = modelId, modelType = modelType, description = description, eventTypeName = eventTypeName, tags = tags)
  output <- .frauddetector$create_model_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$create_model <- frauddetector_create_model

#' Creates a version of the model using the specified model type and model
#' id
#'
#' @description
#' Creates a version of the model using the specified model type and model id.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_create_model_version/](https://www.paws-r-sdk.com/docs/frauddetector_create_model_version/) for full documentation.
#'
#' @param modelId &#91;required&#93; The model ID.
#' @param modelType &#91;required&#93; The model type.
#' @param trainingDataSource &#91;required&#93; The training data source location in Amazon S3.
#' @param trainingDataSchema &#91;required&#93; The training data schema.
#' @param externalEventsDetail Details of the external events data used for model version training.
#' Required if `trainingDataSource` is `EXTERNAL_EVENTS`.
#' @param ingestedEventsDetail Details of the ingested events data used for model version training.
#' Required if `trainingDataSource` is `INGESTED_EVENTS`.
#' @param tags A collection of key and value pairs.
#'
#' @keywords internal
#'
#' @rdname frauddetector_create_model_version
frauddetector_create_model_version <- function(modelId, modelType, trainingDataSource, trainingDataSchema, externalEventsDetail = NULL, ingestedEventsDetail = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateModelVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$create_model_version_input(modelId = modelId, modelType = modelType, trainingDataSource = trainingDataSource, trainingDataSchema = trainingDataSchema, externalEventsDetail = externalEventsDetail, ingestedEventsDetail = ingestedEventsDetail, tags = tags)
  output <- .frauddetector$create_model_version_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$create_model_version <- frauddetector_create_model_version

#' Creates a rule for use with the specified detector
#'
#' @description
#' Creates a rule for use with the specified detector.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_create_rule/](https://www.paws-r-sdk.com/docs/frauddetector_create_rule/) for full documentation.
#'
#' @param ruleId &#91;required&#93; The rule ID.
#' @param detectorId &#91;required&#93; The detector ID for the rule's parent detector.
#' @param description The rule description.
#' @param expression &#91;required&#93; The rule expression.
#' @param language &#91;required&#93; The language of the rule.
#' @param outcomes &#91;required&#93; The outcome or outcomes returned when the rule expression matches.
#' @param tags A collection of key and value pairs.
#'
#' @keywords internal
#'
#' @rdname frauddetector_create_rule
frauddetector_create_rule <- function(ruleId, detectorId, description = NULL, expression, language, outcomes, tags = NULL) {
  op <- new_operation(
    name = "CreateRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$create_rule_input(ruleId = ruleId, detectorId = detectorId, description = description, expression = expression, language = language, outcomes = outcomes, tags = tags)
  output <- .frauddetector$create_rule_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$create_rule <- frauddetector_create_rule

#' Creates a variable
#'
#' @description
#' Creates a variable.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_create_variable/](https://www.paws-r-sdk.com/docs/frauddetector_create_variable/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the variable.
#' @param dataType &#91;required&#93; The data type of the variable.
#' @param dataSource &#91;required&#93; The source of the data.
#' @param defaultValue &#91;required&#93; The default value for the variable when no value is received.
#' @param description The description.
#' @param variableType The variable type. For more information see [Variable
#' types](https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types).
#' 
#' Valid Values:
#' `AUTH_CODE | AVS | BILLING_ADDRESS_L1 | BILLING_ADDRESS_L2 | BILLING_CITY | BILLING_COUNTRY | BILLING_NAME | BILLING_PHONE | BILLING_STATE | BILLING_ZIP | CARD_BIN | CATEGORICAL | CURRENCY_CODE | EMAIL_ADDRESS | FINGERPRINT | FRAUD_LABEL | FREE_FORM_TEXT | IP_ADDRESS | NUMERIC | ORDER_ID | PAYMENT_TYPE | PHONE_NUMBER | PRICE | PRODUCT_CATEGORY | SHIPPING_ADDRESS_L1 | SHIPPING_ADDRESS_L2 | SHIPPING_CITY | SHIPPING_COUNTRY | SHIPPING_NAME | SHIPPING_PHONE | SHIPPING_STATE | SHIPPING_ZIP | USERAGENT`
#' @param tags A collection of key and value pairs.
#'
#' @keywords internal
#'
#' @rdname frauddetector_create_variable
frauddetector_create_variable <- function(name, dataType, dataSource, defaultValue, description = NULL, variableType = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateVariable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$create_variable_input(name = name, dataType = dataType, dataSource = dataSource, defaultValue = defaultValue, description = description, variableType = variableType, tags = tags)
  output <- .frauddetector$create_variable_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$create_variable <- frauddetector_create_variable

#' Deletes the specified batch import job ID record
#'
#' @description
#' Deletes the specified batch import job ID record. This action does not delete the data that was batch imported.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_delete_batch_import_job/](https://www.paws-r-sdk.com/docs/frauddetector_delete_batch_import_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The ID of the batch import job to delete.
#'
#' @keywords internal
#'
#' @rdname frauddetector_delete_batch_import_job
frauddetector_delete_batch_import_job <- function(jobId) {
  op <- new_operation(
    name = "DeleteBatchImportJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$delete_batch_import_job_input(jobId = jobId)
  output <- .frauddetector$delete_batch_import_job_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$delete_batch_import_job <- frauddetector_delete_batch_import_job

#' Deletes a batch prediction job
#'
#' @description
#' Deletes a batch prediction job.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_delete_batch_prediction_job/](https://www.paws-r-sdk.com/docs/frauddetector_delete_batch_prediction_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The ID of the batch prediction job to delete.
#'
#' @keywords internal
#'
#' @rdname frauddetector_delete_batch_prediction_job
frauddetector_delete_batch_prediction_job <- function(jobId) {
  op <- new_operation(
    name = "DeleteBatchPredictionJob",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$delete_batch_prediction_job_input(jobId = jobId)
  output <- .frauddetector$delete_batch_prediction_job_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$delete_batch_prediction_job <- frauddetector_delete_batch_prediction_job

#' Deletes the detector
#'
#' @description
#' Deletes the detector. Before deleting a detector, you must first delete all detector versions and rule versions associated with the detector.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_delete_detector/](https://www.paws-r-sdk.com/docs/frauddetector_delete_detector/) for full documentation.
#'
#' @param detectorId &#91;required&#93; The ID of the detector to delete.
#'
#' @keywords internal
#'
#' @rdname frauddetector_delete_detector
frauddetector_delete_detector <- function(detectorId) {
  op <- new_operation(
    name = "DeleteDetector",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$delete_detector_input(detectorId = detectorId)
  output <- .frauddetector$delete_detector_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$delete_detector <- frauddetector_delete_detector

#' Deletes the detector version
#'
#' @description
#' Deletes the detector version. You cannot delete detector versions that are in `ACTIVE` status.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_delete_detector_version/](https://www.paws-r-sdk.com/docs/frauddetector_delete_detector_version/) for full documentation.
#'
#' @param detectorId &#91;required&#93; The ID of the parent detector for the detector version to delete.
#' @param detectorVersionId &#91;required&#93; The ID of the detector version to delete.
#'
#' @keywords internal
#'
#' @rdname frauddetector_delete_detector_version
frauddetector_delete_detector_version <- function(detectorId, detectorVersionId) {
  op <- new_operation(
    name = "DeleteDetectorVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$delete_detector_version_input(detectorId = detectorId, detectorVersionId = detectorVersionId)
  output <- .frauddetector$delete_detector_version_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$delete_detector_version <- frauddetector_delete_detector_version

#' Deletes an entity type
#'
#' @description
#' Deletes an entity type.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_delete_entity_type/](https://www.paws-r-sdk.com/docs/frauddetector_delete_entity_type/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the entity type to delete.
#'
#' @keywords internal
#'
#' @rdname frauddetector_delete_entity_type
frauddetector_delete_entity_type <- function(name) {
  op <- new_operation(
    name = "DeleteEntityType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$delete_entity_type_input(name = name)
  output <- .frauddetector$delete_entity_type_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$delete_entity_type <- frauddetector_delete_entity_type

#' Deletes the specified event
#'
#' @description
#' Deletes the specified event.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_delete_event/](https://www.paws-r-sdk.com/docs/frauddetector_delete_event/) for full documentation.
#'
#' @param eventId &#91;required&#93; The ID of the event to delete.
#' @param eventTypeName &#91;required&#93; The name of the event type.
#' @param deleteAuditHistory Specifies whether or not to delete any predictions associated with the
#' event. If set to `True`,
#'
#' @keywords internal
#'
#' @rdname frauddetector_delete_event
frauddetector_delete_event <- function(eventId, eventTypeName, deleteAuditHistory = NULL) {
  op <- new_operation(
    name = "DeleteEvent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$delete_event_input(eventId = eventId, eventTypeName = eventTypeName, deleteAuditHistory = deleteAuditHistory)
  output <- .frauddetector$delete_event_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$delete_event <- frauddetector_delete_event

#' Deletes an event type
#'
#' @description
#' Deletes an event type.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_delete_event_type/](https://www.paws-r-sdk.com/docs/frauddetector_delete_event_type/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the event type to delete.
#'
#' @keywords internal
#'
#' @rdname frauddetector_delete_event_type
frauddetector_delete_event_type <- function(name) {
  op <- new_operation(
    name = "DeleteEventType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$delete_event_type_input(name = name)
  output <- .frauddetector$delete_event_type_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$delete_event_type <- frauddetector_delete_event_type

#' Deletes all events of a particular event type
#'
#' @description
#' Deletes all events of a particular event type.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_delete_events_by_event_type/](https://www.paws-r-sdk.com/docs/frauddetector_delete_events_by_event_type/) for full documentation.
#'
#' @param eventTypeName &#91;required&#93; The name of the event type.
#'
#' @keywords internal
#'
#' @rdname frauddetector_delete_events_by_event_type
frauddetector_delete_events_by_event_type <- function(eventTypeName) {
  op <- new_operation(
    name = "DeleteEventsByEventType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$delete_events_by_event_type_input(eventTypeName = eventTypeName)
  output <- .frauddetector$delete_events_by_event_type_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$delete_events_by_event_type <- frauddetector_delete_events_by_event_type

#' Removes a SageMaker model from Amazon Fraud Detector
#'
#' @description
#' Removes a SageMaker model from Amazon Fraud Detector.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_delete_external_model/](https://www.paws-r-sdk.com/docs/frauddetector_delete_external_model/) for full documentation.
#'
#' @param modelEndpoint &#91;required&#93; The endpoint of the Amazon Sagemaker model to delete.
#'
#' @keywords internal
#'
#' @rdname frauddetector_delete_external_model
frauddetector_delete_external_model <- function(modelEndpoint) {
  op <- new_operation(
    name = "DeleteExternalModel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$delete_external_model_input(modelEndpoint = modelEndpoint)
  output <- .frauddetector$delete_external_model_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$delete_external_model <- frauddetector_delete_external_model

#' Deletes a label
#'
#' @description
#' Deletes a label.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_delete_label/](https://www.paws-r-sdk.com/docs/frauddetector_delete_label/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the label to delete.
#'
#' @keywords internal
#'
#' @rdname frauddetector_delete_label
frauddetector_delete_label <- function(name) {
  op <- new_operation(
    name = "DeleteLabel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$delete_label_input(name = name)
  output <- .frauddetector$delete_label_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$delete_label <- frauddetector_delete_label

#' Deletes the list, provided it is not used in a rule
#'
#' @description
#' Deletes the list, provided it is not used in a rule.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_delete_list/](https://www.paws-r-sdk.com/docs/frauddetector_delete_list/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the list to delete.
#'
#' @keywords internal
#'
#' @rdname frauddetector_delete_list
frauddetector_delete_list <- function(name) {
  op <- new_operation(
    name = "DeleteList",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$delete_list_input(name = name)
  output <- .frauddetector$delete_list_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$delete_list <- frauddetector_delete_list

#' Deletes a model
#'
#' @description
#' Deletes a model.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_delete_model/](https://www.paws-r-sdk.com/docs/frauddetector_delete_model/) for full documentation.
#'
#' @param modelId &#91;required&#93; The model ID of the model to delete.
#' @param modelType &#91;required&#93; The model type of the model to delete.
#'
#' @keywords internal
#'
#' @rdname frauddetector_delete_model
frauddetector_delete_model <- function(modelId, modelType) {
  op <- new_operation(
    name = "DeleteModel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$delete_model_input(modelId = modelId, modelType = modelType)
  output <- .frauddetector$delete_model_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$delete_model <- frauddetector_delete_model

#' Deletes a model version
#'
#' @description
#' Deletes a model version.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_delete_model_version/](https://www.paws-r-sdk.com/docs/frauddetector_delete_model_version/) for full documentation.
#'
#' @param modelId &#91;required&#93; The model ID of the model version to delete.
#' @param modelType &#91;required&#93; The model type of the model version to delete.
#' @param modelVersionNumber &#91;required&#93; The model version number of the model version to delete.
#'
#' @keywords internal
#'
#' @rdname frauddetector_delete_model_version
frauddetector_delete_model_version <- function(modelId, modelType, modelVersionNumber) {
  op <- new_operation(
    name = "DeleteModelVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$delete_model_version_input(modelId = modelId, modelType = modelType, modelVersionNumber = modelVersionNumber)
  output <- .frauddetector$delete_model_version_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$delete_model_version <- frauddetector_delete_model_version

#' Deletes an outcome
#'
#' @description
#' Deletes an outcome.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_delete_outcome/](https://www.paws-r-sdk.com/docs/frauddetector_delete_outcome/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the outcome to delete.
#'
#' @keywords internal
#'
#' @rdname frauddetector_delete_outcome
frauddetector_delete_outcome <- function(name) {
  op <- new_operation(
    name = "DeleteOutcome",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$delete_outcome_input(name = name)
  output <- .frauddetector$delete_outcome_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$delete_outcome <- frauddetector_delete_outcome

#' Deletes the rule
#'
#' @description
#' Deletes the rule. You cannot delete a rule if it is used by an `ACTIVE` or `INACTIVE` detector version.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_delete_rule/](https://www.paws-r-sdk.com/docs/frauddetector_delete_rule/) for full documentation.
#'
#' @param rule &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname frauddetector_delete_rule
frauddetector_delete_rule <- function(rule) {
  op <- new_operation(
    name = "DeleteRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$delete_rule_input(rule = rule)
  output <- .frauddetector$delete_rule_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$delete_rule <- frauddetector_delete_rule

#' Deletes a variable
#'
#' @description
#' Deletes a variable.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_delete_variable/](https://www.paws-r-sdk.com/docs/frauddetector_delete_variable/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the variable to delete.
#'
#' @keywords internal
#'
#' @rdname frauddetector_delete_variable
frauddetector_delete_variable <- function(name) {
  op <- new_operation(
    name = "DeleteVariable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$delete_variable_input(name = name)
  output <- .frauddetector$delete_variable_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$delete_variable <- frauddetector_delete_variable

#' Gets all versions for a specified detector
#'
#' @description
#' Gets all versions for a specified detector.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_describe_detector/](https://www.paws-r-sdk.com/docs/frauddetector_describe_detector/) for full documentation.
#'
#' @param detectorId &#91;required&#93; The detector ID.
#' @param nextToken The next token from the previous response.
#' @param maxResults The maximum number of results to return for the request.
#'
#' @keywords internal
#'
#' @rdname frauddetector_describe_detector
frauddetector_describe_detector <- function(detectorId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeDetector",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$describe_detector_input(detectorId = detectorId, nextToken = nextToken, maxResults = maxResults)
  output <- .frauddetector$describe_detector_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$describe_detector <- frauddetector_describe_detector

#' Gets all of the model versions for the specified model type or for the
#' specified model type and model ID
#'
#' @description
#' Gets all of the model versions for the specified model type or for the specified model type and model ID. You can also get details for a single, specified model version.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_describe_model_versions/](https://www.paws-r-sdk.com/docs/frauddetector_describe_model_versions/) for full documentation.
#'
#' @param modelId The model ID.
#' @param modelVersionNumber The model version number.
#' @param modelType The model type.
#' @param nextToken The next token from the previous results.
#' @param maxResults The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname frauddetector_describe_model_versions
frauddetector_describe_model_versions <- function(modelId = NULL, modelVersionNumber = NULL, modelType = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeModelVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .frauddetector$describe_model_versions_input(modelId = modelId, modelVersionNumber = modelVersionNumber, modelType = modelType, nextToken = nextToken, maxResults = maxResults)
  output <- .frauddetector$describe_model_versions_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$describe_model_versions <- frauddetector_describe_model_versions

#' Gets all batch import jobs or a specific job of the specified ID
#'
#' @description
#' Gets all batch import jobs or a specific job of the specified ID. This is a paginated API. If you provide a null `maxResults`, this action retrieves a maximum of 50 records per page. If you provide a `maxResults`, the value must be between 1 and 50. To get the next page results, provide the pagination token from the `GetBatchImportJobsResponse` as part of your request. A null pagination token fetches the records from the beginning.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_batch_import_jobs/](https://www.paws-r-sdk.com/docs/frauddetector_get_batch_import_jobs/) for full documentation.
#'
#' @param jobId The ID of the batch import job to get.
#' @param maxResults The maximum number of objects to return for request.
#' @param nextToken The next token from the previous request.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_batch_import_jobs
frauddetector_get_batch_import_jobs <- function(jobId = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "GetBatchImportJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .frauddetector$get_batch_import_jobs_input(jobId = jobId, maxResults = maxResults, nextToken = nextToken)
  output <- .frauddetector$get_batch_import_jobs_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_batch_import_jobs <- frauddetector_get_batch_import_jobs

#' Gets all batch prediction jobs or a specific job if you specify a job ID
#'
#' @description
#' Gets all batch prediction jobs or a specific job if you specify a job ID. This is a paginated API. If you provide a null maxResults, this action retrieves a maximum of 50 records per page. If you provide a maxResults, the value must be between 1 and 50. To get the next page results, provide the pagination token from the GetBatchPredictionJobsResponse as part of your request. A null pagination token fetches the records from the beginning.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_batch_prediction_jobs/](https://www.paws-r-sdk.com/docs/frauddetector_get_batch_prediction_jobs/) for full documentation.
#'
#' @param jobId The batch prediction job for which to get the details.
#' @param maxResults The maximum number of objects to return for the request.
#' @param nextToken The next token from the previous request.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_batch_prediction_jobs
frauddetector_get_batch_prediction_jobs <- function(jobId = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "GetBatchPredictionJobs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .frauddetector$get_batch_prediction_jobs_input(jobId = jobId, maxResults = maxResults, nextToken = nextToken)
  output <- .frauddetector$get_batch_prediction_jobs_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_batch_prediction_jobs <- frauddetector_get_batch_prediction_jobs

#' Retrieves the status of a DeleteEventsByEventType action
#'
#' @description
#' Retrieves the status of a [`delete_events_by_event_type`][frauddetector_delete_events_by_event_type] action.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_delete_events_by_event_type_status/](https://www.paws-r-sdk.com/docs/frauddetector_get_delete_events_by_event_type_status/) for full documentation.
#'
#' @param eventTypeName &#91;required&#93; Name of event type for which to get the deletion status.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_delete_events_by_event_type_status
frauddetector_get_delete_events_by_event_type_status <- function(eventTypeName) {
  op <- new_operation(
    name = "GetDeleteEventsByEventTypeStatus",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$get_delete_events_by_event_type_status_input(eventTypeName = eventTypeName)
  output <- .frauddetector$get_delete_events_by_event_type_status_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_delete_events_by_event_type_status <- frauddetector_get_delete_events_by_event_type_status

#' Gets a particular detector version
#'
#' @description
#' Gets a particular detector version.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_detector_version/](https://www.paws-r-sdk.com/docs/frauddetector_get_detector_version/) for full documentation.
#'
#' @param detectorId &#91;required&#93; The detector ID.
#' @param detectorVersionId &#91;required&#93; The detector version ID.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_detector_version
frauddetector_get_detector_version <- function(detectorId, detectorVersionId) {
  op <- new_operation(
    name = "GetDetectorVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$get_detector_version_input(detectorId = detectorId, detectorVersionId = detectorVersionId)
  output <- .frauddetector$get_detector_version_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_detector_version <- frauddetector_get_detector_version

#' Gets all detectors or a single detector if a detectorId is specified
#'
#' @description
#' Gets all detectors or a single detector if a `detectorId` is specified. This is a paginated API. If you provide a null `maxResults`, this action retrieves a maximum of 10 records per page. If you provide a `maxResults`, the value must be between 5 and 10. To get the next page results, provide the pagination token from the `GetDetectorsResponse` as part of your request. A null pagination token fetches the records from the beginning.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_detectors/](https://www.paws-r-sdk.com/docs/frauddetector_get_detectors/) for full documentation.
#'
#' @param detectorId The detector ID.
#' @param nextToken The next token for the subsequent request.
#' @param maxResults The maximum number of objects to return for the request.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_detectors
frauddetector_get_detectors <- function(detectorId = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetDetectors",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .frauddetector$get_detectors_input(detectorId = detectorId, nextToken = nextToken, maxResults = maxResults)
  output <- .frauddetector$get_detectors_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_detectors <- frauddetector_get_detectors

#' Gets all entity types or a specific entity type if a name is specified
#'
#' @description
#' Gets all entity types or a specific entity type if a name is specified. This is a paginated API. If you provide a null `maxResults`, this action retrieves a maximum of 10 records per page. If you provide a `maxResults`, the value must be between 5 and 10. To get the next page results, provide the pagination token from the `GetEntityTypesResponse` as part of your request. A null pagination token fetches the records from the beginning.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_entity_types/](https://www.paws-r-sdk.com/docs/frauddetector_get_entity_types/) for full documentation.
#'
#' @param name The name.
#' @param nextToken The next token for the subsequent request.
#' @param maxResults The maximum number of objects to return for the request.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_entity_types
frauddetector_get_entity_types <- function(name = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetEntityTypes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .frauddetector$get_entity_types_input(name = name, nextToken = nextToken, maxResults = maxResults)
  output <- .frauddetector$get_entity_types_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_entity_types <- frauddetector_get_entity_types

#' Retrieves details of events stored with Amazon Fraud Detector
#'
#' @description
#' Retrieves details of events stored with Amazon Fraud Detector. This action does not retrieve prediction results.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_event/](https://www.paws-r-sdk.com/docs/frauddetector_get_event/) for full documentation.
#'
#' @param eventId &#91;required&#93; The ID of the event to retrieve.
#' @param eventTypeName &#91;required&#93; The event type of the event to retrieve.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_event
frauddetector_get_event <- function(eventId, eventTypeName) {
  op <- new_operation(
    name = "GetEvent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$get_event_input(eventId = eventId, eventTypeName = eventTypeName)
  output <- .frauddetector$get_event_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_event <- frauddetector_get_event

#' Evaluates an event against a detector version
#'
#' @description
#' Evaluates an event against a detector version. If a version ID is not provided, the detector’s (`ACTIVE`) version is used.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_event_prediction/](https://www.paws-r-sdk.com/docs/frauddetector_get_event_prediction/) for full documentation.
#'
#' @param detectorId &#91;required&#93; The detector ID.
#' @param detectorVersionId The detector version ID.
#' @param eventId &#91;required&#93; The unique ID used to identify the event.
#' @param eventTypeName &#91;required&#93; The event type associated with the detector specified for the
#' prediction.
#' @param entities &#91;required&#93; The entity type (associated with the detector's event type) and specific
#' entity ID representing who performed the event. If an entity id is not
#' available, use "UNKNOWN."
#' @param eventTimestamp &#91;required&#93; Timestamp that defines when the event under evaluation occurred. The
#' timestamp must be specified using ISO 8601 standard in UTC.
#' @param eventVariables &#91;required&#93; Names of the event type's variables you defined in Amazon Fraud Detector
#' to represent data elements and their corresponding values for the event
#' you are sending for evaluation.
#' 
#' You must provide at least one eventVariable
#' 
#' To ensure most accurate fraud prediction and to simplify your data
#' preparation, Amazon Fraud Detector will replace all missing variables or
#' values as follows:
#' 
#' **For Amazon Fraud Detector trained models:**
#' 
#' If a null value is provided explicitly for a variable or if a variable
#' is missing, model will replace the null value or the missing variable
#' (no variable name in the eventVariables map) with calculated default
#' mean/medians for numeric variables and with special values for
#' categorical variables.
#' 
#' **For imported SageMaker models:**
#' 
#' If a null value is provided explicitly for a variable, the model and
#' rules will use “null” as the value. If a variable is not provided (no
#' variable name in the eventVariables map), model and rules will use the
#' default value that is provided for the variable.
#' @param externalModelEndpointDataBlobs The Amazon SageMaker model endpoint input data blobs.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_event_prediction
frauddetector_get_event_prediction <- function(detectorId, detectorVersionId = NULL, eventId, eventTypeName, entities, eventTimestamp, eventVariables, externalModelEndpointDataBlobs = NULL) {
  op <- new_operation(
    name = "GetEventPrediction",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$get_event_prediction_input(detectorId = detectorId, detectorVersionId = detectorVersionId, eventId = eventId, eventTypeName = eventTypeName, entities = entities, eventTimestamp = eventTimestamp, eventVariables = eventVariables, externalModelEndpointDataBlobs = externalModelEndpointDataBlobs)
  output <- .frauddetector$get_event_prediction_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_event_prediction <- frauddetector_get_event_prediction

#' Gets details of the past fraud predictions for the specified event ID,
#' event type, detector ID, and detector version ID that was generated in
#' the specified time period
#'
#' @description
#' Gets details of the past fraud predictions for the specified event ID, event type, detector ID, and detector version ID that was generated in the specified time period.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_event_prediction_metadata/](https://www.paws-r-sdk.com/docs/frauddetector_get_event_prediction_metadata/) for full documentation.
#'
#' @param eventId &#91;required&#93; The event ID.
#' @param eventTypeName &#91;required&#93; The event type associated with the detector specified for the
#' prediction.
#' @param detectorId &#91;required&#93; The detector ID.
#' @param detectorVersionId &#91;required&#93; The detector version ID.
#' @param predictionTimestamp &#91;required&#93; The timestamp that defines when the prediction was generated. The
#' timestamp must be specified using ISO 8601 standard in UTC.
#' 
#' We recommend calling
#' [`list_event_predictions`][frauddetector_list_event_predictions] first,
#' and using the `predictionTimestamp` value in the response to provide an
#' accurate prediction timestamp value.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_event_prediction_metadata
frauddetector_get_event_prediction_metadata <- function(eventId, eventTypeName, detectorId, detectorVersionId, predictionTimestamp) {
  op <- new_operation(
    name = "GetEventPredictionMetadata",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$get_event_prediction_metadata_input(eventId = eventId, eventTypeName = eventTypeName, detectorId = detectorId, detectorVersionId = detectorVersionId, predictionTimestamp = predictionTimestamp)
  output <- .frauddetector$get_event_prediction_metadata_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_event_prediction_metadata <- frauddetector_get_event_prediction_metadata

#' Gets all event types or a specific event type if name is provided
#'
#' @description
#' Gets all event types or a specific event type if name is provided. This is a paginated API. If you provide a null `maxResults`, this action retrieves a maximum of 10 records per page. If you provide a `maxResults`, the value must be between 5 and 10. To get the next page results, provide the pagination token from the `GetEventTypesResponse` as part of your request. A null pagination token fetches the records from the beginning.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_event_types/](https://www.paws-r-sdk.com/docs/frauddetector_get_event_types/) for full documentation.
#'
#' @param name The name.
#' @param nextToken The next token for the subsequent request.
#' @param maxResults The maximum number of objects to return for the request.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_event_types
frauddetector_get_event_types <- function(name = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetEventTypes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .frauddetector$get_event_types_input(name = name, nextToken = nextToken, maxResults = maxResults)
  output <- .frauddetector$get_event_types_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_event_types <- frauddetector_get_event_types

#' Gets the details for one or more Amazon SageMaker models that have been
#' imported into the service
#'
#' @description
#' Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a paginated API. If you provide a null `maxResults`, this actions retrieves a maximum of 10 records per page. If you provide a `maxResults`, the value must be between 5 and 10. To get the next page results, provide the pagination token from the `GetExternalModelsResult` as part of your request. A null pagination token fetches the records from the beginning.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_external_models/](https://www.paws-r-sdk.com/docs/frauddetector_get_external_models/) for full documentation.
#'
#' @param modelEndpoint The Amazon SageMaker model endpoint.
#' @param nextToken The next page token for the request.
#' @param maxResults The maximum number of objects to return for the request.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_external_models
frauddetector_get_external_models <- function(modelEndpoint = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetExternalModels",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .frauddetector$get_external_models_input(modelEndpoint = modelEndpoint, nextToken = nextToken, maxResults = maxResults)
  output <- .frauddetector$get_external_models_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_external_models <- frauddetector_get_external_models

#' Gets the encryption key if a KMS key has been specified to be used to
#' encrypt content in Amazon Fraud Detector
#'
#' @description
#' Gets the encryption key if a KMS key has been specified to be used to encrypt content in Amazon Fraud Detector.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_kms_encryption_key/](https://www.paws-r-sdk.com/docs/frauddetector_get_kms_encryption_key/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname frauddetector_get_kms_encryption_key
frauddetector_get_kms_encryption_key <- function() {
  op <- new_operation(
    name = "GetKMSEncryptionKey",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$get_kms_encryption_key_input()
  output <- .frauddetector$get_kms_encryption_key_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_kms_encryption_key <- frauddetector_get_kms_encryption_key

#' Gets all labels or a specific label if name is provided
#'
#' @description
#' Gets all labels or a specific label if name is provided. This is a paginated API. If you provide a null `maxResults`, this action retrieves a maximum of 50 records per page. If you provide a `maxResults`, the value must be between 10 and 50. To get the next page results, provide the pagination token from the `GetGetLabelsResponse` as part of your request. A null pagination token fetches the records from the beginning.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_labels/](https://www.paws-r-sdk.com/docs/frauddetector_get_labels/) for full documentation.
#'
#' @param name The name of the label or labels to get.
#' @param nextToken The next token for the subsequent request.
#' @param maxResults The maximum number of objects to return for the request.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_labels
frauddetector_get_labels <- function(name = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetLabels",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .frauddetector$get_labels_input(name = name, nextToken = nextToken, maxResults = maxResults)
  output <- .frauddetector$get_labels_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_labels <- frauddetector_get_labels

#' Gets all the elements in the specified list
#'
#' @description
#' Gets all the elements in the specified list.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_list_elements/](https://www.paws-r-sdk.com/docs/frauddetector_get_list_elements/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the list.
#' @param nextToken The next token for the subsequent request.
#' @param maxResults The maximum number of objects to return for the request.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_list_elements
frauddetector_get_list_elements <- function(name, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetListElements",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .frauddetector$get_list_elements_input(name = name, nextToken = nextToken, maxResults = maxResults)
  output <- .frauddetector$get_list_elements_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_list_elements <- frauddetector_get_list_elements

#' Gets the metadata of either all the lists under the account or the
#' specified list
#'
#' @description
#' Gets the metadata of either all the lists under the account or the specified list.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_lists_metadata/](https://www.paws-r-sdk.com/docs/frauddetector_get_lists_metadata/) for full documentation.
#'
#' @param name The name of the list.
#' @param nextToken The next token for the subsequent request.
#' @param maxResults The maximum number of objects to return for the request.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_lists_metadata
frauddetector_get_lists_metadata <- function(name = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetListsMetadata",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .frauddetector$get_lists_metadata_input(name = name, nextToken = nextToken, maxResults = maxResults)
  output <- .frauddetector$get_lists_metadata_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_lists_metadata <- frauddetector_get_lists_metadata

#' Gets the details of the specified model version
#'
#' @description
#' Gets the details of the specified model version.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_model_version/](https://www.paws-r-sdk.com/docs/frauddetector_get_model_version/) for full documentation.
#'
#' @param modelId &#91;required&#93; The model ID.
#' @param modelType &#91;required&#93; The model type.
#' @param modelVersionNumber &#91;required&#93; The model version number.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_model_version
frauddetector_get_model_version <- function(modelId, modelType, modelVersionNumber) {
  op <- new_operation(
    name = "GetModelVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$get_model_version_input(modelId = modelId, modelType = modelType, modelVersionNumber = modelVersionNumber)
  output <- .frauddetector$get_model_version_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_model_version <- frauddetector_get_model_version

#' Gets one or more models
#'
#' @description
#' Gets one or more models. Gets all models for the Amazon Web Services account if no model type and no model id provided. Gets all models for the Amazon Web Services account and model type, if the model type is specified but model id is not provided. Gets a specific model if (model type, model id) tuple is specified.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_models/](https://www.paws-r-sdk.com/docs/frauddetector_get_models/) for full documentation.
#'
#' @param modelId The model ID.
#' @param modelType The model type.
#' @param nextToken The next token for the subsequent request.
#' @param maxResults The maximum number of objects to return for the request.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_models
frauddetector_get_models <- function(modelId = NULL, modelType = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetModels",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .frauddetector$get_models_input(modelId = modelId, modelType = modelType, nextToken = nextToken, maxResults = maxResults)
  output <- .frauddetector$get_models_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_models <- frauddetector_get_models

#' Gets one or more outcomes
#'
#' @description
#' Gets one or more outcomes. This is a paginated API. If you provide a null `maxResults`, this actions retrieves a maximum of 100 records per page. If you provide a `maxResults`, the value must be between 50 and 100. To get the next page results, provide the pagination token from the `GetOutcomesResult` as part of your request. A null pagination token fetches the records from the beginning.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_outcomes/](https://www.paws-r-sdk.com/docs/frauddetector_get_outcomes/) for full documentation.
#'
#' @param name The name of the outcome or outcomes to get.
#' @param nextToken The next page token for the request.
#' @param maxResults The maximum number of objects to return for the request.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_outcomes
frauddetector_get_outcomes <- function(name = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetOutcomes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .frauddetector$get_outcomes_input(name = name, nextToken = nextToken, maxResults = maxResults)
  output <- .frauddetector$get_outcomes_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_outcomes <- frauddetector_get_outcomes

#' Get all rules for a detector (paginated) if ruleId and ruleVersion are
#' not specified
#'
#' @description
#' Get all rules for a detector (paginated) if `ruleId` and `ruleVersion` are not specified. Gets all rules for the detector and the `ruleId` if present (paginated). Gets a specific rule if both the `ruleId` and the `ruleVersion` are specified.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_rules/](https://www.paws-r-sdk.com/docs/frauddetector_get_rules/) for full documentation.
#'
#' @param ruleId The rule ID.
#' @param detectorId &#91;required&#93; The detector ID.
#' @param ruleVersion The rule version.
#' @param nextToken The next page token.
#' @param maxResults The maximum number of rules to return for the request.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_rules
frauddetector_get_rules <- function(ruleId = NULL, detectorId, ruleVersion = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetRules",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .frauddetector$get_rules_input(ruleId = ruleId, detectorId = detectorId, ruleVersion = ruleVersion, nextToken = nextToken, maxResults = maxResults)
  output <- .frauddetector$get_rules_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_rules <- frauddetector_get_rules

#' Gets all of the variables or the specific variable
#'
#' @description
#' Gets all of the variables or the specific variable. This is a paginated API. Providing null `maxSizePerPage` results in retrieving maximum of 100 records per page. If you provide `maxSizePerPage` the value must be between 50 and 100. To get the next page result, a provide a pagination token from `GetVariablesResult` as part of your request. Null pagination token fetches the records from the beginning.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_get_variables/](https://www.paws-r-sdk.com/docs/frauddetector_get_variables/) for full documentation.
#'
#' @param name The name of the variable.
#' @param nextToken The next page token of the get variable request.
#' @param maxResults The max size per page determined for the get variable request.
#'
#' @keywords internal
#'
#' @rdname frauddetector_get_variables
frauddetector_get_variables <- function(name = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetVariables",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .frauddetector$get_variables_input(name = name, nextToken = nextToken, maxResults = maxResults)
  output <- .frauddetector$get_variables_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$get_variables <- frauddetector_get_variables

#' Gets a list of past predictions
#'
#' @description
#' Gets a list of past predictions. The list can be filtered by detector ID, detector version ID, event ID, event type, or by specifying a time period. If filter is not specified, the most recent prediction is returned.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_list_event_predictions/](https://www.paws-r-sdk.com/docs/frauddetector_list_event_predictions/) for full documentation.
#'
#' @param eventId The event ID.
#' @param eventType The event type associated with the detector.
#' @param detectorId The detector ID.
#' @param detectorVersionId The detector version ID.
#' @param predictionTimeRange The time period for when the predictions were generated.
#' @param nextToken Identifies the next page of results to return. Use the token to make the
#' call again to retrieve the next page. Keep all other arguments
#' unchanged. Each pagination token expires after 24 hours.
#' @param maxResults The maximum number of predictions to return for the request.
#'
#' @keywords internal
#'
#' @rdname frauddetector_list_event_predictions
frauddetector_list_event_predictions <- function(eventId = NULL, eventType = NULL, detectorId = NULL, detectorVersionId = NULL, predictionTimeRange = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListEventPredictions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .frauddetector$list_event_predictions_input(eventId = eventId, eventType = eventType, detectorId = detectorId, detectorVersionId = detectorVersionId, predictionTimeRange = predictionTimeRange, nextToken = nextToken, maxResults = maxResults)
  output <- .frauddetector$list_event_predictions_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$list_event_predictions <- frauddetector_list_event_predictions

#' Lists all tags associated with the resource
#'
#' @description
#' Lists all tags associated with the resource. This is a paginated API. To get the next page results, provide the pagination token from the response as part of your request. A null pagination token fetches the records from the beginning.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/frauddetector_list_tags_for_resource/) for full documentation.
#'
#' @param resourceARN &#91;required&#93; The ARN that specifies the resource whose tags you want to list.
#' @param nextToken The next token from the previous results.
#' @param maxResults The maximum number of objects to return for the request.
#'
#' @keywords internal
#'
#' @rdname frauddetector_list_tags_for_resource
frauddetector_list_tags_for_resource <- function(resourceARN, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .frauddetector$list_tags_for_resource_input(resourceARN = resourceARN, nextToken = nextToken, maxResults = maxResults)
  output <- .frauddetector$list_tags_for_resource_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$list_tags_for_resource <- frauddetector_list_tags_for_resource

#' Creates or updates a detector
#'
#' @description
#' Creates or updates a detector.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_put_detector/](https://www.paws-r-sdk.com/docs/frauddetector_put_detector/) for full documentation.
#'
#' @param detectorId &#91;required&#93; The detector ID.
#' @param description The description of the detector.
#' @param eventTypeName &#91;required&#93; The name of the event type.
#' @param tags A collection of key and value pairs.
#'
#' @keywords internal
#'
#' @rdname frauddetector_put_detector
frauddetector_put_detector <- function(detectorId, description = NULL, eventTypeName, tags = NULL) {
  op <- new_operation(
    name = "PutDetector",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$put_detector_input(detectorId = detectorId, description = description, eventTypeName = eventTypeName, tags = tags)
  output <- .frauddetector$put_detector_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$put_detector <- frauddetector_put_detector

#' Creates or updates an entity type
#'
#' @description
#' Creates or updates an entity type. An entity represents who is performing the event. As part of a fraud prediction, you pass the entity ID to indicate the specific entity who performed the event. An entity type classifies the entity. Example classifications include customer, merchant, or account.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_put_entity_type/](https://www.paws-r-sdk.com/docs/frauddetector_put_entity_type/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the entity type.
#' @param description The description.
#' @param tags A collection of key and value pairs.
#'
#' @keywords internal
#'
#' @rdname frauddetector_put_entity_type
frauddetector_put_entity_type <- function(name, description = NULL, tags = NULL) {
  op <- new_operation(
    name = "PutEntityType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$put_entity_type_input(name = name, description = description, tags = tags)
  output <- .frauddetector$put_entity_type_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$put_entity_type <- frauddetector_put_entity_type

#' Creates or updates an event type
#'
#' @description
#' Creates or updates an event type. An event is a business activity that is evaluated for fraud risk. With Amazon Fraud Detector, you generate fraud predictions for events. An event type defines the structure for an event sent to Amazon Fraud Detector. This includes the variables sent as part of the event, the entity performing the event (such as a customer), and the labels that classify the event. Example event types include online payment transactions, account registrations, and authentications.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_put_event_type/](https://www.paws-r-sdk.com/docs/frauddetector_put_event_type/) for full documentation.
#'
#' @param name &#91;required&#93; The name.
#' @param description The description of the event type.
#' @param eventVariables &#91;required&#93; The event type variables.
#' @param labels The event type labels.
#' @param entityTypes &#91;required&#93; The entity type for the event type. Example entity types: customer,
#' merchant, account.
#' @param eventIngestion Specifies if ingestion is enabled or disabled.
#' @param tags A collection of key and value pairs.
#' @param eventOrchestration Enables or disables event orchestration. If enabled, you can send event
#' predictions to select AWS services for downstream processing of the
#' events.
#'
#' @keywords internal
#'
#' @rdname frauddetector_put_event_type
frauddetector_put_event_type <- function(name, description = NULL, eventVariables, labels = NULL, entityTypes, eventIngestion = NULL, tags = NULL, eventOrchestration = NULL) {
  op <- new_operation(
    name = "PutEventType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$put_event_type_input(name = name, description = description, eventVariables = eventVariables, labels = labels, entityTypes = entityTypes, eventIngestion = eventIngestion, tags = tags, eventOrchestration = eventOrchestration)
  output <- .frauddetector$put_event_type_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$put_event_type <- frauddetector_put_event_type

#' Creates or updates an Amazon SageMaker model endpoint
#'
#' @description
#' Creates or updates an Amazon SageMaker model endpoint. You can also use this action to update the configuration of the model endpoint, including the IAM role and/or the mapped variables.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_put_external_model/](https://www.paws-r-sdk.com/docs/frauddetector_put_external_model/) for full documentation.
#'
#' @param modelEndpoint &#91;required&#93; The model endpoints name.
#' @param modelSource &#91;required&#93; The source of the model.
#' @param invokeModelEndpointRoleArn &#91;required&#93; The IAM role used to invoke the model endpoint.
#' @param inputConfiguration &#91;required&#93; The model endpoint input configuration.
#' @param outputConfiguration &#91;required&#93; The model endpoint output configuration.
#' @param modelEndpointStatus &#91;required&#93; The model endpoint’s status in Amazon Fraud Detector.
#' @param tags A collection of key and value pairs.
#'
#' @keywords internal
#'
#' @rdname frauddetector_put_external_model
frauddetector_put_external_model <- function(modelEndpoint, modelSource, invokeModelEndpointRoleArn, inputConfiguration, outputConfiguration, modelEndpointStatus, tags = NULL) {
  op <- new_operation(
    name = "PutExternalModel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$put_external_model_input(modelEndpoint = modelEndpoint, modelSource = modelSource, invokeModelEndpointRoleArn = invokeModelEndpointRoleArn, inputConfiguration = inputConfiguration, outputConfiguration = outputConfiguration, modelEndpointStatus = modelEndpointStatus, tags = tags)
  output <- .frauddetector$put_external_model_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$put_external_model <- frauddetector_put_external_model

#' Specifies the KMS key to be used to encrypt content in Amazon Fraud
#' Detector
#'
#' @description
#' Specifies the KMS key to be used to encrypt content in Amazon Fraud Detector.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_put_kms_encryption_key/](https://www.paws-r-sdk.com/docs/frauddetector_put_kms_encryption_key/) for full documentation.
#'
#' @param kmsEncryptionKeyArn &#91;required&#93; The KMS encryption key ARN.
#' 
#' The KMS key must be single-Region key. Amazon Fraud Detector does not
#' support multi-Region KMS key.
#'
#' @keywords internal
#'
#' @rdname frauddetector_put_kms_encryption_key
frauddetector_put_kms_encryption_key <- function(kmsEncryptionKeyArn) {
  op <- new_operation(
    name = "PutKMSEncryptionKey",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$put_kms_encryption_key_input(kmsEncryptionKeyArn = kmsEncryptionKeyArn)
  output <- .frauddetector$put_kms_encryption_key_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$put_kms_encryption_key <- frauddetector_put_kms_encryption_key

#' Creates or updates label
#'
#' @description
#' Creates or updates label. A label classifies an event as fraudulent or legitimate. Labels are associated with event types and used to train supervised machine learning models in Amazon Fraud Detector.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_put_label/](https://www.paws-r-sdk.com/docs/frauddetector_put_label/) for full documentation.
#'
#' @param name &#91;required&#93; The label name.
#' @param description The label description.
#' @param tags A collection of key and value pairs.
#'
#' @keywords internal
#'
#' @rdname frauddetector_put_label
frauddetector_put_label <- function(name, description = NULL, tags = NULL) {
  op <- new_operation(
    name = "PutLabel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$put_label_input(name = name, description = description, tags = tags)
  output <- .frauddetector$put_label_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$put_label <- frauddetector_put_label

#' Creates or updates an outcome
#'
#' @description
#' Creates or updates an outcome.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_put_outcome/](https://www.paws-r-sdk.com/docs/frauddetector_put_outcome/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the outcome.
#' @param description The outcome description.
#' @param tags A collection of key and value pairs.
#'
#' @keywords internal
#'
#' @rdname frauddetector_put_outcome
frauddetector_put_outcome <- function(name, description = NULL, tags = NULL) {
  op <- new_operation(
    name = "PutOutcome",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$put_outcome_input(name = name, description = description, tags = tags)
  output <- .frauddetector$put_outcome_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$put_outcome <- frauddetector_put_outcome

#' Stores events in Amazon Fraud Detector without generating fraud
#' predictions for those events
#'
#' @description
#' Stores events in Amazon Fraud Detector without generating fraud predictions for those events. For example, you can use [`send_event`][frauddetector_send_event] to upload a historical dataset, which you can then later use to train a model.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_send_event/](https://www.paws-r-sdk.com/docs/frauddetector_send_event/) for full documentation.
#'
#' @param eventId &#91;required&#93; The event ID to upload.
#' @param eventTypeName &#91;required&#93; The event type name of the event.
#' @param eventTimestamp &#91;required&#93; The timestamp that defines when the event under evaluation occurred. The
#' timestamp must be specified using ISO 8601 standard in UTC.
#' @param eventVariables &#91;required&#93; Names of the event type's variables you defined in Amazon Fraud Detector
#' to represent data elements and their corresponding values for the event
#' you are sending for evaluation.
#' @param assignedLabel The label to associate with the event. Required if specifying
#' `labelTimestamp`.
#' @param labelTimestamp The timestamp associated with the label. Required if specifying
#' `assignedLabel`.
#' @param entities &#91;required&#93; An array of entities.
#'
#' @keywords internal
#'
#' @rdname frauddetector_send_event
frauddetector_send_event <- function(eventId, eventTypeName, eventTimestamp, eventVariables, assignedLabel = NULL, labelTimestamp = NULL, entities) {
  op <- new_operation(
    name = "SendEvent",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$send_event_input(eventId = eventId, eventTypeName = eventTypeName, eventTimestamp = eventTimestamp, eventVariables = eventVariables, assignedLabel = assignedLabel, labelTimestamp = labelTimestamp, entities = entities)
  output <- .frauddetector$send_event_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$send_event <- frauddetector_send_event

#' Assigns tags to a resource
#'
#' @description
#' Assigns tags to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_tag_resource/](https://www.paws-r-sdk.com/docs/frauddetector_tag_resource/) for full documentation.
#'
#' @param resourceARN &#91;required&#93; The resource ARN.
#' @param tags &#91;required&#93; The tags to assign to the resource.
#'
#' @keywords internal
#'
#' @rdname frauddetector_tag_resource
frauddetector_tag_resource <- function(resourceARN, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$tag_resource_input(resourceARN = resourceARN, tags = tags)
  output <- .frauddetector$tag_resource_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$tag_resource <- frauddetector_tag_resource

#' Removes tags from a resource
#'
#' @description
#' Removes tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_untag_resource/](https://www.paws-r-sdk.com/docs/frauddetector_untag_resource/) for full documentation.
#'
#' @param resourceARN &#91;required&#93; The ARN of the resource from which to remove the tag.
#' @param tagKeys &#91;required&#93; The resource ARN.
#'
#' @keywords internal
#'
#' @rdname frauddetector_untag_resource
frauddetector_untag_resource <- function(resourceARN, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$untag_resource_input(resourceARN = resourceARN, tagKeys = tagKeys)
  output <- .frauddetector$untag_resource_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$untag_resource <- frauddetector_untag_resource

#' Updates a detector version
#'
#' @description
#' Updates a detector version. The detector version attributes that you can update include models, external model endpoints, rules, rule execution mode, and description. You can only update a `DRAFT` detector version.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_update_detector_version/](https://www.paws-r-sdk.com/docs/frauddetector_update_detector_version/) for full documentation.
#'
#' @param detectorId &#91;required&#93; The parent detector ID for the detector version you want to update.
#' @param detectorVersionId &#91;required&#93; The detector version ID.
#' @param externalModelEndpoints &#91;required&#93; The Amazon SageMaker model endpoints to include in the detector version.
#' @param rules &#91;required&#93; The rules to include in the detector version.
#' @param description The detector version description.
#' @param modelVersions The model versions to include in the detector version.
#' @param ruleExecutionMode The rule execution mode to add to the detector.
#' 
#' If you specify `FIRST_MATCHED`, Amazon Fraud Detector evaluates rules
#' sequentially, first to last, stopping at the first matched rule. Amazon
#' Fraud dectector then provides the outcomes for that single rule.
#' 
#' If you specifiy `ALL_MATCHED`, Amazon Fraud Detector evaluates all rules
#' and returns the outcomes for all matched rules. You can define and edit
#' the rule mode at the detector version level, when it is in draft status.
#' 
#' The default behavior is `FIRST_MATCHED`.
#'
#' @keywords internal
#'
#' @rdname frauddetector_update_detector_version
frauddetector_update_detector_version <- function(detectorId, detectorVersionId, externalModelEndpoints, rules, description = NULL, modelVersions = NULL, ruleExecutionMode = NULL) {
  op <- new_operation(
    name = "UpdateDetectorVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$update_detector_version_input(detectorId = detectorId, detectorVersionId = detectorVersionId, externalModelEndpoints = externalModelEndpoints, rules = rules, description = description, modelVersions = modelVersions, ruleExecutionMode = ruleExecutionMode)
  output <- .frauddetector$update_detector_version_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$update_detector_version <- frauddetector_update_detector_version

#' Updates the detector version's description
#'
#' @description
#' Updates the detector version's description. You can update the metadata for any detector version (`DRAFT, ACTIVE,` or `INACTIVE`).
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_update_detector_version_metadata/](https://www.paws-r-sdk.com/docs/frauddetector_update_detector_version_metadata/) for full documentation.
#'
#' @param detectorId &#91;required&#93; The detector ID.
#' @param detectorVersionId &#91;required&#93; The detector version ID.
#' @param description &#91;required&#93; The description.
#'
#' @keywords internal
#'
#' @rdname frauddetector_update_detector_version_metadata
frauddetector_update_detector_version_metadata <- function(detectorId, detectorVersionId, description) {
  op <- new_operation(
    name = "UpdateDetectorVersionMetadata",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$update_detector_version_metadata_input(detectorId = detectorId, detectorVersionId = detectorVersionId, description = description)
  output <- .frauddetector$update_detector_version_metadata_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$update_detector_version_metadata <- frauddetector_update_detector_version_metadata

#' Updates the detector version’s status
#'
#' @description
#' Updates the detector version’s status. You can perform the following promotions or demotions using [`update_detector_version_status`][frauddetector_update_detector_version_status]: `DRAFT` to `ACTIVE`, `ACTIVE` to `INACTIVE`, and `INACTIVE` to `ACTIVE`.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_update_detector_version_status/](https://www.paws-r-sdk.com/docs/frauddetector_update_detector_version_status/) for full documentation.
#'
#' @param detectorId &#91;required&#93; The detector ID.
#' @param detectorVersionId &#91;required&#93; The detector version ID.
#' @param status &#91;required&#93; The new status.
#' 
#' The only supported values are `ACTIVE` and `INACTIVE`
#'
#' @keywords internal
#'
#' @rdname frauddetector_update_detector_version_status
frauddetector_update_detector_version_status <- function(detectorId, detectorVersionId, status) {
  op <- new_operation(
    name = "UpdateDetectorVersionStatus",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$update_detector_version_status_input(detectorId = detectorId, detectorVersionId = detectorVersionId, status = status)
  output <- .frauddetector$update_detector_version_status_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$update_detector_version_status <- frauddetector_update_detector_version_status

#' Updates the specified event with a new label
#'
#' @description
#' Updates the specified event with a new label.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_update_event_label/](https://www.paws-r-sdk.com/docs/frauddetector_update_event_label/) for full documentation.
#'
#' @param eventId &#91;required&#93; The ID of the event associated with the label to update.
#' @param eventTypeName &#91;required&#93; The event type of the event associated with the label to update.
#' @param assignedLabel &#91;required&#93; The new label to assign to the event.
#' @param labelTimestamp &#91;required&#93; The timestamp associated with the label. The timestamp must be specified
#' using ISO 8601 standard in UTC.
#'
#' @keywords internal
#'
#' @rdname frauddetector_update_event_label
frauddetector_update_event_label <- function(eventId, eventTypeName, assignedLabel, labelTimestamp) {
  op <- new_operation(
    name = "UpdateEventLabel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$update_event_label_input(eventId = eventId, eventTypeName = eventTypeName, assignedLabel = assignedLabel, labelTimestamp = labelTimestamp)
  output <- .frauddetector$update_event_label_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$update_event_label <- frauddetector_update_event_label

#' Updates a list
#'
#' @description
#' Updates a list.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_update_list/](https://www.paws-r-sdk.com/docs/frauddetector_update_list/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the list to update.
#' @param elements One or more list elements to add or replace. If you are providing the
#' elements, make sure to specify the `updateMode` to use.
#' 
#' If you are deleting all elements from the list, use `REPLACE` for the
#' `updateMode` and provide an empty list (0 elements).
#' @param description The new description.
#' @param updateMode The update mode (type).
#' 
#' -   Use `APPEND` if you are adding elements to the list.
#' 
#' -   Use `REPLACE` if you replacing existing elements in the list.
#' 
#' -   Use `REMOVE` if you are removing elements from the list.
#' @param variableType The variable type you want to assign to the list.
#' 
#' You cannot update a variable type of a list that already has a variable
#' type assigned to it. You can assign a variable type to a list only if
#' the list does not already have a variable type.
#'
#' @keywords internal
#'
#' @rdname frauddetector_update_list
frauddetector_update_list <- function(name, elements = NULL, description = NULL, updateMode = NULL, variableType = NULL) {
  op <- new_operation(
    name = "UpdateList",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$update_list_input(name = name, elements = elements, description = description, updateMode = updateMode, variableType = variableType)
  output <- .frauddetector$update_list_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$update_list <- frauddetector_update_list

#' Updates model description
#'
#' @description
#' Updates model description.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_update_model/](https://www.paws-r-sdk.com/docs/frauddetector_update_model/) for full documentation.
#'
#' @param modelId &#91;required&#93; The model ID.
#' @param modelType &#91;required&#93; The model type.
#' @param description The new model description.
#'
#' @keywords internal
#'
#' @rdname frauddetector_update_model
frauddetector_update_model <- function(modelId, modelType, description = NULL) {
  op <- new_operation(
    name = "UpdateModel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$update_model_input(modelId = modelId, modelType = modelType, description = description)
  output <- .frauddetector$update_model_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$update_model <- frauddetector_update_model

#' Updates a model version
#'
#' @description
#' Updates a model version. Updating a model version retrains an existing model version using updated training data and produces a new minor version of the model. You can update the training data set location and data access role attributes using this action. This action creates and trains a new minor version of the model, for example version 1.01, 1.02, 1.03.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_update_model_version/](https://www.paws-r-sdk.com/docs/frauddetector_update_model_version/) for full documentation.
#'
#' @param modelId &#91;required&#93; The model ID.
#' @param modelType &#91;required&#93; The model type.
#' @param majorVersionNumber &#91;required&#93; The major version number.
#' @param externalEventsDetail The details of the external events data used for training the model
#' version. Required if `trainingDataSource` is `EXTERNAL_EVENTS`.
#' @param ingestedEventsDetail The details of the ingested event used for training the model version.
#' Required if your `trainingDataSource` is `INGESTED_EVENTS`.
#' @param tags A collection of key and value pairs.
#'
#' @keywords internal
#'
#' @rdname frauddetector_update_model_version
frauddetector_update_model_version <- function(modelId, modelType, majorVersionNumber, externalEventsDetail = NULL, ingestedEventsDetail = NULL, tags = NULL) {
  op <- new_operation(
    name = "UpdateModelVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$update_model_version_input(modelId = modelId, modelType = modelType, majorVersionNumber = majorVersionNumber, externalEventsDetail = externalEventsDetail, ingestedEventsDetail = ingestedEventsDetail, tags = tags)
  output <- .frauddetector$update_model_version_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$update_model_version <- frauddetector_update_model_version

#' Updates the status of a model version
#'
#' @description
#' Updates the status of a model version.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_update_model_version_status/](https://www.paws-r-sdk.com/docs/frauddetector_update_model_version_status/) for full documentation.
#'
#' @param modelId &#91;required&#93; The model ID of the model version to update.
#' @param modelType &#91;required&#93; The model type.
#' @param modelVersionNumber &#91;required&#93; The model version number.
#' @param status &#91;required&#93; The model version status.
#'
#' @keywords internal
#'
#' @rdname frauddetector_update_model_version_status
frauddetector_update_model_version_status <- function(modelId, modelType, modelVersionNumber, status) {
  op <- new_operation(
    name = "UpdateModelVersionStatus",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$update_model_version_status_input(modelId = modelId, modelType = modelType, modelVersionNumber = modelVersionNumber, status = status)
  output <- .frauddetector$update_model_version_status_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$update_model_version_status <- frauddetector_update_model_version_status

#' Updates a rule's metadata
#'
#' @description
#' Updates a rule's metadata. The description attribute can be updated.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_update_rule_metadata/](https://www.paws-r-sdk.com/docs/frauddetector_update_rule_metadata/) for full documentation.
#'
#' @param rule &#91;required&#93; The rule to update.
#' @param description &#91;required&#93; The rule description.
#'
#' @keywords internal
#'
#' @rdname frauddetector_update_rule_metadata
frauddetector_update_rule_metadata <- function(rule, description) {
  op <- new_operation(
    name = "UpdateRuleMetadata",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$update_rule_metadata_input(rule = rule, description = description)
  output <- .frauddetector$update_rule_metadata_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$update_rule_metadata <- frauddetector_update_rule_metadata

#' Updates a rule version resulting in a new rule version
#'
#' @description
#' Updates a rule version resulting in a new rule version. Updates a rule version resulting in a new rule version (version 1, 2, 3 ...).
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_update_rule_version/](https://www.paws-r-sdk.com/docs/frauddetector_update_rule_version/) for full documentation.
#'
#' @param rule &#91;required&#93; The rule to update.
#' @param description The description.
#' @param expression &#91;required&#93; The rule expression.
#' @param language &#91;required&#93; The language.
#' @param outcomes &#91;required&#93; The outcomes.
#' @param tags The tags to assign to the rule version.
#'
#' @keywords internal
#'
#' @rdname frauddetector_update_rule_version
frauddetector_update_rule_version <- function(rule, description = NULL, expression, language, outcomes, tags = NULL) {
  op <- new_operation(
    name = "UpdateRuleVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$update_rule_version_input(rule = rule, description = description, expression = expression, language = language, outcomes = outcomes, tags = tags)
  output <- .frauddetector$update_rule_version_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$update_rule_version <- frauddetector_update_rule_version

#' Updates a variable
#'
#' @description
#' Updates a variable.
#'
#' See [https://www.paws-r-sdk.com/docs/frauddetector_update_variable/](https://www.paws-r-sdk.com/docs/frauddetector_update_variable/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the variable.
#' @param defaultValue The new default value of the variable.
#' @param description The new description.
#' @param variableType The variable type. For more information see [Variable
#' types](https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types).
#'
#' @keywords internal
#'
#' @rdname frauddetector_update_variable
frauddetector_update_variable <- function(name, defaultValue = NULL, description = NULL, variableType = NULL) {
  op <- new_operation(
    name = "UpdateVariable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .frauddetector$update_variable_input(name = name, defaultValue = defaultValue, description = description, variableType = variableType)
  output <- .frauddetector$update_variable_output()
  config <- get_config()
  svc <- .frauddetector$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.frauddetector$operations$update_variable <- frauddetector_update_variable
