% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemakerruntime_operations.R
\name{sagemakerruntime_invoke_endpoint_with_response_stream}
\alias{sagemakerruntime_invoke_endpoint_with_response_stream}
\title{Invokes a model at the specified endpoint to return the inference
response as a stream}
\usage{
sagemakerruntime_invoke_endpoint_with_response_stream(
  EndpointName,
  Body,
  ContentType = NULL,
  Accept = NULL,
  CustomAttributes = NULL,
  TargetVariant = NULL,
  TargetContainerHostname = NULL,
  InferenceId = NULL,
  InferenceComponentName = NULL
)
}
\arguments{
\item{EndpointName}{[required] The name of the endpoint that you specified when you created the
endpoint using the
\href{https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html}{CreateEndpoint}
API.}

\item{Body}{[required] Provides input data, in the format specified in the \code{ContentType}
request header. Amazon SageMaker passes all of the data in the body to
the model.

For information about the format of the request body, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/cdf-inference.html}{Common Data Formats-Inference}.}

\item{ContentType}{The MIME type of the input data in the request body.}

\item{Accept}{The desired MIME type of the inference response from the model
container.}

\item{CustomAttributes}{Provides additional information about a request for an inference
submitted to a model hosted at an Amazon SageMaker endpoint. The
information is an opaque value that is forwarded verbatim. You could use
this value, for example, to provide an ID that you can use to track a
request or to provide other metadata that a service endpoint was
programmed to process. The value must consist of no more than 1024
visible US-ASCII characters as specified in \href{https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.6}{Section 3.3.6. Field Value Components}
of the Hypertext Transfer Protocol (HTTP/1.1).

The code in your model is responsible for setting or updating any custom
attributes in the response. If your code does not set this value in the
response, an empty value is returned. For example, if a custom attribute
represents the trace ID, your model can prepend the custom attribute
with \verb{Trace ID:} in your post-processing function.

This feature is currently supported in the Amazon Web Services SDKs but
not in the Amazon SageMaker Python SDK.}

\item{TargetVariant}{Specify the production variant to send the inference request to when
invoking an endpoint that is running two or more variants. Note that
this parameter overrides the default behavior for the endpoint, which is
to distribute the invocation traffic based on the variant weights.

For information about how to use variant targeting to perform a/b
testing, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/model-ab-testing.html}{Test models in production}}

\item{TargetContainerHostname}{If the endpoint hosts multiple containers and is configured to use
direct invocation, this parameter specifies the host name of the
container to invoke.}

\item{InferenceId}{An identifier that you assign to your request.}

\item{InferenceComponentName}{If the endpoint hosts one or more inference components, this parameter
specifies the name of inference component to invoke for a streaming
response.}
}
\description{
Invokes a model at the specified endpoint to return the inference response as a stream. The inference stream provides the response payload incrementally as a series of parts. Before you can get an inference stream, you must have access to a model that's deployed using Amazon SageMaker hosting services, and the container for that model must support inference streaming.

See \url{https://www.paws-r-sdk.com/docs/sagemakerruntime_invoke_endpoint_with_response_stream/} for full documentation.
}
\keyword{internal}
