% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_cluster}
\alias{sagemaker_create_cluster}
\title{Creates a SageMaker HyperPod cluster}
\usage{
sagemaker_create_cluster(
  ClusterName,
  InstanceGroups,
  VpcConfig = NULL,
  Tags = NULL
)
}
\arguments{
\item{ClusterName}{[required] The name for the new SageMaker HyperPod cluster.}

\item{InstanceGroups}{[required] The instance groups to be created in the SageMaker HyperPod cluster.}

\item{VpcConfig}{}

\item{Tags}{Custom tags for managing the SageMaker HyperPod cluster as an Amazon Web
Services resource. You can add tags to your cluster in the same way you
add them in other Amazon Web Services services that support tagging. To
learn more about tagging Amazon Web Services resources in general, see
\href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services Resources User Guide}.}
}
\description{
Creates a SageMaker HyperPod cluster. SageMaker HyperPod is a capability of SageMaker for creating and managing persistent clusters for developing large machine learning models, such as large language models (LLMs) and diffusion models. To learn more, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod.html}{Amazon SageMaker HyperPod} in the \emph{Amazon SageMaker Developer Guide}.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_cluster/} for full documentation.
}
\keyword{internal}
