% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_delete_bot}
\alias{lexmodelbuildingservice_delete_bot}
\title{Deletes all versions of the bot, including the $LATEST version}
\usage{
lexmodelbuildingservice_delete_bot(name)
}
\arguments{
\item{name}{[required] The name of the bot. The name is case sensitive.}
}
\description{
Deletes all versions of the bot, including the \verb{$LATEST} version. To
delete a specific version of the bot, use the DeleteBotVersion
operation. The \code{DeleteBot} operation doesn\'t immediately remove the bot
schema. Instead, it is marked for deletion and removed later.
}
\details{
Amazon Lex stores utterances indefinitely for improving the ability of
your bot to respond to user inputs. These utterances are not removed
when the bot is deleted. To remove the utterances, use the
DeleteUtterances operation.

If a bot has an alias, you can\'t delete it. Instead, the \code{DeleteBot}
operation returns a \code{ResourceInUseException} exception that includes a
reference to the alias that refers to the bot. To remove the reference
to the bot, delete the alias. If you get the same exception again,
delete the referring alias until the \code{DeleteBot} operation is
successful.

This operation requires permissions for the \code{lex:DeleteBot} action.
}
\section{Request syntax}{
\preformatted{svc$delete_bot(
  name = "string"
)
}
}

\keyword{internal}
