% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_workteams}
\alias{sagemaker_list_workteams}
\title{Gets a list of work teams that you have defined in a region}
\usage{
sagemaker_list_workteams(SortBy, SortOrder, NameContains, NextToken,
  MaxResults)
}
\arguments{
\item{SortBy}{The field to sort results by. The default is \code{CreationTime}.}

\item{SortOrder}{The sort order for results. The default is \code{Ascending}.}

\item{NameContains}{A string in the work team\'s name. This filter returns only work teams
whose name contains the specified string.}

\item{NextToken}{If the result of the previous \code{ListWorkteams} request was truncated, the
response includes a \code{NextToken}. To retrieve the next set of labeling
jobs, use the token in the next request.}

\item{MaxResults}{The maximum number of work teams to return in each page of the response.}
}
\description{
Gets a list of work teams that you have defined in a region. The list
may be empty if no work team satisfies the filter specified in the
\code{NameContains} parameter.
}
\section{Request syntax}{
\preformatted{svc$list_workteams(
  SortBy = "Name"|"CreateDate",
  SortOrder = "Ascending"|"Descending",
  NameContains = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
