% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_list_solutions}
\alias{personalize_list_solutions}
\title{Returns a list of solutions that use the given dataset group}
\usage{
personalize_list_solutions(datasetGroupArn, nextToken, maxResults)
}
\arguments{
\item{datasetGroupArn}{The Amazon Resource Name (ARN) of the dataset group.}

\item{nextToken}{A token returned from the previous call to \code{ListSolutions} for getting
the next set of solutions (if they exist).}

\item{maxResults}{The maximum number of solutions to return.}
}
\description{
Returns a list of solutions that use the given dataset group. When a
dataset group is not specified, all the solutions associated with the
account are listed. The response provides the properties for each
solution, including the Amazon Resource Name (ARN). For more information
on solutions, see CreateSolution.
}
\section{Request syntax}{
\preformatted{svc$list_solutions(
  datasetGroupArn = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
