% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_get_builtin_intents}
\alias{lexmodelbuildingservice_get_builtin_intents}
\title{Gets a list of built-in intents that meet the specified criteria}
\usage{
lexmodelbuildingservice_get_builtin_intents(locale, signatureContains,
  nextToken, maxResults)
}
\arguments{
\item{locale}{A list of locales that the intent supports.}

\item{signatureContains}{Substring to match in built-in intent signatures. An intent will be
returned if any part of its signature matches the substring. For
example, "xyz" matches both "xyzabc" and "abcxyz." To find the
signature for an intent, see \href{https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents}{Standard Built-in Intents}
in the \emph{Alexa Skills Kit}.}

\item{nextToken}{A pagination token that fetches the next page of intents. If this API
call is truncated, Amazon Lex returns a pagination token in the
response. To fetch the next page of intents, use the pagination token in
the next request.}

\item{maxResults}{The maximum number of intents to return in the response. The default is
10.}
}
\description{
Gets a list of built-in intents that meet the specified criteria.
}
\details{
This operation requires permission for the \code{lex:GetBuiltinIntents}
action.
}
\section{Request syntax}{
\preformatted{svc$get_builtin_intents(
  locale = "en-US"|"en-GB"|"de-DE",
  signatureContains = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
