% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_image}
\alias{sagemaker_create_image}
\title{Creates a custom SageMaker image}
\usage{
sagemaker_create_image(Description, DisplayName, ImageName, RoleArn,
  Tags)
}
\arguments{
\item{Description}{The description of the image.}

\item{DisplayName}{The display name of the image. If not provided, \code{ImageName} is
displayed.}

\item{ImageName}{[required] The name of the image. Must be unique to your account.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of an IAM role that enables Amazon
SageMaker to perform tasks on your behalf.}

\item{Tags}{A list of tags to apply to the image.}
}
\value{
A list with the following syntax:\preformatted{list(
  ImageArn = "string"
)
}
}
\description{
Creates a custom SageMaker image. A SageMaker image is a set of image
versions. Each image version represents a container image stored in
Amazon Container Registry (ECR). For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html}{Bring your own SageMaker image}.
}
\section{Request syntax}{
\preformatted{svc$create_image(
  Description = "string",
  DisplayName = "string",
  ImageName = "string",
  RoleArn = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
