% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_add_association}
\alias{sagemaker_add_association}
\title{Creates an association between the source and the destination}
\usage{
sagemaker_add_association(SourceArn, DestinationArn, AssociationType)
}
\arguments{
\item{SourceArn}{[required] The ARN of the source.}

\item{DestinationArn}{[required] The Amazon Resource Name (ARN) of the destination.}

\item{AssociationType}{The type of association. The following are suggested uses for each type.
Amazon SageMaker places no restrictions on their use.
\itemize{
\item ContributedTo - The source contributed to the destination or had a
part in enabling the destination. For example, the training data
contributed to the training job.
\item AssociatedWith - The source is connected to the destination. For
example, an approval workflow is associated with a model deployment.
\item DerivedFrom - The destination is a modification of the source. For
example, a digest output of a channel input for a processing job is
derived from the original inputs.
\item Produced - The source generated the destination. For example, a
training job produced a model artifact.
}}
}
\description{
Creates an \emph{association} between the source and the destination. A
source can be associated with multiple destinations, and a destination
can be associated with multiple sources. An association is a lineage
tracking entity. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html}{Amazon SageMaker ML Lineage Tracking}.
}
\section{Request syntax}{
\preformatted{svc$add_association(
  SourceArn = "string",
  DestinationArn = "string",
  AssociationType = "ContributedTo"|"AssociatedWith"|"DerivedFrom"|"Produced"
)
}
}

\keyword{internal}
