# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon WorkSpaces Web
#'
#' @description
#' WorkSpaces Web is a low cost, fully managed WorkSpace built specifically
#' to facilitate secure, web-based workloads. WorkSpaces Web makes it easy
#' for customers to safely provide their employees with access to internal
#' websites and SaaS web applications without the administrative burden of
#' appliances or specialized client software. WorkSpaces Web provides
#' simple policy tools tailored for user interactions, while offloading
#' common tasks like capacity management, scaling, and maintaining browser
#' images.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- workspacesweb(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- workspacesweb()
#' svc$associate_browser_settings(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=workspacesweb_associate_browser_settings]{associate_browser_settings} \tab Associates a browser settings resource with a web portal\cr
#'  \link[=workspacesweb_associate_ip_access_settings]{associate_ip_access_settings} \tab Associates an IP access settings resource with a web portal\cr
#'  \link[=workspacesweb_associate_network_settings]{associate_network_settings} \tab Associates a network settings resource with a web portal\cr
#'  \link[=workspacesweb_associate_trust_store]{associate_trust_store} \tab Associates a trust store with a web portal\cr
#'  \link[=workspacesweb_associate_user_access_logging_settings]{associate_user_access_logging_settings} \tab Associates a user access logging settings resource with a web portal\cr
#'  \link[=workspacesweb_associate_user_settings]{associate_user_settings} \tab Associates a user settings resource with a web portal\cr
#'  \link[=workspacesweb_create_browser_settings]{create_browser_settings} \tab Creates a browser settings resource that can be associated with a web portal\cr
#'  \link[=workspacesweb_create_identity_provider]{create_identity_provider} \tab Creates an identity provider resource that is then associated with a web portal\cr
#'  \link[=workspacesweb_create_ip_access_settings]{create_ip_access_settings} \tab Creates an IP access settings resource that can be associated with a web portal\cr
#'  \link[=workspacesweb_create_network_settings]{create_network_settings} \tab Creates a network settings resource that can be associated with a web portal\cr
#'  \link[=workspacesweb_create_portal]{create_portal} \tab Creates a web portal\cr
#'  \link[=workspacesweb_create_trust_store]{create_trust_store} \tab Creates a trust store that can be associated with a web portal\cr
#'  \link[=workspacesweb_create_user_access_logging_settings]{create_user_access_logging_settings} \tab Creates a user access logging settings resource that can be associated with a web portal\cr
#'  \link[=workspacesweb_create_user_settings]{create_user_settings} \tab Creates a user settings resource that can be associated with a web portal\cr
#'  \link[=workspacesweb_delete_browser_settings]{delete_browser_settings} \tab Deletes browser settings\cr
#'  \link[=workspacesweb_delete_identity_provider]{delete_identity_provider} \tab Deletes the identity provider\cr
#'  \link[=workspacesweb_delete_ip_access_settings]{delete_ip_access_settings} \tab Deletes IP access settings\cr
#'  \link[=workspacesweb_delete_network_settings]{delete_network_settings} \tab Deletes network settings\cr
#'  \link[=workspacesweb_delete_portal]{delete_portal} \tab Deletes a web portal\cr
#'  \link[=workspacesweb_delete_trust_store]{delete_trust_store} \tab Deletes the trust store\cr
#'  \link[=workspacesweb_delete_user_access_logging_settings]{delete_user_access_logging_settings} \tab Deletes user access logging settings\cr
#'  \link[=workspacesweb_delete_user_settings]{delete_user_settings} \tab Deletes user settings\cr
#'  \link[=workspacesweb_disassociate_browser_settings]{disassociate_browser_settings} \tab Disassociates browser settings from a web portal\cr
#'  \link[=workspacesweb_disassociate_ip_access_settings]{disassociate_ip_access_settings} \tab Disassociates IP access settings from a web portal\cr
#'  \link[=workspacesweb_disassociate_network_settings]{disassociate_network_settings} \tab Disassociates network settings from a web portal\cr
#'  \link[=workspacesweb_disassociate_trust_store]{disassociate_trust_store} \tab Disassociates a trust store from a web portal\cr
#'  \link[=workspacesweb_disassociate_user_access_logging_settings]{disassociate_user_access_logging_settings} \tab Disassociates user access logging settings from a web portal\cr
#'  \link[=workspacesweb_disassociate_user_settings]{disassociate_user_settings} \tab Disassociates user settings from a web portal\cr
#'  \link[=workspacesweb_get_browser_settings]{get_browser_settings} \tab Gets browser settings\cr
#'  \link[=workspacesweb_get_identity_provider]{get_identity_provider} \tab Gets the identity provider\cr
#'  \link[=workspacesweb_get_ip_access_settings]{get_ip_access_settings} \tab Gets the IP access settings\cr
#'  \link[=workspacesweb_get_network_settings]{get_network_settings} \tab Gets the network settings\cr
#'  \link[=workspacesweb_get_portal]{get_portal} \tab Gets the web portal\cr
#'  \link[=workspacesweb_get_portal_service_provider_metadata]{get_portal_service_provider_metadata} \tab Gets the service provider metadata\cr
#'  \link[=workspacesweb_get_trust_store]{get_trust_store} \tab Gets the trust store\cr
#'  \link[=workspacesweb_get_trust_store_certificate]{get_trust_store_certificate} \tab Gets the trust store certificate\cr
#'  \link[=workspacesweb_get_user_access_logging_settings]{get_user_access_logging_settings} \tab Gets user access logging settings\cr
#'  \link[=workspacesweb_get_user_settings]{get_user_settings} \tab Gets user settings\cr
#'  \link[=workspacesweb_list_browser_settings]{list_browser_settings} \tab Retrieves a list of browser settings\cr
#'  \link[=workspacesweb_list_identity_providers]{list_identity_providers} \tab Retrieves a list of identity providers for a specific web portal\cr
#'  \link[=workspacesweb_list_ip_access_settings]{list_ip_access_settings} \tab Retrieves a list of IP access settings\cr
#'  \link[=workspacesweb_list_network_settings]{list_network_settings} \tab Retrieves a list of network settings\cr
#'  \link[=workspacesweb_list_portals]{list_portals} \tab Retrieves a list or web portals\cr
#'  \link[=workspacesweb_list_tags_for_resource]{list_tags_for_resource} \tab Retrieves a list of tags for a resource\cr
#'  \link[=workspacesweb_list_trust_store_certificates]{list_trust_store_certificates} \tab Retrieves a list of trust store certificates\cr
#'  \link[=workspacesweb_list_trust_stores]{list_trust_stores} \tab Retrieves a list of trust stores\cr
#'  \link[=workspacesweb_list_user_access_logging_settings]{list_user_access_logging_settings} \tab Retrieves a list of user access logging settings\cr
#'  \link[=workspacesweb_list_user_settings]{list_user_settings} \tab Retrieves a list of user settings\cr
#'  \link[=workspacesweb_tag_resource]{tag_resource} \tab Adds or overwrites one or more tags for the specified resource\cr
#'  \link[=workspacesweb_untag_resource]{untag_resource} \tab Removes one or more tags from the specified resource\cr
#'  \link[=workspacesweb_update_browser_settings]{update_browser_settings} \tab Updates browser settings\cr
#'  \link[=workspacesweb_update_identity_provider]{update_identity_provider} \tab Updates the identity provider\cr
#'  \link[=workspacesweb_update_ip_access_settings]{update_ip_access_settings} \tab Updates IP access settings\cr
#'  \link[=workspacesweb_update_network_settings]{update_network_settings} \tab Updates network settings\cr
#'  \link[=workspacesweb_update_portal]{update_portal} \tab Updates a web portal\cr
#'  \link[=workspacesweb_update_trust_store]{update_trust_store} \tab Updates the trust store\cr
#'  \link[=workspacesweb_update_user_access_logging_settings]{update_user_access_logging_settings} \tab Updates the user access logging settings\cr
#'  \link[=workspacesweb_update_user_settings]{update_user_settings} \tab Updates the user settings
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname workspacesweb
#' @export
workspacesweb <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .workspacesweb$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.workspacesweb <- list()

.workspacesweb$operations <- list()

.workspacesweb$metadata <- list(
  service_name = "workspacesweb",
  endpoints = list("*" = list(endpoint = "workspaces-web.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "workspaces-web.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "workspaces-web.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "workspaces-web.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "workspaces-web.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "workspaces-web.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "WorkSpaces Web",
  api_version = "2020-07-08",
  signing_name = "workspaces-web",
  json_version = "1.1",
  target_prefix = ""
)

.workspacesweb$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.workspacesweb$metadata, handlers, config)
}
