# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include workmail_service.R
NULL

#' Adds a member (user or group) to the resource's set of delegates
#'
#' @description
#' Adds a member (user or group) to the resource's set of delegates.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_associate_delegate_to_resource/](https://www.paws-r-sdk.com/docs/workmail_associate_delegate_to_resource/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The organization under which the resource exists.
#' @param ResourceId &#91;required&#93; The resource for which members (users or groups) are associated.
#' @param EntityId &#91;required&#93; The member (user or group) to associate to the resource.
#'
#' @keywords internal
#'
#' @rdname workmail_associate_delegate_to_resource
workmail_associate_delegate_to_resource <- function(OrganizationId, ResourceId, EntityId) {
  op <- new_operation(
    name = "AssociateDelegateToResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$associate_delegate_to_resource_input(OrganizationId = OrganizationId, ResourceId = ResourceId, EntityId = EntityId)
  output <- .workmail$associate_delegate_to_resource_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$associate_delegate_to_resource <- workmail_associate_delegate_to_resource

#' Adds a member (user or group) to the group's set
#'
#' @description
#' Adds a member (user or group) to the group's set.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_associate_member_to_group/](https://www.paws-r-sdk.com/docs/workmail_associate_member_to_group/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The organization under which the group exists.
#' @param GroupId &#91;required&#93; The group to which the member (user or group) is associated.
#' @param MemberId &#91;required&#93; The member (user or group) to associate to the group.
#'
#' @keywords internal
#'
#' @rdname workmail_associate_member_to_group
workmail_associate_member_to_group <- function(OrganizationId, GroupId, MemberId) {
  op <- new_operation(
    name = "AssociateMemberToGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$associate_member_to_group_input(OrganizationId = OrganizationId, GroupId = GroupId, MemberId = MemberId)
  output <- .workmail$associate_member_to_group_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$associate_member_to_group <- workmail_associate_member_to_group

#' Assumes an impersonation role for the given WorkMail organization
#'
#' @description
#' Assumes an impersonation role for the given WorkMail organization. This method returns an authentication token you can use to make impersonated calls.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_assume_impersonation_role/](https://www.paws-r-sdk.com/docs/workmail_assume_impersonation_role/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization under which the impersonation role will be
#' assumed.
#' @param ImpersonationRoleId &#91;required&#93; The impersonation role ID to assume.
#'
#' @keywords internal
#'
#' @rdname workmail_assume_impersonation_role
workmail_assume_impersonation_role <- function(OrganizationId, ImpersonationRoleId) {
  op <- new_operation(
    name = "AssumeImpersonationRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$assume_impersonation_role_input(OrganizationId = OrganizationId, ImpersonationRoleId = ImpersonationRoleId)
  output <- .workmail$assume_impersonation_role_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$assume_impersonation_role <- workmail_assume_impersonation_role

#' Cancels a mailbox export job
#'
#' @description
#' Cancels a mailbox export job.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_cancel_mailbox_export_job/](https://www.paws-r-sdk.com/docs/workmail_cancel_mailbox_export_job/) for full documentation.
#'
#' @param ClientToken &#91;required&#93; The idempotency token for the client request.
#' @param JobId &#91;required&#93; The job ID.
#' @param OrganizationId &#91;required&#93; The organization ID.
#'
#' @keywords internal
#'
#' @rdname workmail_cancel_mailbox_export_job
workmail_cancel_mailbox_export_job <- function(ClientToken, JobId, OrganizationId) {
  op <- new_operation(
    name = "CancelMailboxExportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$cancel_mailbox_export_job_input(ClientToken = ClientToken, JobId = JobId, OrganizationId = OrganizationId)
  output <- .workmail$cancel_mailbox_export_job_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$cancel_mailbox_export_job <- workmail_cancel_mailbox_export_job

#' Adds an alias to the set of a given member (user or group) of WorkMail
#'
#' @description
#' Adds an alias to the set of a given member (user or group) of WorkMail.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_create_alias/](https://www.paws-r-sdk.com/docs/workmail_create_alias/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The organization under which the member (user or group) exists.
#' @param EntityId &#91;required&#93; The member (user or group) to which this alias is added.
#' @param Alias &#91;required&#93; The alias to add to the member set.
#'
#' @keywords internal
#'
#' @rdname workmail_create_alias
workmail_create_alias <- function(OrganizationId, EntityId, Alias) {
  op <- new_operation(
    name = "CreateAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$create_alias_input(OrganizationId = OrganizationId, EntityId = EntityId, Alias = Alias)
  output <- .workmail$create_alias_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$create_alias <- workmail_create_alias

#' Creates an AvailabilityConfiguration for the given WorkMail organization
#' and domain
#'
#' @description
#' Creates an `AvailabilityConfiguration` for the given WorkMail organization and domain.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_create_availability_configuration/](https://www.paws-r-sdk.com/docs/workmail_create_availability_configuration/) for full documentation.
#'
#' @param ClientToken An idempotent token that ensures that an API request is executed only
#' once.
#' @param OrganizationId &#91;required&#93; The WorkMail organization for which the `AvailabilityConfiguration` will
#' be created.
#' @param DomainName &#91;required&#93; The domain to which the provider applies.
#' @param EwsProvider Exchange Web Services (EWS) availability provider definition. The
#' request must contain exactly one provider definition, either
#' `EwsProvider` or `LambdaProvider`.
#' @param LambdaProvider Lambda availability provider definition. The request must contain
#' exactly one provider definition, either `EwsProvider` or
#' `LambdaProvider`.
#'
#' @keywords internal
#'
#' @rdname workmail_create_availability_configuration
workmail_create_availability_configuration <- function(ClientToken = NULL, OrganizationId, DomainName, EwsProvider = NULL, LambdaProvider = NULL) {
  op <- new_operation(
    name = "CreateAvailabilityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$create_availability_configuration_input(ClientToken = ClientToken, OrganizationId = OrganizationId, DomainName = DomainName, EwsProvider = EwsProvider, LambdaProvider = LambdaProvider)
  output <- .workmail$create_availability_configuration_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$create_availability_configuration <- workmail_create_availability_configuration

#' Creates a group that can be used in WorkMail by calling the
#' RegisterToWorkMail operation
#'
#' @description
#' Creates a group that can be used in WorkMail by calling the [`register_to_work_mail`][workmail_register_to_work_mail] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_create_group/](https://www.paws-r-sdk.com/docs/workmail_create_group/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The organization under which the group is to be created.
#' @param Name &#91;required&#93; The name of the group.
#'
#' @keywords internal
#'
#' @rdname workmail_create_group
workmail_create_group <- function(OrganizationId, Name) {
  op <- new_operation(
    name = "CreateGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$create_group_input(OrganizationId = OrganizationId, Name = Name)
  output <- .workmail$create_group_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$create_group <- workmail_create_group

#' Creates an impersonation role for the given WorkMail organization
#'
#' @description
#' Creates an impersonation role for the given WorkMail organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_create_impersonation_role/](https://www.paws-r-sdk.com/docs/workmail_create_impersonation_role/) for full documentation.
#'
#' @param ClientToken The idempotency token for the client request.
#' @param OrganizationId &#91;required&#93; The WorkMail organization to create the new impersonation role within.
#' @param Name &#91;required&#93; The name of the new impersonation role.
#' @param Type &#91;required&#93; The impersonation role's type. The available impersonation role types
#' are `READ_ONLY` or `FULL_ACCESS`.
#' @param Description The description of the new impersonation role.
#' @param Rules &#91;required&#93; The list of rules for the impersonation role.
#'
#' @keywords internal
#'
#' @rdname workmail_create_impersonation_role
workmail_create_impersonation_role <- function(ClientToken = NULL, OrganizationId, Name, Type, Description = NULL, Rules) {
  op <- new_operation(
    name = "CreateImpersonationRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$create_impersonation_role_input(ClientToken = ClientToken, OrganizationId = OrganizationId, Name = Name, Type = Type, Description = Description, Rules = Rules)
  output <- .workmail$create_impersonation_role_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$create_impersonation_role <- workmail_create_impersonation_role

#' Creates a new mobile device access rule for the specified WorkMail
#' organization
#'
#' @description
#' Creates a new mobile device access rule for the specified WorkMail organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_create_mobile_device_access_rule/](https://www.paws-r-sdk.com/docs/workmail_create_mobile_device_access_rule/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization under which the rule will be created.
#' @param ClientToken The idempotency token for the client request.
#' @param Name &#91;required&#93; The rule name.
#' @param Description The rule description.
#' @param Effect &#91;required&#93; The effect of the rule when it matches. Allowed values are `ALLOW` or
#' `DENY`.
#' @param DeviceTypes Device types that the rule will match.
#' @param NotDeviceTypes Device types that the rule **will not** match. All other device types
#' will match.
#' @param DeviceModels Device models that the rule will match.
#' @param NotDeviceModels Device models that the rule **will not** match. All other device models
#' will match.
#' @param DeviceOperatingSystems Device operating systems that the rule will match.
#' @param NotDeviceOperatingSystems Device operating systems that the rule **will not** match. All other
#' device operating systems will match.
#' @param DeviceUserAgents Device user agents that the rule will match.
#' @param NotDeviceUserAgents Device user agents that the rule **will not** match. All other device
#' user agents will match.
#'
#' @keywords internal
#'
#' @rdname workmail_create_mobile_device_access_rule
workmail_create_mobile_device_access_rule <- function(OrganizationId, ClientToken = NULL, Name, Description = NULL, Effect, DeviceTypes = NULL, NotDeviceTypes = NULL, DeviceModels = NULL, NotDeviceModels = NULL, DeviceOperatingSystems = NULL, NotDeviceOperatingSystems = NULL, DeviceUserAgents = NULL, NotDeviceUserAgents = NULL) {
  op <- new_operation(
    name = "CreateMobileDeviceAccessRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$create_mobile_device_access_rule_input(OrganizationId = OrganizationId, ClientToken = ClientToken, Name = Name, Description = Description, Effect = Effect, DeviceTypes = DeviceTypes, NotDeviceTypes = NotDeviceTypes, DeviceModels = DeviceModels, NotDeviceModels = NotDeviceModels, DeviceOperatingSystems = DeviceOperatingSystems, NotDeviceOperatingSystems = NotDeviceOperatingSystems, DeviceUserAgents = DeviceUserAgents, NotDeviceUserAgents = NotDeviceUserAgents)
  output <- .workmail$create_mobile_device_access_rule_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$create_mobile_device_access_rule <- workmail_create_mobile_device_access_rule

#' Creates a new WorkMail organization
#'
#' @description
#' Creates a new WorkMail organization. Optionally, you can choose to associate an existing AWS Directory Service directory with your organization. If an AWS Directory Service directory ID is specified, the organization alias must match the directory alias. If you choose not to associate an existing directory with your organization, then we create a new WorkMail directory for you. For more information, see [Adding an organization](https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html) in the *WorkMail Administrator Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_create_organization/](https://www.paws-r-sdk.com/docs/workmail_create_organization/) for full documentation.
#'
#' @param DirectoryId The AWS Directory Service directory ID.
#' @param Alias &#91;required&#93; The organization alias.
#' @param ClientToken The idempotency token associated with the request.
#' @param Domains The email domains to associate with the organization.
#' @param KmsKeyArn The Amazon Resource Name (ARN) of a customer managed key from AWS KMS.
#' @param EnableInteroperability When `true`, allows organization interoperability between WorkMail and
#' Microsoft Exchange. If `true`, you must include a AD Connector directory
#' ID in the request.
#'
#' @keywords internal
#'
#' @rdname workmail_create_organization
workmail_create_organization <- function(DirectoryId = NULL, Alias, ClientToken = NULL, Domains = NULL, KmsKeyArn = NULL, EnableInteroperability = NULL) {
  op <- new_operation(
    name = "CreateOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$create_organization_input(DirectoryId = DirectoryId, Alias = Alias, ClientToken = ClientToken, Domains = Domains, KmsKeyArn = KmsKeyArn, EnableInteroperability = EnableInteroperability)
  output <- .workmail$create_organization_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$create_organization <- workmail_create_organization

#' Creates a new WorkMail resource
#'
#' @description
#' Creates a new WorkMail resource.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_create_resource/](https://www.paws-r-sdk.com/docs/workmail_create_resource/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier associated with the organization for which the resource
#' is created.
#' @param Name &#91;required&#93; The name of the new resource.
#' @param Type &#91;required&#93; The type of the new resource. The available types are `equipment` and
#' `room`.
#'
#' @keywords internal
#'
#' @rdname workmail_create_resource
workmail_create_resource <- function(OrganizationId, Name, Type) {
  op <- new_operation(
    name = "CreateResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$create_resource_input(OrganizationId = OrganizationId, Name = Name, Type = Type)
  output <- .workmail$create_resource_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$create_resource <- workmail_create_resource

#' Creates a user who can be used in WorkMail by calling the
#' RegisterToWorkMail operation
#'
#' @description
#' Creates a user who can be used in WorkMail by calling the [`register_to_work_mail`][workmail_register_to_work_mail] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_create_user/](https://www.paws-r-sdk.com/docs/workmail_create_user/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier of the organization for which the user is created.
#' @param Name &#91;required&#93; The name for the new user. WorkMail directory user names have a maximum
#' length of 64. All others have a maximum length of 20.
#' @param DisplayName &#91;required&#93; The display name for the new user.
#' @param Password &#91;required&#93; The password for the new user.
#'
#' @keywords internal
#'
#' @rdname workmail_create_user
workmail_create_user <- function(OrganizationId, Name, DisplayName, Password) {
  op <- new_operation(
    name = "CreateUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$create_user_input(OrganizationId = OrganizationId, Name = Name, DisplayName = DisplayName, Password = Password)
  output <- .workmail$create_user_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$create_user <- workmail_create_user

#' Deletes an access control rule for the specified WorkMail organization
#'
#' @description
#' Deletes an access control rule for the specified WorkMail organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_delete_access_control_rule/](https://www.paws-r-sdk.com/docs/workmail_delete_access_control_rule/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization.
#' @param Name &#91;required&#93; The name of the access control rule.
#'
#' @keywords internal
#'
#' @rdname workmail_delete_access_control_rule
workmail_delete_access_control_rule <- function(OrganizationId, Name) {
  op <- new_operation(
    name = "DeleteAccessControlRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$delete_access_control_rule_input(OrganizationId = OrganizationId, Name = Name)
  output <- .workmail$delete_access_control_rule_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$delete_access_control_rule <- workmail_delete_access_control_rule

#' Remove one or more specified aliases from a set of aliases for a given
#' user
#'
#' @description
#' Remove one or more specified aliases from a set of aliases for a given user.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_delete_alias/](https://www.paws-r-sdk.com/docs/workmail_delete_alias/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization under which the user exists.
#' @param EntityId &#91;required&#93; The identifier for the member (user or group) from which to have the
#' aliases removed.
#' @param Alias &#91;required&#93; The aliases to be removed from the user's set of aliases. Duplicate
#' entries in the list are collapsed into single entries (the list is
#' transformed into a set).
#'
#' @keywords internal
#'
#' @rdname workmail_delete_alias
workmail_delete_alias <- function(OrganizationId, EntityId, Alias) {
  op <- new_operation(
    name = "DeleteAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$delete_alias_input(OrganizationId = OrganizationId, EntityId = EntityId, Alias = Alias)
  output <- .workmail$delete_alias_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$delete_alias <- workmail_delete_alias

#' Deletes the AvailabilityConfiguration for the given WorkMail
#' organization and domain
#'
#' @description
#' Deletes the `AvailabilityConfiguration` for the given WorkMail organization and domain.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_delete_availability_configuration/](https://www.paws-r-sdk.com/docs/workmail_delete_availability_configuration/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization for which the `AvailabilityConfiguration` will
#' be deleted.
#' @param DomainName &#91;required&#93; The domain for which the `AvailabilityConfiguration` will be deleted.
#'
#' @keywords internal
#'
#' @rdname workmail_delete_availability_configuration
workmail_delete_availability_configuration <- function(OrganizationId, DomainName) {
  op <- new_operation(
    name = "DeleteAvailabilityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$delete_availability_configuration_input(OrganizationId = OrganizationId, DomainName = DomainName)
  output <- .workmail$delete_availability_configuration_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$delete_availability_configuration <- workmail_delete_availability_configuration

#' Deletes the email monitoring configuration for a specified organization
#'
#' @description
#' Deletes the email monitoring configuration for a specified organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_delete_email_monitoring_configuration/](https://www.paws-r-sdk.com/docs/workmail_delete_email_monitoring_configuration/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The ID of the organization from which the email monitoring configuration
#' is deleted.
#'
#' @keywords internal
#'
#' @rdname workmail_delete_email_monitoring_configuration
workmail_delete_email_monitoring_configuration <- function(OrganizationId) {
  op <- new_operation(
    name = "DeleteEmailMonitoringConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$delete_email_monitoring_configuration_input(OrganizationId = OrganizationId)
  output <- .workmail$delete_email_monitoring_configuration_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$delete_email_monitoring_configuration <- workmail_delete_email_monitoring_configuration

#' Deletes a group from WorkMail
#'
#' @description
#' Deletes a group from WorkMail.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_delete_group/](https://www.paws-r-sdk.com/docs/workmail_delete_group/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The organization that contains the group.
#' @param GroupId &#91;required&#93; The identifier of the group to be deleted.
#'
#' @keywords internal
#'
#' @rdname workmail_delete_group
workmail_delete_group <- function(OrganizationId, GroupId) {
  op <- new_operation(
    name = "DeleteGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$delete_group_input(OrganizationId = OrganizationId, GroupId = GroupId)
  output <- .workmail$delete_group_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$delete_group <- workmail_delete_group

#' Deletes an impersonation role for the given WorkMail organization
#'
#' @description
#' Deletes an impersonation role for the given WorkMail organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_delete_impersonation_role/](https://www.paws-r-sdk.com/docs/workmail_delete_impersonation_role/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization from which to delete the impersonation role.
#' @param ImpersonationRoleId &#91;required&#93; The ID of the impersonation role to delete.
#'
#' @keywords internal
#'
#' @rdname workmail_delete_impersonation_role
workmail_delete_impersonation_role <- function(OrganizationId, ImpersonationRoleId) {
  op <- new_operation(
    name = "DeleteImpersonationRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$delete_impersonation_role_input(OrganizationId = OrganizationId, ImpersonationRoleId = ImpersonationRoleId)
  output <- .workmail$delete_impersonation_role_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$delete_impersonation_role <- workmail_delete_impersonation_role

#' Deletes permissions granted to a member (user or group)
#'
#' @description
#' Deletes permissions granted to a member (user or group).
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_delete_mailbox_permissions/](https://www.paws-r-sdk.com/docs/workmail_delete_mailbox_permissions/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier of the organization under which the member (user or
#' group) exists.
#' @param EntityId &#91;required&#93; The identifier of the member (user or group) that owns the mailbox.
#' @param GranteeId &#91;required&#93; The identifier of the member (user or group) for which to delete granted
#' permissions.
#'
#' @keywords internal
#'
#' @rdname workmail_delete_mailbox_permissions
workmail_delete_mailbox_permissions <- function(OrganizationId, EntityId, GranteeId) {
  op <- new_operation(
    name = "DeleteMailboxPermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$delete_mailbox_permissions_input(OrganizationId = OrganizationId, EntityId = EntityId, GranteeId = GranteeId)
  output <- .workmail$delete_mailbox_permissions_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$delete_mailbox_permissions <- workmail_delete_mailbox_permissions

#' Deletes the mobile device access override for the given WorkMail
#' organization, user, and device
#'
#' @description
#' Deletes the mobile device access override for the given WorkMail organization, user, and device.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_delete_mobile_device_access_override/](https://www.paws-r-sdk.com/docs/workmail_delete_mobile_device_access_override/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization for which the access override will be deleted.
#' @param UserId &#91;required&#93; The WorkMail user for which you want to delete the override. Accepts the
#' following types of user identities:
#' 
#' -   User ID: `12345678-1234-1234-1234-123456789012` or
#'     `S-1-1-12-1234567890-123456789-123456789-1234`
#' 
#' -   Email address: `user@@domain.tld`
#' 
#' -   User name: `user`
#' @param DeviceId &#91;required&#93; The mobile device for which you delete the override. `DeviceId` is case
#' insensitive.
#'
#' @keywords internal
#'
#' @rdname workmail_delete_mobile_device_access_override
workmail_delete_mobile_device_access_override <- function(OrganizationId, UserId, DeviceId) {
  op <- new_operation(
    name = "DeleteMobileDeviceAccessOverride",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$delete_mobile_device_access_override_input(OrganizationId = OrganizationId, UserId = UserId, DeviceId = DeviceId)
  output <- .workmail$delete_mobile_device_access_override_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$delete_mobile_device_access_override <- workmail_delete_mobile_device_access_override

#' Deletes a mobile device access rule for the specified WorkMail
#' organization
#'
#' @description
#' Deletes a mobile device access rule for the specified WorkMail organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_delete_mobile_device_access_rule/](https://www.paws-r-sdk.com/docs/workmail_delete_mobile_device_access_rule/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization under which the rule will be deleted.
#' @param MobileDeviceAccessRuleId &#91;required&#93; The identifier of the rule to be deleted.
#'
#' @keywords internal
#'
#' @rdname workmail_delete_mobile_device_access_rule
workmail_delete_mobile_device_access_rule <- function(OrganizationId, MobileDeviceAccessRuleId) {
  op <- new_operation(
    name = "DeleteMobileDeviceAccessRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$delete_mobile_device_access_rule_input(OrganizationId = OrganizationId, MobileDeviceAccessRuleId = MobileDeviceAccessRuleId)
  output <- .workmail$delete_mobile_device_access_rule_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$delete_mobile_device_access_rule <- workmail_delete_mobile_device_access_rule

#' Deletes an WorkMail organization and all underlying AWS resources
#' managed by WorkMail as part of the organization
#'
#' @description
#' Deletes an WorkMail organization and all underlying AWS resources managed by WorkMail as part of the organization. You can choose whether to delete the associated directory. For more information, see [Removing an organization](https://docs.aws.amazon.com/workmail/latest/adminguide/delete_organization.html) in the *WorkMail Administrator Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_delete_organization/](https://www.paws-r-sdk.com/docs/workmail_delete_organization/) for full documentation.
#'
#' @param ClientToken The idempotency token associated with the request.
#' @param OrganizationId &#91;required&#93; The organization ID.
#' @param DeleteDirectory &#91;required&#93; If true, deletes the AWS Directory Service directory associated with the
#' organization.
#'
#' @keywords internal
#'
#' @rdname workmail_delete_organization
workmail_delete_organization <- function(ClientToken = NULL, OrganizationId, DeleteDirectory) {
  op <- new_operation(
    name = "DeleteOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$delete_organization_input(ClientToken = ClientToken, OrganizationId = OrganizationId, DeleteDirectory = DeleteDirectory)
  output <- .workmail$delete_organization_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$delete_organization <- workmail_delete_organization

#' Deletes the specified resource
#'
#' @description
#' Deletes the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_delete_resource/](https://www.paws-r-sdk.com/docs/workmail_delete_resource/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier associated with the organization from which the resource
#' is deleted.
#' @param ResourceId &#91;required&#93; The identifier of the resource to be deleted.
#'
#' @keywords internal
#'
#' @rdname workmail_delete_resource
workmail_delete_resource <- function(OrganizationId, ResourceId) {
  op <- new_operation(
    name = "DeleteResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$delete_resource_input(OrganizationId = OrganizationId, ResourceId = ResourceId)
  output <- .workmail$delete_resource_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$delete_resource <- workmail_delete_resource

#' Deletes the specified retention policy from the specified organization
#'
#' @description
#' Deletes the specified retention policy from the specified organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_delete_retention_policy/](https://www.paws-r-sdk.com/docs/workmail_delete_retention_policy/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The organization ID.
#' @param Id &#91;required&#93; The retention policy ID.
#'
#' @keywords internal
#'
#' @rdname workmail_delete_retention_policy
workmail_delete_retention_policy <- function(OrganizationId, Id) {
  op <- new_operation(
    name = "DeleteRetentionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$delete_retention_policy_input(OrganizationId = OrganizationId, Id = Id)
  output <- .workmail$delete_retention_policy_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$delete_retention_policy <- workmail_delete_retention_policy

#' Deletes a user from WorkMail and all subsequent systems
#'
#' @description
#' Deletes a user from WorkMail and all subsequent systems. Before you can delete a user, the user state must be `DISABLED`. Use the [`describe_user`][workmail_describe_user] action to confirm the user state.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_delete_user/](https://www.paws-r-sdk.com/docs/workmail_delete_user/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The organization that contains the user to be deleted.
#' @param UserId &#91;required&#93; The identifier of the user to be deleted.
#'
#' @keywords internal
#'
#' @rdname workmail_delete_user
workmail_delete_user <- function(OrganizationId, UserId) {
  op <- new_operation(
    name = "DeleteUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$delete_user_input(OrganizationId = OrganizationId, UserId = UserId)
  output <- .workmail$delete_user_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$delete_user <- workmail_delete_user

#' Mark a user, group, or resource as no longer used in WorkMail
#'
#' @description
#' Mark a user, group, or resource as no longer used in WorkMail. This action disassociates the mailbox and schedules it for clean-up. WorkMail keeps mailboxes for 30 days before they are permanently removed. The functionality in the console is *Disable*.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_deregister_from_work_mail/](https://www.paws-r-sdk.com/docs/workmail_deregister_from_work_mail/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization under which the WorkMail entity
#' exists.
#' @param EntityId &#91;required&#93; The identifier for the member (user or group) to be updated.
#'
#' @keywords internal
#'
#' @rdname workmail_deregister_from_work_mail
workmail_deregister_from_work_mail <- function(OrganizationId, EntityId) {
  op <- new_operation(
    name = "DeregisterFromWorkMail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$deregister_from_work_mail_input(OrganizationId = OrganizationId, EntityId = EntityId)
  output <- .workmail$deregister_from_work_mail_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$deregister_from_work_mail <- workmail_deregister_from_work_mail

#' Removes a domain from WorkMail, stops email routing to WorkMail, and
#' removes the authorization allowing WorkMail use
#'
#' @description
#' Removes a domain from WorkMail, stops email routing to WorkMail, and removes the authorization allowing WorkMail use. SES keeps the domain because other applications may use it. You must first remove any email address used by WorkMail entities before you remove the domain.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_deregister_mail_domain/](https://www.paws-r-sdk.com/docs/workmail_deregister_mail_domain/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization for which the domain will be deregistered.
#' @param DomainName &#91;required&#93; The domain to deregister in WorkMail and SES.
#'
#' @keywords internal
#'
#' @rdname workmail_deregister_mail_domain
workmail_deregister_mail_domain <- function(OrganizationId, DomainName) {
  op <- new_operation(
    name = "DeregisterMailDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$deregister_mail_domain_input(OrganizationId = OrganizationId, DomainName = DomainName)
  output <- .workmail$deregister_mail_domain_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$deregister_mail_domain <- workmail_deregister_mail_domain

#' Describes the current email monitoring configuration for a specified
#' organization
#'
#' @description
#' Describes the current email monitoring configuration for a specified organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_describe_email_monitoring_configuration/](https://www.paws-r-sdk.com/docs/workmail_describe_email_monitoring_configuration/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The ID of the organization for which the email monitoring configuration
#' is described.
#'
#' @keywords internal
#'
#' @rdname workmail_describe_email_monitoring_configuration
workmail_describe_email_monitoring_configuration <- function(OrganizationId) {
  op <- new_operation(
    name = "DescribeEmailMonitoringConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$describe_email_monitoring_configuration_input(OrganizationId = OrganizationId)
  output <- .workmail$describe_email_monitoring_configuration_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$describe_email_monitoring_configuration <- workmail_describe_email_monitoring_configuration

#' Returns the data available for the group
#'
#' @description
#' Returns the data available for the group.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_describe_group/](https://www.paws-r-sdk.com/docs/workmail_describe_group/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization under which the group exists.
#' @param GroupId &#91;required&#93; The identifier for the group to be described.
#'
#' @keywords internal
#'
#' @rdname workmail_describe_group
workmail_describe_group <- function(OrganizationId, GroupId) {
  op <- new_operation(
    name = "DescribeGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$describe_group_input(OrganizationId = OrganizationId, GroupId = GroupId)
  output <- .workmail$describe_group_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$describe_group <- workmail_describe_group

#' Lists the settings in a DMARC policy for a specified organization
#'
#' @description
#' Lists the settings in a DMARC policy for a specified organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_describe_inbound_dmarc_settings/](https://www.paws-r-sdk.com/docs/workmail_describe_inbound_dmarc_settings/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; Lists the ID of the given organization.
#'
#' @keywords internal
#'
#' @rdname workmail_describe_inbound_dmarc_settings
workmail_describe_inbound_dmarc_settings <- function(OrganizationId) {
  op <- new_operation(
    name = "DescribeInboundDmarcSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$describe_inbound_dmarc_settings_input(OrganizationId = OrganizationId)
  output <- .workmail$describe_inbound_dmarc_settings_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$describe_inbound_dmarc_settings <- workmail_describe_inbound_dmarc_settings

#' Describes the current status of a mailbox export job
#'
#' @description
#' Describes the current status of a mailbox export job.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_describe_mailbox_export_job/](https://www.paws-r-sdk.com/docs/workmail_describe_mailbox_export_job/) for full documentation.
#'
#' @param JobId &#91;required&#93; The mailbox export job ID.
#' @param OrganizationId &#91;required&#93; The organization ID.
#'
#' @keywords internal
#'
#' @rdname workmail_describe_mailbox_export_job
workmail_describe_mailbox_export_job <- function(JobId, OrganizationId) {
  op <- new_operation(
    name = "DescribeMailboxExportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$describe_mailbox_export_job_input(JobId = JobId, OrganizationId = OrganizationId)
  output <- .workmail$describe_mailbox_export_job_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$describe_mailbox_export_job <- workmail_describe_mailbox_export_job

#' Provides more information regarding a given organization based on its
#' identifier
#'
#' @description
#' Provides more information regarding a given organization based on its identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_describe_organization/](https://www.paws-r-sdk.com/docs/workmail_describe_organization/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization to be described.
#'
#' @keywords internal
#'
#' @rdname workmail_describe_organization
workmail_describe_organization <- function(OrganizationId) {
  op <- new_operation(
    name = "DescribeOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$describe_organization_input(OrganizationId = OrganizationId)
  output <- .workmail$describe_organization_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$describe_organization <- workmail_describe_organization

#' Returns the data available for the resource
#'
#' @description
#' Returns the data available for the resource.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_describe_resource/](https://www.paws-r-sdk.com/docs/workmail_describe_resource/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier associated with the organization for which the resource
#' is described.
#' @param ResourceId &#91;required&#93; The identifier of the resource to be described.
#'
#' @keywords internal
#'
#' @rdname workmail_describe_resource
workmail_describe_resource <- function(OrganizationId, ResourceId) {
  op <- new_operation(
    name = "DescribeResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$describe_resource_input(OrganizationId = OrganizationId, ResourceId = ResourceId)
  output <- .workmail$describe_resource_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$describe_resource <- workmail_describe_resource

#' Provides information regarding the user
#'
#' @description
#' Provides information regarding the user.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_describe_user/](https://www.paws-r-sdk.com/docs/workmail_describe_user/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization under which the user exists.
#' @param UserId &#91;required&#93; The identifier for the user to be described.
#'
#' @keywords internal
#'
#' @rdname workmail_describe_user
workmail_describe_user <- function(OrganizationId, UserId) {
  op <- new_operation(
    name = "DescribeUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$describe_user_input(OrganizationId = OrganizationId, UserId = UserId)
  output <- .workmail$describe_user_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$describe_user <- workmail_describe_user

#' Removes a member from the resource's set of delegates
#'
#' @description
#' Removes a member from the resource's set of delegates.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_disassociate_delegate_from_resource/](https://www.paws-r-sdk.com/docs/workmail_disassociate_delegate_from_resource/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization under which the resource exists.
#' @param ResourceId &#91;required&#93; The identifier of the resource from which delegates' set members are
#' removed.
#' @param EntityId &#91;required&#93; The identifier for the member (user, group) to be removed from the
#' resource's delegates.
#'
#' @keywords internal
#'
#' @rdname workmail_disassociate_delegate_from_resource
workmail_disassociate_delegate_from_resource <- function(OrganizationId, ResourceId, EntityId) {
  op <- new_operation(
    name = "DisassociateDelegateFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$disassociate_delegate_from_resource_input(OrganizationId = OrganizationId, ResourceId = ResourceId, EntityId = EntityId)
  output <- .workmail$disassociate_delegate_from_resource_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$disassociate_delegate_from_resource <- workmail_disassociate_delegate_from_resource

#' Removes a member from a group
#'
#' @description
#' Removes a member from a group.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_disassociate_member_from_group/](https://www.paws-r-sdk.com/docs/workmail_disassociate_member_from_group/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization under which the group exists.
#' @param GroupId &#91;required&#93; The identifier for the group from which members are removed.
#' @param MemberId &#91;required&#93; The identifier for the member to be removed to the group.
#'
#' @keywords internal
#'
#' @rdname workmail_disassociate_member_from_group
workmail_disassociate_member_from_group <- function(OrganizationId, GroupId, MemberId) {
  op <- new_operation(
    name = "DisassociateMemberFromGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$disassociate_member_from_group_input(OrganizationId = OrganizationId, GroupId = GroupId, MemberId = MemberId)
  output <- .workmail$disassociate_member_from_group_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$disassociate_member_from_group <- workmail_disassociate_member_from_group

#' Gets the effects of an organization's access control rules as they apply
#' to a specified IPv4 address, access protocol action, and user ID or
#' impersonation role ID
#'
#' @description
#' Gets the effects of an organization's access control rules as they apply to a specified IPv4 address, access protocol action, and user ID or impersonation role ID. You must provide either the user ID or impersonation role ID. Impersonation role ID can only be used with Action EWS.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_get_access_control_effect/](https://www.paws-r-sdk.com/docs/workmail_get_access_control_effect/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization.
#' @param IpAddress &#91;required&#93; The IPv4 address.
#' @param Action &#91;required&#93; The access protocol action. Valid values include `ActiveSync`,
#' `AutoDiscover`, `EWS`, `IMAP`, `SMTP`, `WindowsOutlook`, and `WebMail`.
#' @param UserId The user ID.
#' @param ImpersonationRoleId The impersonation role ID.
#'
#' @keywords internal
#'
#' @rdname workmail_get_access_control_effect
workmail_get_access_control_effect <- function(OrganizationId, IpAddress, Action, UserId = NULL, ImpersonationRoleId = NULL) {
  op <- new_operation(
    name = "GetAccessControlEffect",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$get_access_control_effect_input(OrganizationId = OrganizationId, IpAddress = IpAddress, Action = Action, UserId = UserId, ImpersonationRoleId = ImpersonationRoleId)
  output <- .workmail$get_access_control_effect_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$get_access_control_effect <- workmail_get_access_control_effect

#' Gets the default retention policy details for the specified organization
#'
#' @description
#' Gets the default retention policy details for the specified organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_get_default_retention_policy/](https://www.paws-r-sdk.com/docs/workmail_get_default_retention_policy/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The organization ID.
#'
#' @keywords internal
#'
#' @rdname workmail_get_default_retention_policy
workmail_get_default_retention_policy <- function(OrganizationId) {
  op <- new_operation(
    name = "GetDefaultRetentionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$get_default_retention_policy_input(OrganizationId = OrganizationId)
  output <- .workmail$get_default_retention_policy_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$get_default_retention_policy <- workmail_get_default_retention_policy

#' Gets the impersonation role details for the given WorkMail organization
#'
#' @description
#' Gets the impersonation role details for the given WorkMail organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_get_impersonation_role/](https://www.paws-r-sdk.com/docs/workmail_get_impersonation_role/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization from which to retrieve the impersonation role.
#' @param ImpersonationRoleId &#91;required&#93; The impersonation role ID to retrieve.
#'
#' @keywords internal
#'
#' @rdname workmail_get_impersonation_role
workmail_get_impersonation_role <- function(OrganizationId, ImpersonationRoleId) {
  op <- new_operation(
    name = "GetImpersonationRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$get_impersonation_role_input(OrganizationId = OrganizationId, ImpersonationRoleId = ImpersonationRoleId)
  output <- .workmail$get_impersonation_role_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$get_impersonation_role <- workmail_get_impersonation_role

#' Tests whether the given impersonation role can impersonate a target user
#'
#' @description
#' Tests whether the given impersonation role can impersonate a target user.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_get_impersonation_role_effect/](https://www.paws-r-sdk.com/docs/workmail_get_impersonation_role_effect/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization where the impersonation role is defined.
#' @param ImpersonationRoleId &#91;required&#93; The impersonation role ID to test.
#' @param TargetUser &#91;required&#93; The WorkMail organization user chosen to test the impersonation role.
#' The following identity formats are available:
#' 
#' -   User ID: `12345678-1234-1234-1234-123456789012` or
#'     `S-1-1-12-1234567890-123456789-123456789-1234`
#' 
#' -   Email address: `user@@domain.tld`
#' 
#' -   User name: `user`
#'
#' @keywords internal
#'
#' @rdname workmail_get_impersonation_role_effect
workmail_get_impersonation_role_effect <- function(OrganizationId, ImpersonationRoleId, TargetUser) {
  op <- new_operation(
    name = "GetImpersonationRoleEffect",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$get_impersonation_role_effect_input(OrganizationId = OrganizationId, ImpersonationRoleId = ImpersonationRoleId, TargetUser = TargetUser)
  output <- .workmail$get_impersonation_role_effect_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$get_impersonation_role_effect <- workmail_get_impersonation_role_effect

#' Gets details for a mail domain, including domain records required to
#' configure your domain with recommended security
#'
#' @description
#' Gets details for a mail domain, including domain records required to configure your domain with recommended security.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_get_mail_domain/](https://www.paws-r-sdk.com/docs/workmail_get_mail_domain/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization for which the domain is retrieved.
#' @param DomainName &#91;required&#93; The domain from which you want to retrieve details.
#'
#' @keywords internal
#'
#' @rdname workmail_get_mail_domain
workmail_get_mail_domain <- function(OrganizationId, DomainName) {
  op <- new_operation(
    name = "GetMailDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$get_mail_domain_input(OrganizationId = OrganizationId, DomainName = DomainName)
  output <- .workmail$get_mail_domain_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$get_mail_domain <- workmail_get_mail_domain

#' Requests a user's mailbox details for a specified organization and user
#'
#' @description
#' Requests a user's mailbox details for a specified organization and user.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_get_mailbox_details/](https://www.paws-r-sdk.com/docs/workmail_get_mailbox_details/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization that contains the user whose mailbox
#' details are being requested.
#' @param UserId &#91;required&#93; The identifier for the user whose mailbox details are being requested.
#'
#' @keywords internal
#'
#' @rdname workmail_get_mailbox_details
workmail_get_mailbox_details <- function(OrganizationId, UserId) {
  op <- new_operation(
    name = "GetMailboxDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$get_mailbox_details_input(OrganizationId = OrganizationId, UserId = UserId)
  output <- .workmail$get_mailbox_details_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$get_mailbox_details <- workmail_get_mailbox_details

#' Simulates the effect of the mobile device access rules for the given
#' attributes of a sample access event
#'
#' @description
#' Simulates the effect of the mobile device access rules for the given attributes of a sample access event. Use this method to test the effects of the current set of mobile device access rules for the WorkMail organization for a particular user's attributes.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_get_mobile_device_access_effect/](https://www.paws-r-sdk.com/docs/workmail_get_mobile_device_access_effect/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization to simulate the access effect for.
#' @param DeviceType Device type the simulated user will report.
#' @param DeviceModel Device model the simulated user will report.
#' @param DeviceOperatingSystem Device operating system the simulated user will report.
#' @param DeviceUserAgent Device user agent the simulated user will report.
#'
#' @keywords internal
#'
#' @rdname workmail_get_mobile_device_access_effect
workmail_get_mobile_device_access_effect <- function(OrganizationId, DeviceType = NULL, DeviceModel = NULL, DeviceOperatingSystem = NULL, DeviceUserAgent = NULL) {
  op <- new_operation(
    name = "GetMobileDeviceAccessEffect",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$get_mobile_device_access_effect_input(OrganizationId = OrganizationId, DeviceType = DeviceType, DeviceModel = DeviceModel, DeviceOperatingSystem = DeviceOperatingSystem, DeviceUserAgent = DeviceUserAgent)
  output <- .workmail$get_mobile_device_access_effect_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$get_mobile_device_access_effect <- workmail_get_mobile_device_access_effect

#' Gets the mobile device access override for the given WorkMail
#' organization, user, and device
#'
#' @description
#' Gets the mobile device access override for the given WorkMail organization, user, and device.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_get_mobile_device_access_override/](https://www.paws-r-sdk.com/docs/workmail_get_mobile_device_access_override/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization to which you want to apply the override.
#' @param UserId &#91;required&#93; Identifies the WorkMail user for the override. Accepts the following
#' types of user identities:
#' 
#' -   User ID: `12345678-1234-1234-1234-123456789012` or
#'     `S-1-1-12-1234567890-123456789-123456789-1234`
#' 
#' -   Email address: `user@@domain.tld`
#' 
#' -   User name: `user`
#' @param DeviceId &#91;required&#93; The mobile device to which the override applies. `DeviceId` is case
#' insensitive.
#'
#' @keywords internal
#'
#' @rdname workmail_get_mobile_device_access_override
workmail_get_mobile_device_access_override <- function(OrganizationId, UserId, DeviceId) {
  op <- new_operation(
    name = "GetMobileDeviceAccessOverride",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$get_mobile_device_access_override_input(OrganizationId = OrganizationId, UserId = UserId, DeviceId = DeviceId)
  output <- .workmail$get_mobile_device_access_override_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$get_mobile_device_access_override <- workmail_get_mobile_device_access_override

#' Lists the access control rules for the specified organization
#'
#' @description
#' Lists the access control rules for the specified organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_list_access_control_rules/](https://www.paws-r-sdk.com/docs/workmail_list_access_control_rules/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization.
#'
#' @keywords internal
#'
#' @rdname workmail_list_access_control_rules
workmail_list_access_control_rules <- function(OrganizationId) {
  op <- new_operation(
    name = "ListAccessControlRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$list_access_control_rules_input(OrganizationId = OrganizationId)
  output <- .workmail$list_access_control_rules_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$list_access_control_rules <- workmail_list_access_control_rules

#' Creates a paginated call to list the aliases associated with a given
#' entity
#'
#' @description
#' Creates a paginated call to list the aliases associated with a given entity.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_list_aliases/](https://www.paws-r-sdk.com/docs/workmail_list_aliases/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization under which the entity exists.
#' @param EntityId &#91;required&#93; The identifier for the entity for which to list the aliases.
#' @param NextToken The token to use to retrieve the next page of results. The first call
#' does not contain any tokens.
#' @param MaxResults The maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname workmail_list_aliases
workmail_list_aliases <- function(OrganizationId, EntityId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAliases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$list_aliases_input(OrganizationId = OrganizationId, EntityId = EntityId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workmail$list_aliases_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$list_aliases <- workmail_list_aliases

#' List all the AvailabilityConfiguration's for the given WorkMail
#' organization
#'
#' @description
#' List all the `AvailabilityConfiguration`'s for the given WorkMail organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_list_availability_configurations/](https://www.paws-r-sdk.com/docs/workmail_list_availability_configurations/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization for which the `AvailabilityConfiguration`'s
#' will be listed.
#' @param MaxResults The maximum number of results to return in a single call.
#' @param NextToken The token to use to retrieve the next page of results. The first call
#' does not require a token.
#'
#' @keywords internal
#'
#' @rdname workmail_list_availability_configurations
workmail_list_availability_configurations <- function(OrganizationId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAvailabilityConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$list_availability_configurations_input(OrganizationId = OrganizationId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .workmail$list_availability_configurations_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$list_availability_configurations <- workmail_list_availability_configurations

#' Returns an overview of the members of a group
#'
#' @description
#' Returns an overview of the members of a group. Users and groups can be members of a group.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_list_group_members/](https://www.paws-r-sdk.com/docs/workmail_list_group_members/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization under which the group exists.
#' @param GroupId &#91;required&#93; The identifier for the group to which the members (users or groups) are
#' associated.
#' @param NextToken The token to use to retrieve the next page of results. The first call
#' does not contain any tokens.
#' @param MaxResults The maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname workmail_list_group_members
workmail_list_group_members <- function(OrganizationId, GroupId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListGroupMembers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$list_group_members_input(OrganizationId = OrganizationId, GroupId = GroupId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workmail$list_group_members_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$list_group_members <- workmail_list_group_members

#' Returns summaries of the organization's groups
#'
#' @description
#' Returns summaries of the organization's groups.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_list_groups/](https://www.paws-r-sdk.com/docs/workmail_list_groups/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization under which the groups exist.
#' @param NextToken The token to use to retrieve the next page of results. The first call
#' does not contain any tokens.
#' @param MaxResults The maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname workmail_list_groups
workmail_list_groups <- function(OrganizationId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$list_groups_input(OrganizationId = OrganizationId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workmail$list_groups_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$list_groups <- workmail_list_groups

#' Lists all the impersonation roles for the given WorkMail organization
#'
#' @description
#' Lists all the impersonation roles for the given WorkMail organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_list_impersonation_roles/](https://www.paws-r-sdk.com/docs/workmail_list_impersonation_roles/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization to which the listed impersonation roles
#' belong.
#' @param NextToken The token used to retrieve the next page of results. The first call
#' doesn't require a token.
#' @param MaxResults The maximum number of results returned in a single call.
#'
#' @keywords internal
#'
#' @rdname workmail_list_impersonation_roles
workmail_list_impersonation_roles <- function(OrganizationId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListImpersonationRoles",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$list_impersonation_roles_input(OrganizationId = OrganizationId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workmail$list_impersonation_roles_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$list_impersonation_roles <- workmail_list_impersonation_roles

#' Lists the mail domains in a given WorkMail organization
#'
#' @description
#' Lists the mail domains in a given WorkMail organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_list_mail_domains/](https://www.paws-r-sdk.com/docs/workmail_list_mail_domains/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization for which to list domains.
#' @param MaxResults The maximum number of results to return in a single call.
#' @param NextToken The token to use to retrieve the next page of results. The first call
#' does not require a token.
#'
#' @keywords internal
#'
#' @rdname workmail_list_mail_domains
workmail_list_mail_domains <- function(OrganizationId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListMailDomains",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$list_mail_domains_input(OrganizationId = OrganizationId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .workmail$list_mail_domains_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$list_mail_domains <- workmail_list_mail_domains

#' Lists the mailbox export jobs started for the specified organization
#' within the last seven days
#'
#' @description
#' Lists the mailbox export jobs started for the specified organization within the last seven days.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_list_mailbox_export_jobs/](https://www.paws-r-sdk.com/docs/workmail_list_mailbox_export_jobs/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The organization ID.
#' @param NextToken The token to use to retrieve the next page of results.
#' @param MaxResults The maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname workmail_list_mailbox_export_jobs
workmail_list_mailbox_export_jobs <- function(OrganizationId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListMailboxExportJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$list_mailbox_export_jobs_input(OrganizationId = OrganizationId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workmail$list_mailbox_export_jobs_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$list_mailbox_export_jobs <- workmail_list_mailbox_export_jobs

#' Lists the mailbox permissions associated with a user, group, or resource
#' mailbox
#'
#' @description
#' Lists the mailbox permissions associated with a user, group, or resource mailbox.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_list_mailbox_permissions/](https://www.paws-r-sdk.com/docs/workmail_list_mailbox_permissions/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier of the organization under which the user, group, or
#' resource exists.
#' @param EntityId &#91;required&#93; The identifier of the user, group, or resource for which to list mailbox
#' permissions.
#' @param NextToken The token to use to retrieve the next page of results. The first call
#' does not contain any tokens.
#' @param MaxResults The maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname workmail_list_mailbox_permissions
workmail_list_mailbox_permissions <- function(OrganizationId, EntityId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListMailboxPermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$list_mailbox_permissions_input(OrganizationId = OrganizationId, EntityId = EntityId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workmail$list_mailbox_permissions_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$list_mailbox_permissions <- workmail_list_mailbox_permissions

#' Lists all the mobile device access overrides for any given combination
#' of WorkMail organization, user, or device
#'
#' @description
#' Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_list_mobile_device_access_overrides/](https://www.paws-r-sdk.com/docs/workmail_list_mobile_device_access_overrides/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization under which to list mobile device access
#' overrides.
#' @param UserId The WorkMail user under which you list the mobile device access
#' overrides. Accepts the following types of user identities:
#' 
#' -   User ID: `12345678-1234-1234-1234-123456789012` or
#'     `S-1-1-12-1234567890-123456789-123456789-1234`
#' 
#' -   Email address: `user@@domain.tld`
#' 
#' -   User name: `user`
#' @param DeviceId The mobile device to which the access override applies.
#' @param NextToken The token to use to retrieve the next page of results. The first call
#' does not require a token.
#' @param MaxResults The maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname workmail_list_mobile_device_access_overrides
workmail_list_mobile_device_access_overrides <- function(OrganizationId, UserId = NULL, DeviceId = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListMobileDeviceAccessOverrides",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$list_mobile_device_access_overrides_input(OrganizationId = OrganizationId, UserId = UserId, DeviceId = DeviceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workmail$list_mobile_device_access_overrides_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$list_mobile_device_access_overrides <- workmail_list_mobile_device_access_overrides

#' Lists the mobile device access rules for the specified WorkMail
#' organization
#'
#' @description
#' Lists the mobile device access rules for the specified WorkMail organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_list_mobile_device_access_rules/](https://www.paws-r-sdk.com/docs/workmail_list_mobile_device_access_rules/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization for which to list the rules.
#'
#' @keywords internal
#'
#' @rdname workmail_list_mobile_device_access_rules
workmail_list_mobile_device_access_rules <- function(OrganizationId) {
  op <- new_operation(
    name = "ListMobileDeviceAccessRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$list_mobile_device_access_rules_input(OrganizationId = OrganizationId)
  output <- .workmail$list_mobile_device_access_rules_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$list_mobile_device_access_rules <- workmail_list_mobile_device_access_rules

#' Returns summaries of the customer's organizations
#'
#' @description
#' Returns summaries of the customer's organizations.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_list_organizations/](https://www.paws-r-sdk.com/docs/workmail_list_organizations/) for full documentation.
#'
#' @param NextToken The token to use to retrieve the next page of results. The first call
#' does not contain any tokens.
#' @param MaxResults The maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname workmail_list_organizations
workmail_list_organizations <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListOrganizations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$list_organizations_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .workmail$list_organizations_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$list_organizations <- workmail_list_organizations

#' Lists the delegates associated with a resource
#'
#' @description
#' Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on behalf of the resource.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_list_resource_delegates/](https://www.paws-r-sdk.com/docs/workmail_list_resource_delegates/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization that contains the resource for which
#' delegates are listed.
#' @param ResourceId &#91;required&#93; The identifier for the resource whose delegates are listed.
#' @param NextToken The token used to paginate through the delegates associated with a
#' resource.
#' @param MaxResults The number of maximum results in a page.
#'
#' @keywords internal
#'
#' @rdname workmail_list_resource_delegates
workmail_list_resource_delegates <- function(OrganizationId, ResourceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListResourceDelegates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$list_resource_delegates_input(OrganizationId = OrganizationId, ResourceId = ResourceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workmail$list_resource_delegates_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$list_resource_delegates <- workmail_list_resource_delegates

#' Returns summaries of the organization's resources
#'
#' @description
#' Returns summaries of the organization's resources.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_list_resources/](https://www.paws-r-sdk.com/docs/workmail_list_resources/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization under which the resources exist.
#' @param NextToken The token to use to retrieve the next page of results. The first call
#' does not contain any tokens.
#' @param MaxResults The maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname workmail_list_resources
workmail_list_resources <- function(OrganizationId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$list_resources_input(OrganizationId = OrganizationId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workmail$list_resources_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$list_resources <- workmail_list_resources

#' Lists the tags applied to an WorkMail organization resource
#'
#' @description
#' Lists the tags applied to an WorkMail organization resource.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/workmail_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The resource ARN.
#'
#' @keywords internal
#'
#' @rdname workmail_list_tags_for_resource
workmail_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .workmail$list_tags_for_resource_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$list_tags_for_resource <- workmail_list_tags_for_resource

#' Returns summaries of the organization's users
#'
#' @description
#' Returns summaries of the organization's users.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_list_users/](https://www.paws-r-sdk.com/docs/workmail_list_users/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization under which the users exist.
#' @param NextToken The token to use to retrieve the next page of results. The first call
#' does not contain any tokens.
#' @param MaxResults The maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname workmail_list_users
workmail_list_users <- function(OrganizationId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListUsers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$list_users_input(OrganizationId = OrganizationId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workmail$list_users_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$list_users <- workmail_list_users

#' Adds a new access control rule for the specified organization
#'
#' @description
#' Adds a new access control rule for the specified organization. The rule allows or denies access to the organization for the specified IPv4 addresses, access protocol actions, user IDs and impersonation IDs. Adding a new rule with the same name as an existing rule replaces the older rule.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_put_access_control_rule/](https://www.paws-r-sdk.com/docs/workmail_put_access_control_rule/) for full documentation.
#'
#' @param Name &#91;required&#93; The rule name.
#' @param Effect &#91;required&#93; The rule effect.
#' @param Description &#91;required&#93; The rule description.
#' @param IpRanges IPv4 CIDR ranges to include in the rule.
#' @param NotIpRanges IPv4 CIDR ranges to exclude from the rule.
#' @param Actions Access protocol actions to include in the rule. Valid values include
#' `ActiveSync`, `AutoDiscover`, `EWS`, `IMAP`, `SMTP`, `WindowsOutlook`,
#' and `WebMail`.
#' @param NotActions Access protocol actions to exclude from the rule. Valid values include
#' `ActiveSync`, `AutoDiscover`, `EWS`, `IMAP`, `SMTP`, `WindowsOutlook`,
#' and `WebMail`.
#' @param UserIds User IDs to include in the rule.
#' @param NotUserIds User IDs to exclude from the rule.
#' @param OrganizationId &#91;required&#93; The identifier of the organization.
#' @param ImpersonationRoleIds Impersonation role IDs to include in the rule.
#' @param NotImpersonationRoleIds Impersonation role IDs to exclude from the rule.
#'
#' @keywords internal
#'
#' @rdname workmail_put_access_control_rule
workmail_put_access_control_rule <- function(Name, Effect, Description, IpRanges = NULL, NotIpRanges = NULL, Actions = NULL, NotActions = NULL, UserIds = NULL, NotUserIds = NULL, OrganizationId, ImpersonationRoleIds = NULL, NotImpersonationRoleIds = NULL) {
  op <- new_operation(
    name = "PutAccessControlRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$put_access_control_rule_input(Name = Name, Effect = Effect, Description = Description, IpRanges = IpRanges, NotIpRanges = NotIpRanges, Actions = Actions, NotActions = NotActions, UserIds = UserIds, NotUserIds = NotUserIds, OrganizationId = OrganizationId, ImpersonationRoleIds = ImpersonationRoleIds, NotImpersonationRoleIds = NotImpersonationRoleIds)
  output <- .workmail$put_access_control_rule_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$put_access_control_rule <- workmail_put_access_control_rule

#' Creates or updates the email monitoring configuration for a specified
#' organization
#'
#' @description
#' Creates or updates the email monitoring configuration for a specified organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_put_email_monitoring_configuration/](https://www.paws-r-sdk.com/docs/workmail_put_email_monitoring_configuration/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The ID of the organization for which the email monitoring configuration
#' is set.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM Role associated with the email
#' monitoring configuration.
#' @param LogGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the CloudWatch Log group associated
#' with the email monitoring configuration.
#'
#' @keywords internal
#'
#' @rdname workmail_put_email_monitoring_configuration
workmail_put_email_monitoring_configuration <- function(OrganizationId, RoleArn, LogGroupArn) {
  op <- new_operation(
    name = "PutEmailMonitoringConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$put_email_monitoring_configuration_input(OrganizationId = OrganizationId, RoleArn = RoleArn, LogGroupArn = LogGroupArn)
  output <- .workmail$put_email_monitoring_configuration_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$put_email_monitoring_configuration <- workmail_put_email_monitoring_configuration

#' Enables or disables a DMARC policy for a given organization
#'
#' @description
#' Enables or disables a DMARC policy for a given organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_put_inbound_dmarc_settings/](https://www.paws-r-sdk.com/docs/workmail_put_inbound_dmarc_settings/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The ID of the organization that you are applying the DMARC policy to.
#' @param Enforced &#91;required&#93; Enforces or suspends a policy after it's applied.
#'
#' @keywords internal
#'
#' @rdname workmail_put_inbound_dmarc_settings
workmail_put_inbound_dmarc_settings <- function(OrganizationId, Enforced) {
  op <- new_operation(
    name = "PutInboundDmarcSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$put_inbound_dmarc_settings_input(OrganizationId = OrganizationId, Enforced = Enforced)
  output <- .workmail$put_inbound_dmarc_settings_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$put_inbound_dmarc_settings <- workmail_put_inbound_dmarc_settings

#' Sets permissions for a user, group, or resource
#'
#' @description
#' Sets permissions for a user, group, or resource. This replaces any pre-existing permissions.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_put_mailbox_permissions/](https://www.paws-r-sdk.com/docs/workmail_put_mailbox_permissions/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier of the organization under which the user, group, or
#' resource exists.
#' @param EntityId &#91;required&#93; The identifier of the user, group, or resource for which to update
#' mailbox permissions.
#' @param GranteeId &#91;required&#93; The identifier of the user, group, or resource to which to grant the
#' permissions.
#' @param PermissionValues &#91;required&#93; The permissions granted to the grantee. SEND_AS allows the grantee to
#' send email as the owner of the mailbox (the grantee is not mentioned on
#' these emails). SEND_ON_BEHALF allows the grantee to send email on behalf
#' of the owner of the mailbox (the grantee is not mentioned as the
#' physical sender of these emails). FULL_ACCESS allows the grantee full
#' access to the mailbox, irrespective of other folder-level permissions
#' set on the mailbox.
#'
#' @keywords internal
#'
#' @rdname workmail_put_mailbox_permissions
workmail_put_mailbox_permissions <- function(OrganizationId, EntityId, GranteeId, PermissionValues) {
  op <- new_operation(
    name = "PutMailboxPermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$put_mailbox_permissions_input(OrganizationId = OrganizationId, EntityId = EntityId, GranteeId = GranteeId, PermissionValues = PermissionValues)
  output <- .workmail$put_mailbox_permissions_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$put_mailbox_permissions <- workmail_put_mailbox_permissions

#' Creates or updates a mobile device access override for the given
#' WorkMail organization, user, and device
#'
#' @description
#' Creates or updates a mobile device access override for the given WorkMail organization, user, and device.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_put_mobile_device_access_override/](https://www.paws-r-sdk.com/docs/workmail_put_mobile_device_access_override/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; Identifies the WorkMail organization for which you create the override.
#' @param UserId &#91;required&#93; The WorkMail user for which you create the override. Accepts the
#' following types of user identities:
#' 
#' -   User ID: `12345678-1234-1234-1234-123456789012` or
#'     `S-1-1-12-1234567890-123456789-123456789-1234`
#' 
#' -   Email address: `user@@domain.tld`
#' 
#' -   User name: `user`
#' @param DeviceId &#91;required&#93; The mobile device for which you create the override. `DeviceId` is case
#' insensitive.
#' @param Effect &#91;required&#93; The effect of the override, `ALLOW` or `DENY`.
#' @param Description A description of the override.
#'
#' @keywords internal
#'
#' @rdname workmail_put_mobile_device_access_override
workmail_put_mobile_device_access_override <- function(OrganizationId, UserId, DeviceId, Effect, Description = NULL) {
  op <- new_operation(
    name = "PutMobileDeviceAccessOverride",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$put_mobile_device_access_override_input(OrganizationId = OrganizationId, UserId = UserId, DeviceId = DeviceId, Effect = Effect, Description = Description)
  output <- .workmail$put_mobile_device_access_override_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$put_mobile_device_access_override <- workmail_put_mobile_device_access_override

#' Puts a retention policy to the specified organization
#'
#' @description
#' Puts a retention policy to the specified organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_put_retention_policy/](https://www.paws-r-sdk.com/docs/workmail_put_retention_policy/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The organization ID.
#' @param Id The retention policy ID.
#' @param Name &#91;required&#93; The retention policy name.
#' @param Description The retention policy description.
#' @param FolderConfigurations &#91;required&#93; The retention policy folder configurations.
#'
#' @keywords internal
#'
#' @rdname workmail_put_retention_policy
workmail_put_retention_policy <- function(OrganizationId, Id = NULL, Name, Description = NULL, FolderConfigurations) {
  op <- new_operation(
    name = "PutRetentionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$put_retention_policy_input(OrganizationId = OrganizationId, Id = Id, Name = Name, Description = Description, FolderConfigurations = FolderConfigurations)
  output <- .workmail$put_retention_policy_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$put_retention_policy <- workmail_put_retention_policy

#' Registers a new domain in WorkMail and SES, and configures it for use by
#' WorkMail
#'
#' @description
#' Registers a new domain in WorkMail and SES, and configures it for use by WorkMail. Emails received by SES for this domain are routed to the specified WorkMail organization, and WorkMail has permanent permission to use the specified domain for sending your users' emails.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_register_mail_domain/](https://www.paws-r-sdk.com/docs/workmail_register_mail_domain/) for full documentation.
#'
#' @param ClientToken Idempotency token used when retrying requests.
#' @param OrganizationId &#91;required&#93; The WorkMail organization under which you're creating the domain.
#' @param DomainName &#91;required&#93; The name of the mail domain to create in WorkMail and SES.
#'
#' @keywords internal
#'
#' @rdname workmail_register_mail_domain
workmail_register_mail_domain <- function(ClientToken = NULL, OrganizationId, DomainName) {
  op <- new_operation(
    name = "RegisterMailDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$register_mail_domain_input(ClientToken = ClientToken, OrganizationId = OrganizationId, DomainName = DomainName)
  output <- .workmail$register_mail_domain_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$register_mail_domain <- workmail_register_mail_domain

#' Registers an existing and disabled user, group, or resource for WorkMail
#' use by associating a mailbox and calendaring capabilities
#'
#' @description
#' Registers an existing and disabled user, group, or resource for WorkMail use by associating a mailbox and calendaring capabilities. It performs no change if the user, group, or resource is enabled and fails if the user, group, or resource is deleted. This operation results in the accumulation of costs. For more information, see [Pricing](https://aws.amazon.com/workmail/pricing/). The equivalent console functionality for this operation is *Enable*.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_register_to_work_mail/](https://www.paws-r-sdk.com/docs/workmail_register_to_work_mail/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization under which the user, group, or
#' resource exists.
#' @param EntityId &#91;required&#93; The identifier for the user, group, or resource to be updated.
#' @param Email &#91;required&#93; The email for the user, group, or resource to be updated.
#'
#' @keywords internal
#'
#' @rdname workmail_register_to_work_mail
workmail_register_to_work_mail <- function(OrganizationId, EntityId, Email) {
  op <- new_operation(
    name = "RegisterToWorkMail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$register_to_work_mail_input(OrganizationId = OrganizationId, EntityId = EntityId, Email = Email)
  output <- .workmail$register_to_work_mail_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$register_to_work_mail <- workmail_register_to_work_mail

#' Allows the administrator to reset the password for a user
#'
#' @description
#' Allows the administrator to reset the password for a user.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_reset_password/](https://www.paws-r-sdk.com/docs/workmail_reset_password/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier of the organization that contains the user for which the
#' password is reset.
#' @param UserId &#91;required&#93; The identifier of the user for whom the password is reset.
#' @param Password &#91;required&#93; The new password for the user.
#'
#' @keywords internal
#'
#' @rdname workmail_reset_password
workmail_reset_password <- function(OrganizationId, UserId, Password) {
  op <- new_operation(
    name = "ResetPassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$reset_password_input(OrganizationId = OrganizationId, UserId = UserId, Password = Password)
  output <- .workmail$reset_password_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$reset_password <- workmail_reset_password

#' Starts a mailbox export job to export MIME-format email messages and
#' calendar items from the specified mailbox to the specified Amazon Simple
#' Storage Service (Amazon S3) bucket
#'
#' @description
#' Starts a mailbox export job to export MIME-format email messages and calendar items from the specified mailbox to the specified Amazon Simple Storage Service (Amazon S3) bucket. For more information, see [Exporting mailbox content](https://docs.aws.amazon.com/workmail/latest/adminguide/mail-export.html) in the *WorkMail Administrator Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_start_mailbox_export_job/](https://www.paws-r-sdk.com/docs/workmail_start_mailbox_export_job/) for full documentation.
#'
#' @param ClientToken &#91;required&#93; The idempotency token for the client request.
#' @param OrganizationId &#91;required&#93; The identifier associated with the organization.
#' @param EntityId &#91;required&#93; The identifier of the user or resource associated with the mailbox.
#' @param Description The mailbox export job description.
#' @param RoleArn &#91;required&#93; The ARN of the AWS Identity and Access Management (IAM) role that grants
#' write permission to the S3 bucket.
#' @param KmsKeyArn &#91;required&#93; The Amazon Resource Name (ARN) of the symmetric AWS Key Management
#' Service (AWS KMS) key that encrypts the exported mailbox content.
#' @param S3BucketName &#91;required&#93; The name of the S3 bucket.
#' @param S3Prefix &#91;required&#93; The S3 bucket prefix.
#'
#' @keywords internal
#'
#' @rdname workmail_start_mailbox_export_job
workmail_start_mailbox_export_job <- function(ClientToken, OrganizationId, EntityId, Description = NULL, RoleArn, KmsKeyArn, S3BucketName, S3Prefix) {
  op <- new_operation(
    name = "StartMailboxExportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$start_mailbox_export_job_input(ClientToken = ClientToken, OrganizationId = OrganizationId, EntityId = EntityId, Description = Description, RoleArn = RoleArn, KmsKeyArn = KmsKeyArn, S3BucketName = S3BucketName, S3Prefix = S3Prefix)
  output <- .workmail$start_mailbox_export_job_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$start_mailbox_export_job <- workmail_start_mailbox_export_job

#' Applies the specified tags to the specified WorkMailorganization
#' resource
#'
#' @description
#' Applies the specified tags to the specified WorkMailorganization resource.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_tag_resource/](https://www.paws-r-sdk.com/docs/workmail_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The resource ARN.
#' @param Tags &#91;required&#93; The tag key-value pairs.
#'
#' @keywords internal
#'
#' @rdname workmail_tag_resource
workmail_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .workmail$tag_resource_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$tag_resource <- workmail_tag_resource

#' Performs a test on an availability provider to ensure that access is
#' allowed
#'
#' @description
#' Performs a test on an availability provider to ensure that access is allowed. For EWS, it verifies the provided credentials can be used to successfully log in. For Lambda, it verifies that the Lambda function can be invoked and that the resource access policy was configured to deny anonymous access. An anonymous invocation is one done without providing either a `SourceArn` or `SourceAccount` header.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_test_availability_configuration/](https://www.paws-r-sdk.com/docs/workmail_test_availability_configuration/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization where the availability provider will be
#' tested.
#' @param DomainName The domain to which the provider applies. If this field is provided, a
#' stored availability provider associated to this domain name will be
#' tested.
#' @param EwsProvider 
#' @param LambdaProvider 
#'
#' @keywords internal
#'
#' @rdname workmail_test_availability_configuration
workmail_test_availability_configuration <- function(OrganizationId, DomainName = NULL, EwsProvider = NULL, LambdaProvider = NULL) {
  op <- new_operation(
    name = "TestAvailabilityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$test_availability_configuration_input(OrganizationId = OrganizationId, DomainName = DomainName, EwsProvider = EwsProvider, LambdaProvider = LambdaProvider)
  output <- .workmail$test_availability_configuration_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$test_availability_configuration <- workmail_test_availability_configuration

#' Untags the specified tags from the specified WorkMail organization
#' resource
#'
#' @description
#' Untags the specified tags from the specified WorkMail organization resource.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_untag_resource/](https://www.paws-r-sdk.com/docs/workmail_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The resource ARN.
#' @param TagKeys &#91;required&#93; The tag keys.
#'
#' @keywords internal
#'
#' @rdname workmail_untag_resource
workmail_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .workmail$untag_resource_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$untag_resource <- workmail_untag_resource

#' Updates an existing AvailabilityConfiguration for the given WorkMail
#' organization and domain
#'
#' @description
#' Updates an existing `AvailabilityConfiguration` for the given WorkMail organization and domain.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_update_availability_configuration/](https://www.paws-r-sdk.com/docs/workmail_update_availability_configuration/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization for which the `AvailabilityConfiguration` will
#' be updated.
#' @param DomainName &#91;required&#93; The domain to which the provider applies the availability configuration.
#' @param EwsProvider The EWS availability provider definition. The request must contain
#' exactly one provider definition, either `EwsProvider` or
#' `LambdaProvider`. The previously stored provider will be overridden by
#' the one provided.
#' @param LambdaProvider The Lambda availability provider definition. The request must contain
#' exactly one provider definition, either `EwsProvider` or
#' `LambdaProvider`. The previously stored provider will be overridden by
#' the one provided.
#'
#' @keywords internal
#'
#' @rdname workmail_update_availability_configuration
workmail_update_availability_configuration <- function(OrganizationId, DomainName, EwsProvider = NULL, LambdaProvider = NULL) {
  op <- new_operation(
    name = "UpdateAvailabilityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$update_availability_configuration_input(OrganizationId = OrganizationId, DomainName = DomainName, EwsProvider = EwsProvider, LambdaProvider = LambdaProvider)
  output <- .workmail$update_availability_configuration_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$update_availability_configuration <- workmail_update_availability_configuration

#' Updates the default mail domain for an organization
#'
#' @description
#' Updates the default mail domain for an organization. The default mail domain is used by the WorkMail AWS Console to suggest an email address when enabling a mail user. You can only have one default domain.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_update_default_mail_domain/](https://www.paws-r-sdk.com/docs/workmail_update_default_mail_domain/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization for which to list domains.
#' @param DomainName &#91;required&#93; The domain name that will become the default domain.
#'
#' @keywords internal
#'
#' @rdname workmail_update_default_mail_domain
workmail_update_default_mail_domain <- function(OrganizationId, DomainName) {
  op <- new_operation(
    name = "UpdateDefaultMailDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$update_default_mail_domain_input(OrganizationId = OrganizationId, DomainName = DomainName)
  output <- .workmail$update_default_mail_domain_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$update_default_mail_domain <- workmail_update_default_mail_domain

#' Updates an impersonation role for the given WorkMail organization
#'
#' @description
#' Updates an impersonation role for the given WorkMail organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_update_impersonation_role/](https://www.paws-r-sdk.com/docs/workmail_update_impersonation_role/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization that contains the impersonation role to
#' update.
#' @param ImpersonationRoleId &#91;required&#93; The ID of the impersonation role to update.
#' @param Name &#91;required&#93; The updated impersonation role name.
#' @param Type &#91;required&#93; The updated impersonation role type.
#' @param Description The updated impersonation role description.
#' @param Rules &#91;required&#93; The updated list of rules.
#'
#' @keywords internal
#'
#' @rdname workmail_update_impersonation_role
workmail_update_impersonation_role <- function(OrganizationId, ImpersonationRoleId, Name, Type, Description = NULL, Rules) {
  op <- new_operation(
    name = "UpdateImpersonationRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$update_impersonation_role_input(OrganizationId = OrganizationId, ImpersonationRoleId = ImpersonationRoleId, Name = Name, Type = Type, Description = Description, Rules = Rules)
  output <- .workmail$update_impersonation_role_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$update_impersonation_role <- workmail_update_impersonation_role

#' Updates a user's current mailbox quota for a specified organization and
#' user
#'
#' @description
#' Updates a user's current mailbox quota for a specified organization and user.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_update_mailbox_quota/](https://www.paws-r-sdk.com/docs/workmail_update_mailbox_quota/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier for the organization that contains the user for whom to
#' update the mailbox quota.
#' @param UserId &#91;required&#93; The identifer for the user for whom to update the mailbox quota.
#' @param MailboxQuota &#91;required&#93; The updated mailbox quota, in MB, for the specified user.
#'
#' @keywords internal
#'
#' @rdname workmail_update_mailbox_quota
workmail_update_mailbox_quota <- function(OrganizationId, UserId, MailboxQuota) {
  op <- new_operation(
    name = "UpdateMailboxQuota",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$update_mailbox_quota_input(OrganizationId = OrganizationId, UserId = UserId, MailboxQuota = MailboxQuota)
  output <- .workmail$update_mailbox_quota_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$update_mailbox_quota <- workmail_update_mailbox_quota

#' Updates a mobile device access rule for the specified WorkMail
#' organization
#'
#' @description
#' Updates a mobile device access rule for the specified WorkMail organization.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_update_mobile_device_access_rule/](https://www.paws-r-sdk.com/docs/workmail_update_mobile_device_access_rule/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The WorkMail organization under which the rule will be updated.
#' @param MobileDeviceAccessRuleId &#91;required&#93; The identifier of the rule to be updated.
#' @param Name &#91;required&#93; The updated rule name.
#' @param Description The updated rule description.
#' @param Effect &#91;required&#93; The effect of the rule when it matches. Allowed values are `ALLOW` or
#' `DENY`.
#' @param DeviceTypes Device types that the updated rule will match.
#' @param NotDeviceTypes Device types that the updated rule **will not** match. All other device
#' types will match.
#' @param DeviceModels Device models that the updated rule will match.
#' @param NotDeviceModels Device models that the updated rule **will not** match. All other device
#' models will match.
#' @param DeviceOperatingSystems Device operating systems that the updated rule will match.
#' @param NotDeviceOperatingSystems Device operating systems that the updated rule **will not** match. All
#' other device operating systems will match.
#' @param DeviceUserAgents User agents that the updated rule will match.
#' @param NotDeviceUserAgents User agents that the updated rule **will not** match. All other user
#' agents will match.
#'
#' @keywords internal
#'
#' @rdname workmail_update_mobile_device_access_rule
workmail_update_mobile_device_access_rule <- function(OrganizationId, MobileDeviceAccessRuleId, Name, Description = NULL, Effect, DeviceTypes = NULL, NotDeviceTypes = NULL, DeviceModels = NULL, NotDeviceModels = NULL, DeviceOperatingSystems = NULL, NotDeviceOperatingSystems = NULL, DeviceUserAgents = NULL, NotDeviceUserAgents = NULL) {
  op <- new_operation(
    name = "UpdateMobileDeviceAccessRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$update_mobile_device_access_rule_input(OrganizationId = OrganizationId, MobileDeviceAccessRuleId = MobileDeviceAccessRuleId, Name = Name, Description = Description, Effect = Effect, DeviceTypes = DeviceTypes, NotDeviceTypes = NotDeviceTypes, DeviceModels = DeviceModels, NotDeviceModels = NotDeviceModels, DeviceOperatingSystems = DeviceOperatingSystems, NotDeviceOperatingSystems = NotDeviceOperatingSystems, DeviceUserAgents = DeviceUserAgents, NotDeviceUserAgents = NotDeviceUserAgents)
  output <- .workmail$update_mobile_device_access_rule_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$update_mobile_device_access_rule <- workmail_update_mobile_device_access_rule

#' Updates the primary email for a user, group, or resource
#'
#' @description
#' Updates the primary email for a user, group, or resource. The current email is moved into the list of aliases (or swapped between an existing alias and the current primary email), and the email provided in the input is promoted as the primary.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_update_primary_email_address/](https://www.paws-r-sdk.com/docs/workmail_update_primary_email_address/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The organization that contains the user, group, or resource to update.
#' @param EntityId &#91;required&#93; The user, group, or resource to update.
#' @param Email &#91;required&#93; The value of the email to be updated as primary.
#'
#' @keywords internal
#'
#' @rdname workmail_update_primary_email_address
workmail_update_primary_email_address <- function(OrganizationId, EntityId, Email) {
  op <- new_operation(
    name = "UpdatePrimaryEmailAddress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$update_primary_email_address_input(OrganizationId = OrganizationId, EntityId = EntityId, Email = Email)
  output <- .workmail$update_primary_email_address_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$update_primary_email_address <- workmail_update_primary_email_address

#' Updates data for the resource
#'
#' @description
#' Updates data for the resource. To have the latest information, it must be preceded by a [`describe_resource`][workmail_describe_resource] call. The dataset in the request should be the one expected when performing another [`describe_resource`][workmail_describe_resource] call.
#'
#' See [https://www.paws-r-sdk.com/docs/workmail_update_resource/](https://www.paws-r-sdk.com/docs/workmail_update_resource/) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The identifier associated with the organization for which the resource
#' is updated.
#' @param ResourceId &#91;required&#93; The identifier of the resource to be updated.
#' @param Name The name of the resource to be updated.
#' @param BookingOptions The resource's booking options to be updated.
#'
#' @keywords internal
#'
#' @rdname workmail_update_resource
workmail_update_resource <- function(OrganizationId, ResourceId, Name = NULL, BookingOptions = NULL) {
  op <- new_operation(
    name = "UpdateResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workmail$update_resource_input(OrganizationId = OrganizationId, ResourceId = ResourceId, Name = Name, BookingOptions = BookingOptions)
  output <- .workmail$update_resource_output()
  config <- get_config()
  svc <- .workmail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workmail$operations$update_resource <- workmail_update_resource
