% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nimblestudio_operations.R
\name{nimblestudio_create_studio_component}
\alias{nimblestudio_create_studio_component}
\title{Creates a studio component resource}
\usage{
nimblestudio_create_studio_component(
  clientToken = NULL,
  configuration = NULL,
  description = NULL,
  ec2SecurityGroupIds = NULL,
  initializationScripts = NULL,
  name,
  runtimeRoleArn = NULL,
  scriptParameters = NULL,
  secureInitializationRoleArn = NULL,
  studioId,
  subtype = NULL,
  tags = NULL,
  type
)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If you don’t specify a client token, the AWS
SDK automatically generates a client token and uses it for the request
to ensure idempotency.}

\item{configuration}{The configuration of the studio component, based on component type.}

\item{description}{The description.}

\item{ec2SecurityGroupIds}{The EC2 security groups that control access to the studio component.}

\item{initializationScripts}{Initialization scripts for studio components.}

\item{name}{[required] The name for the studio component.}

\item{runtimeRoleArn}{An IAM role attached to a Studio Component that gives the studio
component access to AWS resources at anytime while the instance is
running.}

\item{scriptParameters}{Parameters for the studio component scripts.}

\item{secureInitializationRoleArn}{An IAM role attached to Studio Component when the system initialization
script runs which give the studio component access to AWS resources when
the system initialization script runs.}

\item{studioId}{[required] The studio ID.}

\item{subtype}{The specific subtype of a studio component.}

\item{tags}{A collection of labels, in the form of key:value pairs, that apply to
this resource.}

\item{type}{[required] The type of the studio component.}
}
\description{
Creates a studio component resource.

See \url{https://paws-r.github.io/docs/nimblestudio/create_studio_component.html} for full documentation.
}
\keyword{internal}
