% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_batch_disassociate_user_stack}
\alias{appstream_batch_disassociate_user_stack}
\title{Disassociates the specified users from the specified stacks}
\usage{
appstream_batch_disassociate_user_stack(UserStackAssociations)
}
\arguments{
\item{UserStackAssociations}{[required] The list of UserStackAssociation objects.}
}
\value{
A list with the following syntax:\preformatted{list(
  errors = list(
    list(
      UserStackAssociation = list(
        StackName = "string",
        UserName = "string",
        AuthenticationType = "API"|"SAML"|"USERPOOL",
        SendEmailNotification = TRUE|FALSE
      ),
      ErrorCode = "STACK_NOT_FOUND"|"USER_NAME_NOT_FOUND"|"DIRECTORY_NOT_FOUND"|"INTERNAL_ERROR",
      ErrorMessage = "string"
    )
  )
)
}
}
\description{
Disassociates the specified users from the specified stacks.
}
\section{Request syntax}{
\preformatted{svc$batch_disassociate_user_stack(
  UserStackAssociations = list(
    list(
      StackName = "string",
      UserName = "string",
      AuthenticationType = "API"|"SAML"|"USERPOOL",
      SendEmailNotification = TRUE|FALSE
    )
  )
)
}
}

\keyword{internal}
