# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon CodeGuru Reviewer
#'
#' @description
#' This section provides documentation for the Amazon CodeGuru Reviewer API
#' operations. CodeGuru Reviewer is a service that uses program analysis
#' and machine learning to detect potential defects that are difficult for
#' developers to find and recommends fixes in your Java and Python code.
#' 
#' By proactively detecting and providing recommendations for addressing
#' code defects and implementing best practices, CodeGuru Reviewer improves
#' the overall quality and maintainability of your code base during the
#' code review stage. For more information about CodeGuru Reviewer, see the
#' *\href{https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/welcome.html}{Amazon CodeGuru Reviewer User Guide}.*
#' 
#' To improve the security of your CodeGuru Reviewer API calls, you can
#' establish a private connection between your VPC and CodeGuru Reviewer by
#' creating an *interface VPC endpoint*. For more information, see
#' [CodeGuru Reviewer and interface VPC endpoints (Amazon Web Services
#' PrivateLink)](https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/vpc-interface-endpoints.html)
#' in the *Amazon CodeGuru Reviewer User Guide*.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- codegurureviewer(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- codegurureviewer()
#' svc$associate_repository(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=codegurureviewer_associate_repository]{associate_repository} \tab Use to associate an Amazon Web Services CodeCommit repository or a repository managed by Amazon Web Services CodeStar Connections with Amazon CodeGuru Reviewer\cr
#'  \link[=codegurureviewer_create_code_review]{create_code_review} \tab Use to create a code review with a CodeReviewType of RepositoryAnalysis\cr
#'  \link[=codegurureviewer_describe_code_review]{describe_code_review} \tab Returns the metadata associated with the code review along with its status\cr
#'  \link[=codegurureviewer_describe_recommendation_feedback]{describe_recommendation_feedback} \tab Describes the customer feedback for a CodeGuru Reviewer recommendation\cr
#'  \link[=codegurureviewer_describe_repository_association]{describe_repository_association} \tab Returns a RepositoryAssociation object that contains information about the requested repository association\cr
#'  \link[=codegurureviewer_disassociate_repository]{disassociate_repository} \tab Removes the association between Amazon CodeGuru Reviewer and a repository\cr
#'  \link[=codegurureviewer_list_code_reviews]{list_code_reviews} \tab Lists all the code reviews that the customer has created in the past 90 days\cr
#'  \link[=codegurureviewer_list_recommendation_feedback]{list_recommendation_feedback} \tab Returns a list of RecommendationFeedbackSummary objects that contain customer recommendation feedback for all CodeGuru Reviewer users\cr
#'  \link[=codegurureviewer_list_recommendations]{list_recommendations} \tab Returns the list of all recommendations for a completed code review\cr
#'  \link[=codegurureviewer_list_repository_associations]{list_repository_associations} \tab Returns a list of RepositoryAssociationSummary objects that contain summary information about a repository association\cr
#'  \link[=codegurureviewer_list_tags_for_resource]{list_tags_for_resource} \tab Returns the list of tags associated with an associated repository resource\cr
#'  \link[=codegurureviewer_put_recommendation_feedback]{put_recommendation_feedback} \tab Stores customer feedback for a CodeGuru Reviewer recommendation\cr
#'  \link[=codegurureviewer_tag_resource]{tag_resource} \tab Adds one or more tags to an associated repository\cr
#'  \link[=codegurureviewer_untag_resource]{untag_resource} \tab Removes a tag from an associated repository
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname codegurureviewer
#' @export
codegurureviewer <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .codegurureviewer$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.codegurureviewer <- list()

.codegurureviewer$operations <- list()

.codegurureviewer$metadata <- list(
  service_name = "codegurureviewer",
  endpoints = list("*" = list(endpoint = "codeguru-reviewer.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "codeguru-reviewer.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "codeguru-reviewer.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "codeguru-reviewer.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "CodeGuru Reviewer",
  api_version = "2019-09-19",
  signing_name = "codeguru-reviewer",
  json_version = "1.1",
  target_prefix = ""
)

.codegurureviewer$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.codegurureviewer$metadata, handlers, config)
}
