% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_update_webhook}
\alias{codebuild_update_webhook}
\title{Updates the webhook associated with an AWS CodeBuild build project}
\usage{
codebuild_update_webhook(projectName, branchFilter, rotateSecret,
  filterGroups, buildType)
}
\arguments{
\item{projectName}{[required] The name of the AWS CodeBuild project.}

\item{branchFilter}{A regular expression used to determine which repository branches are
built when a webhook is triggered. If the name of a branch matches the
regular expression, then it is built. If \code{branchFilter} is empty, then
all branches are built.

It is recommended that you use \code{filterGroups} instead of \code{branchFilter}.}

\item{rotateSecret}{A boolean value that specifies whether the associated GitHub
repository's secret token should be updated. If you use Bitbucket for
your repository, \code{rotateSecret} is ignored.}

\item{filterGroups}{An array of arrays of \code{WebhookFilter} objects used to determine if a
webhook event can trigger a build. A filter group must contain at least
one \code{EVENT} \code{WebhookFilter}.}

\item{buildType}{Specifies the type of build this webhook will trigger.}
}
\value{
A list with the following syntax:\preformatted{list(
  webhook = list(
    url = "string",
    payloadUrl = "string",
    secret = "string",
    branchFilter = "string",
    filterGroups = list(
      list(
        list(
          type = "EVENT"|"BASE_REF"|"HEAD_REF"|"ACTOR_ACCOUNT_ID"|"FILE_PATH"|"COMMIT_MESSAGE",
          pattern = "string",
          excludeMatchedPattern = TRUE|FALSE
        )
      )
    ),
    buildType = "BUILD"|"BUILD_BATCH",
    lastModifiedSecret = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Updates the webhook associated with an AWS CodeBuild build project.

If you use Bitbucket for your repository, \code{rotateSecret} is ignored.
}
\section{Request syntax}{
\preformatted{svc$update_webhook(
  projectName = "string",
  branchFilter = "string",
  rotateSecret = TRUE|FALSE,
  filterGroups = list(
    list(
      list(
        type = "EVENT"|"BASE_REF"|"HEAD_REF"|"ACTOR_ACCOUNT_ID"|"FILE_PATH"|"COMMIT_MESSAGE",
        pattern = "string",
        excludeMatchedPattern = TRUE|FALSE
      )
    )
  ),
  buildType = "BUILD"|"BUILD_BATCH"
)
}
}

\keyword{internal}
