% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_db_cluster_parameter_group}
\alias{rds_create_db_cluster_parameter_group}
\title{Creates a new DB cluster parameter group}
\usage{
rds_create_db_cluster_parameter_group(
  DBClusterParameterGroupName,
  DBParameterGroupFamily,
  Description,
  Tags = NULL
)
}
\arguments{
\item{DBClusterParameterGroupName}{[required] The name of the DB cluster parameter group.

Constraints:
\itemize{
\item Must not match the name of an existing DB cluster parameter group.
}

This value is stored as a lowercase string.}

\item{DBParameterGroupFamily}{[required] The DB cluster parameter group family name. A DB cluster parameter group
can be associated with one and only one DB cluster parameter group
family, and can be applied only to a DB cluster running a database
engine and engine version compatible with that DB cluster parameter
group family.

\strong{Aurora MySQL}

Example: \code{aurora-mysql5.7}, \code{aurora-mysql8.0}

\strong{Aurora PostgreSQL}

Example: \code{aurora-postgresql14}

\strong{RDS for MySQL}

Example: \code{mysql8.0}

\strong{RDS for PostgreSQL}

Example: \code{postgres13}

To list all of the available parameter group families for a DB engine,
use the following command:

\verb{aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine <engine>}

For example, to list all of the available parameter group families for
the Aurora PostgreSQL DB engine, use the following command:

\verb{aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine aurora-postgresql}

The output contains duplicates.

The following are the valid DB engine values:
\itemize{
\item \code{aurora-mysql}
\item \code{aurora-postgresql}
\item \code{mysql}
\item \code{postgres}
}}

\item{Description}{[required] The description for the DB cluster parameter group.}

\item{Tags}{Tags to assign to the DB cluster parameter group.}
}
\description{
Creates a new DB cluster parameter group.

See \url{https://www.paws-r-sdk.com/docs/rds_create_db_cluster_parameter_group/} for full documentation.
}
\keyword{internal}
