% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_db_cluster}
\alias{rds_modify_db_cluster}
\title{Modifies the settings of an Amazon Aurora DB cluster or a Multi-AZ DB
cluster}
\usage{
rds_modify_db_cluster(
  DBClusterIdentifier,
  NewDBClusterIdentifier = NULL,
  ApplyImmediately = NULL,
  BackupRetentionPeriod = NULL,
  DBClusterParameterGroupName = NULL,
  VpcSecurityGroupIds = NULL,
  Port = NULL,
  MasterUserPassword = NULL,
  OptionGroupName = NULL,
  PreferredBackupWindow = NULL,
  PreferredMaintenanceWindow = NULL,
  EnableIAMDatabaseAuthentication = NULL,
  BacktrackWindow = NULL,
  CloudwatchLogsExportConfiguration = NULL,
  EngineVersion = NULL,
  AllowMajorVersionUpgrade = NULL,
  DBInstanceParameterGroupName = NULL,
  Domain = NULL,
  DomainIAMRoleName = NULL,
  ScalingConfiguration = NULL,
  DeletionProtection = NULL,
  EnableHttpEndpoint = NULL,
  CopyTagsToSnapshot = NULL,
  EnableGlobalWriteForwarding = NULL,
  DBClusterInstanceClass = NULL,
  AllocatedStorage = NULL,
  StorageType = NULL,
  Iops = NULL,
  AutoMinorVersionUpgrade = NULL,
  MonitoringInterval = NULL,
  MonitoringRoleArn = NULL,
  EnablePerformanceInsights = NULL,
  PerformanceInsightsKMSKeyId = NULL,
  PerformanceInsightsRetentionPeriod = NULL,
  ServerlessV2ScalingConfiguration = NULL,
  NetworkType = NULL,
  ManageMasterUserPassword = NULL,
  RotateMasterUserPassword = NULL,
  MasterUserSecretKmsKeyId = NULL,
  EngineMode = NULL,
  AllowEngineModeChange = NULL,
  EnableLocalWriteForwarding = NULL,
  AwsBackupRecoveryPointArn = NULL
)
}
\arguments{
\item{DBClusterIdentifier}{[required] The DB cluster identifier for the cluster being modified. This parameter
isn't case-sensitive.

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters

Constraints:
\itemize{
\item Must match the identifier of an existing DB cluster.
}}

\item{NewDBClusterIdentifier}{The new DB cluster identifier for the DB cluster when renaming a DB
cluster. This value is stored as a lowercase string.

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item The first character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-cluster2}}

\item{ApplyImmediately}{Specifies whether the modifications in this request and any pending
modifications are asynchronously applied as soon as possible, regardless
of the \code{PreferredMaintenanceWindow} setting for the DB cluster. If this
parameter is disabled, changes to the DB cluster are applied during the
next maintenance window.

Most modifications can be applied immediately or during the next
scheduled maintenance window. Some modifications, such as turning on
deletion protection and changing the master password, are applied
immediately—regardless of when you choose to apply them.

By default, this parameter is disabled.

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters}

\item{BackupRetentionPeriod}{The number of days for which automated backups are retained. Specify a
minimum value of \code{1}.

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters

Default: \code{1}

Constraints:
\itemize{
\item Must be a value from 1 to 35.
}}

\item{DBClusterParameterGroupName}{The name of the DB cluster parameter group to use for the DB cluster.

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters}

\item{VpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with this DB cluster.

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters}

\item{Port}{The port number on which the DB cluster accepts connections.

Valid for Cluster Type: Aurora DB clusters only

Valid Values: \code{1150-65535}

Default: The same port as the original DB cluster.}

\item{MasterUserPassword}{The new password for the master database user.

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters

Constraints:
\itemize{
\item Must contain from 8 to 41 characters.
\item Can contain any printable ASCII character except "/", """, or "@".
\item Can't be specified if \code{ManageMasterUserPassword} is turned on.
}}

\item{OptionGroupName}{The option group to associate the DB cluster with.

DB clusters are associated with a default option group that can't be
modified.}

\item{PreferredBackupWindow}{The daily time range during which automated backups are created if
automated backups are enabled, using the \code{BackupRetentionPeriod}
parameter.

The default is a 30-minute window selected at random from an 8-hour
block of time for each Amazon Web Services Region. To view the time
blocks available, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow}{Backup window}
in the \emph{Amazon Aurora User Guide}.

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters

Constraints:
\itemize{
\item Must be in the format \code{hh24:mi-hh24:mi}.
\item Must be in Universal Coordinated Time (UTC).
\item Must not conflict with the preferred maintenance window.
\item Must be at least 30 minutes.
}}

\item{PreferredMaintenanceWindow}{The weekly time range during which system maintenance can occur, in
Universal Coordinated Time (UTC).

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters

The default is a 30-minute window selected at random from an 8-hour
block of time for each Amazon Web Services Region, occurring on a random
day of the week. To see the time blocks available, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora}{Adjusting the Preferred DB Cluster Maintenance Window}
in the \emph{Amazon Aurora User Guide}.

Constraints:
\itemize{
\item Must be in the format \code{ddd:hh24:mi-ddd:hh24:mi}.
\item Days must be one of \code{Mon | Tue | Wed | Thu | Fri | Sat | Sun}.
\item Must be in Universal Coordinated Time (UTC).
\item Must be at least 30 minutes.
}}

\item{EnableIAMDatabaseAuthentication}{Specifies whether to enable mapping of Amazon Web Services Identity and
Access Management (IAM) accounts to database accounts. By default,
mapping isn't enabled.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html}{IAM Database Authentication}
in the \emph{Amazon Aurora User Guide}.

Valid for Cluster Type: Aurora DB clusters only}

\item{BacktrackWindow}{The target backtrack window, in seconds. To disable backtracking, set
this value to \code{0}.

Valid for Cluster Type: Aurora MySQL DB clusters only

Default: \code{0}

Constraints:
\itemize{
\item If specified, this value must be set to a number from 0 to 259,200
(72 hours).
}}

\item{CloudwatchLogsExportConfiguration}{The configuration setting for the log types to be enabled for export to
CloudWatch Logs for a specific DB cluster.

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters

The following values are valid for each DB engine:
\itemize{
\item Aurora MySQL - \code{audit | error | general | slowquery}
\item Aurora PostgreSQL - \code{postgresql}
\item RDS for MySQL - \code{error | general | slowquery}
\item RDS for PostgreSQL - \code{postgresql | upgrade}
}

For more information about exporting CloudWatch Logs for Amazon RDS, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon RDS User Guide}.

For more information about exporting CloudWatch Logs for Amazon Aurora,
see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon Aurora User Guide}.}

\item{EngineVersion}{The version number of the database engine to which you want to upgrade.
Changing this parameter results in an outage. The change is applied
during the next maintenance window unless \code{ApplyImmediately} is enabled.

If the cluster that you're modifying has one or more read replicas, all
replicas must be running an engine version that's the same or later than
the version you specify.

To list all of the available engine versions for Aurora MySQL, use the
following command:

\verb{aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"}

To list all of the available engine versions for Aurora PostgreSQL, use
the following command:

\verb{aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"}

To list all of the available engine versions for RDS for MySQL, use the
following command:

\verb{aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"}

To list all of the available engine versions for RDS for PostgreSQL, use
the following command:

\verb{aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"}

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters}

\item{AllowMajorVersionUpgrade}{Specifies whether major version upgrades are allowed.

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters

Constraints:
\itemize{
\item You must allow major version upgrades when specifying a value for
the \code{EngineVersion} parameter that is a different major version than
the DB cluster's current version.
}}

\item{DBInstanceParameterGroupName}{The name of the DB parameter group to apply to all instances of the DB
cluster.

When you apply a parameter group using the
\code{DBInstanceParameterGroupName} parameter, the DB cluster isn't rebooted
automatically. Also, parameter changes are applied immediately rather
than during the next maintenance window.

Valid for Cluster Type: Aurora DB clusters only

Default: The existing name setting

Constraints:
\itemize{
\item The DB parameter group must be in the same DB parameter group family
as this DB cluster.
\item The \code{DBInstanceParameterGroupName} parameter is valid in combination
with the \code{AllowMajorVersionUpgrade} parameter for a major version
upgrade only.
}}

\item{Domain}{The Active Directory directory ID to move the DB cluster to. Specify
\code{none} to remove the cluster from its current domain. The domain must be
created prior to this operation.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/database-authentication.html}{Kerberos Authentication}
in the \emph{Amazon Aurora User Guide}.

Valid for Cluster Type: Aurora DB clusters only}

\item{DomainIAMRoleName}{The name of the IAM role to use when making API calls to the Directory
Service.

Valid for Cluster Type: Aurora DB clusters only}

\item{ScalingConfiguration}{The scaling properties of the DB cluster. You can only modify scaling
properties for DB clusters in \code{serverless} DB engine mode.

Valid for Cluster Type: Aurora DB clusters only}

\item{DeletionProtection}{Specifies whether the DB cluster has deletion protection enabled. The
database can't be deleted when deletion protection is enabled. By
default, deletion protection isn't enabled.

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters}

\item{EnableHttpEndpoint}{Specifies whether to enable the HTTP endpoint for an Aurora Serverless
v1 DB cluster. By default, the HTTP endpoint isn't enabled.

When enabled, the HTTP endpoint provides a connectionless web service
API (RDS Data API) for running SQL queries on the Aurora Serverless v1
DB cluster. You can also query your database from inside the RDS console
with the RDS query editor.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html}{Using RDS Data API}
in the \emph{Amazon Aurora User Guide}.

This parameter applies only to Aurora Serverless v1 DB clusters. To
enable or disable the HTTP endpoint for an Aurora PostgreSQL Serverless
v2 or provisioned DB cluster, use the
\code{\link[=rds_enable_http_endpoint]{enable_http_endpoint}} and
\code{\link[=rds_disable_http_endpoint]{disable_http_endpoint}} operations.

Valid for Cluster Type: Aurora DB clusters only}

\item{CopyTagsToSnapshot}{Specifies whether to copy all tags from the DB cluster to snapshots of
the DB cluster. The default is not to copy them.

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters}

\item{EnableGlobalWriteForwarding}{Specifies whether to enable this DB cluster to forward write operations
to the primary cluster of a global cluster (Aurora global database). By
default, write operations are not allowed on Aurora DB clusters that are
secondary clusters in an Aurora global database.

You can set this value only on Aurora DB clusters that are members of an
Aurora global database. With this parameter enabled, a secondary cluster
can forward writes to the current primary cluster, and the resulting
changes are replicated back to this cluster. For the primary DB cluster
of an Aurora global database, this value is used immediately if the
primary is demoted by a global cluster API operation, but it does
nothing until then.

Valid for Cluster Type: Aurora DB clusters only}

\item{DBClusterInstanceClass}{The compute and memory capacity of each DB instance in the Multi-AZ DB
cluster, for example \code{db.m6gd.xlarge}. Not all DB instance classes are
available in all Amazon Web Services Regions, or for all database
engines.

For the full list of DB instance classes and availability for your
engine, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html}{DB Instance Class}
in the \emph{Amazon RDS User Guide}.

Valid for Cluster Type: Multi-AZ DB clusters only}

\item{AllocatedStorage}{The amount of storage in gibibytes (GiB) to allocate to each DB instance
in the Multi-AZ DB cluster.

Valid for Cluster Type: Multi-AZ DB clusters only}

\item{StorageType}{The storage type to associate with the DB cluster.

For information on storage types for Aurora DB clusters, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type}{Storage configurations for Amazon Aurora DB clusters}.
For information on storage types for Multi-AZ DB clusters, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings}{Settings for creating Multi-AZ DB clusters}.

When specified for a Multi-AZ DB cluster, a value for the \code{Iops}
parameter is required.

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters

Valid Values:
\itemize{
\item Aurora DB clusters - \code{aurora | aurora-iopt1}
\item Multi-AZ DB clusters - \code{io1}
}

Default:
\itemize{
\item Aurora DB clusters - \code{aurora}
\item Multi-AZ DB clusters - \code{io1}
}}

\item{Iops}{The amount of Provisioned IOPS (input/output operations per second) to
be initially allocated for each DB instance in the Multi-AZ DB cluster.

For information about valid IOPS values, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS}{Amazon RDS Provisioned IOPS storage}
in the \emph{Amazon RDS User Guide}.

Valid for Cluster Type: Multi-AZ DB clusters only

Constraints:
\itemize{
\item Must be a multiple between .5 and 50 of the storage amount for the
DB cluster.
}}

\item{AutoMinorVersionUpgrade}{Specifies whether minor engine upgrades are applied automatically to the
DB cluster during the maintenance window. By default, minor engine
upgrades are applied automatically.

Valid for Cluster Type: Multi-AZ DB clusters only}

\item{MonitoringInterval}{The interval, in seconds, between points when Enhanced Monitoring
metrics are collected for the DB cluster. To turn off collecting
Enhanced Monitoring metrics, specify \code{0}.

If \code{MonitoringRoleArn} is specified, also set \code{MonitoringInterval} to a
value other than \code{0}.

Valid for Cluster Type: Multi-AZ DB clusters only

Valid Values: \code{0 | 1 | 5 | 10 | 15 | 30 | 60}

Default: \code{0}}

\item{MonitoringRoleArn}{The Amazon Resource Name (ARN) for the IAM role that permits RDS to send
Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is
\code{arn:aws:iam:123456789012:role/emaccess}. For information on creating a
monitoring role, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole}{To create an IAM role for Amazon RDS Enhanced Monitoring}
in the \emph{Amazon RDS User Guide.}

If \code{MonitoringInterval} is set to a value other than \code{0}, supply a
\code{MonitoringRoleArn} value.

Valid for Cluster Type: Multi-AZ DB clusters only}

\item{EnablePerformanceInsights}{Specifies whether to turn on Performance Insights for the DB cluster.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html}{Using Amazon Performance Insights}
in the \emph{Amazon RDS User Guide}.

Valid for Cluster Type: Multi-AZ DB clusters only}

\item{PerformanceInsightsKMSKeyId}{The Amazon Web Services KMS key identifier for encryption of Performance
Insights data.

The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
ARN, or alias name for the KMS key.

If you don't specify a value for \code{PerformanceInsightsKMSKeyId}, then
Amazon RDS uses your default KMS key. There is a default KMS key for
your Amazon Web Services account. Your Amazon Web Services account has a
different default KMS key for each Amazon Web Services Region.

Valid for Cluster Type: Multi-AZ DB clusters only}

\item{PerformanceInsightsRetentionPeriod}{The number of days to retain Performance Insights data.

Valid for Cluster Type: Multi-AZ DB clusters only

Valid Values:
\itemize{
\item \code{7}
\item \emph{month} * 31, where \emph{month} is a number of months from 1-23.
Examples: \code{93} (3 months * 31), \code{341} (11 months * 31), \code{589} (19
months * 31)
\item \code{731}
}

Default: \code{7} days

If you specify a retention period that isn't valid, such as \code{94}, Amazon
RDS issues an error.}

\item{ServerlessV2ScalingConfiguration}{}

\item{NetworkType}{The network type of the DB cluster.

The network type is determined by the \code{DBSubnetGroup} specified for the
DB cluster. A \code{DBSubnetGroup} can support only the IPv4 protocol or the
IPv4 and the IPv6 protocols (\code{DUAL}).

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html}{Working with a DB instance in a VPC}
in the \emph{Amazon Aurora User Guide.}

Valid for Cluster Type: Aurora DB clusters only

Valid Values: \code{IPV4 | DUAL}}

\item{ManageMasterUserPassword}{Specifies whether to manage the master user password with Amazon Web
Services Secrets Manager.

If the DB cluster doesn't manage the master user password with Amazon
Web Services Secrets Manager, you can turn on this management. In this
case, you can't specify \code{MasterUserPassword}.

If the DB cluster already manages the master user password with Amazon
Web Services Secrets Manager, and you specify that the master user
password is not managed with Amazon Web Services Secrets Manager, then
you must specify \code{MasterUserPassword}. In this case, RDS deletes the
secret and uses the new password for the master user specified by
\code{MasterUserPassword}.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html}{Password management with Amazon Web Services Secrets Manager}
in the \emph{Amazon RDS User Guide} and \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html}{Password management with Amazon Web Services Secrets Manager}
in the \emph{Amazon Aurora User Guide.}

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters}

\item{RotateMasterUserPassword}{Specifies whether to rotate the secret managed by Amazon Web Services
Secrets Manager for the master user password.

This setting is valid only if the master user password is managed by RDS
in Amazon Web Services Secrets Manager for the DB cluster. The secret
value contains the updated password.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html}{Password management with Amazon Web Services Secrets Manager}
in the \emph{Amazon RDS User Guide} and \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html}{Password management with Amazon Web Services Secrets Manager}
in the \emph{Amazon Aurora User Guide.}

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters

Constraints:
\itemize{
\item You must apply the change immediately when rotating the master user
password.
}}

\item{MasterUserSecretKmsKeyId}{The Amazon Web Services KMS key identifier to encrypt a secret that is
automatically generated and managed in Amazon Web Services Secrets
Manager.

This setting is valid only if both of the following conditions are met:
\itemize{
\item The DB cluster doesn't manage the master user password in Amazon Web
Services Secrets Manager.

If the DB cluster already manages the master user password in Amazon
Web Services Secrets Manager, you can't change the KMS key that is
used to encrypt the secret.
\item You are turning on \code{ManageMasterUserPassword} to manage the master
user password in Amazon Web Services Secrets Manager.

If you are turning on \code{ManageMasterUserPassword} and don't specify
\code{MasterUserSecretKmsKeyId}, then the \code{aws/secretsmanager} KMS key is
used to encrypt the secret. If the secret is in a different Amazon
Web Services account, then you can't use the \code{aws/secretsmanager}
KMS key to encrypt the secret, and you must use a customer managed
KMS key.
}

The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
ARN, or alias name for the KMS key. To use a KMS key in a different
Amazon Web Services account, specify the key ARN or alias ARN.

There is a default KMS key for your Amazon Web Services account. Your
Amazon Web Services account has a different default KMS key for each
Amazon Web Services Region.

Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters}

\item{EngineMode}{The DB engine mode of the DB cluster, either \code{provisioned} or
\code{serverless}.

The DB engine mode can be modified only from \code{serverless} to
\code{provisioned}.

For more information, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html}{CreateDBCluster}.

Valid for Cluster Type: Aurora DB clusters only}

\item{AllowEngineModeChange}{Specifies whether engine mode changes from \code{serverless} to \code{provisioned}
are allowed.

Valid for Cluster Type: Aurora Serverless v1 DB clusters only

Constraints:
\itemize{
\item You must allow engine mode changes when specifying a different value
for the \code{EngineMode} parameter from the DB cluster's current engine
mode.
}}

\item{EnableLocalWriteForwarding}{Specifies whether read replicas can forward write operations to the
writer DB instance in the DB cluster. By default, write operations
aren't allowed on reader DB instances.

Valid for: Aurora DB clusters only}

\item{AwsBackupRecoveryPointArn}{The Amazon Resource Name (ARN) of the recovery point in Amazon Web
Services Backup.}
}
\description{
Modifies the settings of an Amazon Aurora DB cluster or a Multi-AZ DB cluster. You can change one or more settings by specifying these parameters and the new values in the request.

See \url{https://www.paws-r-sdk.com/docs/rds_modify_db_cluster/} for full documentation.
}
\keyword{internal}
