% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_add_tags_to_resource}
\alias{elasticache_add_tags_to_resource}
\title{A tag is a key-value pair where the key and value are case-sensitive}
\usage{
elasticache_add_tags_to_resource(ResourceName, Tags)
}
\arguments{
\item{ResourceName}{[required] The Amazon Resource Name (ARN) of the resource to which the tags are to
be added, for example
\code{arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster} or
\code{arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot}.
ElastiCache resources are \emph{cluster} and \emph{snapshot}.

For more information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs) and Amazon Service Namespaces}.}

\item{Tags}{[required] A list of tags to be added to this resource. A tag is a key-value pair.
A tag key must be accompanied by a tag value, although null is accepted.}
}
\description{
A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html}{Resource-level permissions}.

See \url{https://www.paws-r-sdk.com/docs/elasticache_add_tags_to_resource/} for full documentation.
}
\keyword{internal}
