% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_create_hsm_configuration}
\alias{redshift_create_hsm_configuration}
\title{Creates an HSM configuration that contains the information required by
an Amazon Redshift cluster to store and use database encryption keys in
a Hardware Security Module (HSM)}
\usage{
redshift_create_hsm_configuration(
  HsmConfigurationIdentifier,
  Description,
  HsmIpAddress,
  HsmPartitionName,
  HsmPartitionPassword,
  HsmServerPublicCertificate,
  Tags = NULL
)
}
\arguments{
\item{HsmConfigurationIdentifier}{[required] The identifier to be assigned to the new Amazon Redshift HSM
configuration.}

\item{Description}{[required] A text description of the HSM configuration to be created.}

\item{HsmIpAddress}{[required] The IP address that the Amazon Redshift cluster must use to access the
HSM.}

\item{HsmPartitionName}{[required] The name of the partition in the HSM where the Amazon Redshift clusters
will store their database encryption keys.}

\item{HsmPartitionPassword}{[required] The password required to access the HSM partition.}

\item{HsmServerPublicCertificate}{[required] The HSMs public certificate file. When using Cloud HSM, the file name is
server.pem.}

\item{Tags}{A list of tag instances.}
}
\description{
Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and use database encryption keys in a Hardware Security Module (HSM). After creating the HSM configuration, you can specify it as a parameter when creating a cluster. The cluster will then store its encryption keys in the HSM.

See \url{https://paws-r.github.io/docs/redshift/create_hsm_configuration.html} for full documentation.
}
\keyword{internal}
