% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_create_snapshot_schedule}
\alias{redshift_create_snapshot_schedule}
\title{Creates a new snapshot schedule}
\usage{
redshift_create_snapshot_schedule(ScheduleDefinitions,
  ScheduleIdentifier, ScheduleDescription, Tags, DryRun, NextInvocations)
}
\arguments{
\item{ScheduleDefinitions}{The definition of the snapshot schedule. The definition is made up of
schedule expressions, for example \"cron(30 12 *)\" or \"rate(12
hours)\".}

\item{ScheduleIdentifier}{A unique identifier for a snapshot schedule. Only alphanumeric
characters are allowed for the identifier.}

\item{ScheduleDescription}{The description of the snapshot schedule.}

\item{Tags}{An optional set of tags you can use to search for the schedule.}

\item{DryRun}{}

\item{NextInvocations}{}
}
\description{
Creates a new snapshot schedule.
}
\section{Request syntax}{
\preformatted{svc$create_snapshot_schedule(
  ScheduleDefinitions = list(
    "string"
  ),
  ScheduleIdentifier = "string",
  ScheduleDescription = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  DryRun = TRUE|FALSE,
  NextInvocations = 123
)
}
}

\keyword{internal}
