% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_query}
\alias{dynamodb_query}
\title{The Query operation finds items based on primary key values}
\usage{
dynamodb_query(TableName, IndexName, Select, AttributesToGet, Limit,
  ConsistentRead, KeyConditions, QueryFilter, ConditionalOperator,
  ScanIndexForward, ExclusiveStartKey, ReturnConsumedCapacity,
  ProjectionExpression, FilterExpression, KeyConditionExpression,
  ExpressionAttributeNames, ExpressionAttributeValues)
}
\arguments{
\item{TableName}{[required] The name of the table containing the requested items.}

\item{IndexName}{The name of an index to query. This index can be any local secondary
index or global secondary index on the table. Note that if you use the
\code{IndexName} parameter, you must also provide \code{TableName.}}

\item{Select}{The attributes to be returned in the result. You can retrieve all item
attributes, specific item attributes, the count of matching items, or in
the case of an index, some or all of the attributes projected into the
index.
\itemize{
\item \code{ALL_ATTRIBUTES} - Returns all of the item attributes from the
specified table or index. If you query a local secondary index, then
for each matching item in the index, DynamoDB fetches the entire
item from the parent table. If the index is configured to project
all item attributes, then all of the data can be obtained from the
local secondary index, and no fetching is required.
\item \code{ALL_PROJECTED_ATTRIBUTES} - Allowed only when querying an index.
Retrieves all attributes that have been projected into the index. If
the index is configured to project all attributes, this return value
is equivalent to specifying \code{ALL_ATTRIBUTES}.
\item \code{COUNT} - Returns the number of matching items, rather than the
matching items themselves.
\item \code{SPECIFIC_ATTRIBUTES} - Returns only the attributes listed in
\code{AttributesToGet}. This return value is equivalent to specifying
\code{AttributesToGet} without specifying any value for \code{Select}.

If you query or scan a local secondary index and request only
attributes that are projected into that index, the operation will
read only the index and not the table. If any of the requested
attributes are not projected into the local secondary index,
DynamoDB fetches each of these attributes from the parent table.
This extra fetching incurs additional throughput cost and latency.

If you query or scan a global secondary index, you can only request
attributes that are projected into the index. Global secondary index
queries cannot fetch attributes from the parent table.
}

If neither \code{Select} nor \code{AttributesToGet} are specified, DynamoDB
defaults to \code{ALL_ATTRIBUTES} when accessing a table, and
\code{ALL_PROJECTED_ATTRIBUTES} when accessing an index. You cannot use both
\code{Select} and \code{AttributesToGet} together in a single request, unless the
value for \code{Select} is \code{SPECIFIC_ATTRIBUTES}. (This usage is equivalent
to specifying \code{AttributesToGet} without any value for \code{Select}.)

If you use the \code{ProjectionExpression} parameter, then the value for
\code{Select} can only be \code{SPECIFIC_ATTRIBUTES}. Any other value for \code{Select}
will return an error.}

\item{AttributesToGet}{This is a legacy parameter. Use \code{ProjectionExpression} instead. For more
information, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html}{AttributesToGet}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{Limit}{The maximum number of items to evaluate (not necessarily the number of
matching items). If DynamoDB processes the number of items up to the
limit while processing the results, it stops the operation and returns
the matching values up to that point, and a key in \code{LastEvaluatedKey} to
apply in a subsequent operation, so that you can pick up where you left
off. Also, if the processed dataset size exceeds 1 MB before DynamoDB
reaches this limit, it stops the operation and returns the matching
values up to the limit, and a key in \code{LastEvaluatedKey} to apply in a
subsequent operation to continue the operation. For more information,
see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html}{Query and Scan}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ConsistentRead}{Determines the read consistency model: If set to \code{true}, then the
operation uses strongly consistent reads; otherwise, the operation uses
eventually consistent reads.

Strongly consistent reads are not supported on global secondary indexes.
If you query a global secondary index with \code{ConsistentRead} set to
\code{true}, you will receive a \code{ValidationException}.}

\item{KeyConditions}{This is a legacy parameter. Use \code{KeyConditionExpression} instead. For
more information, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html}{KeyConditions}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{QueryFilter}{This is a legacy parameter. Use \code{FilterExpression} instead. For more
information, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html}{QueryFilter}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ConditionalOperator}{This is a legacy parameter. Use \code{FilterExpression} instead. For more
information, see
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html}{ConditionalOperator}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ScanIndexForward}{Specifies the order for index traversal: If \code{true} (default), the
traversal is performed in ascending order; if \code{false}, the traversal is
performed in descending order.

Items with the same partition key value are stored in sorted order by
sort key. If the sort key data type is Number, the results are stored in
numeric order. For type String, the results are stored in order of UTF-8
bytes. For type Binary, DynamoDB treats each byte of the binary data as
unsigned.

If \code{ScanIndexForward} is \code{true}, DynamoDB returns the results in the
order in which they are stored (by sort key value). This is the default
behavior. If \code{ScanIndexForward} is \code{false}, DynamoDB reads the results
in reverse order by sort key value, and then returns the results to the
client.}

\item{ExclusiveStartKey}{The primary key of the first item that this operation will evaluate. Use
the value that was returned for \code{LastEvaluatedKey} in the previous
operation.

The data type for \code{ExclusiveStartKey} must be String, Number, or Binary.
No set data types are allowed.}

\item{ReturnConsumedCapacity}{}

\item{ProjectionExpression}{A string that identifies one or more attributes to retrieve from the
table. These attributes can include scalars, sets, or elements of a JSON
document. The attributes in the expression must be separated by commas.

If no attribute names are specified, then all attributes will be
returned. If any of the requested attributes are not found, they will
not appear in the result.

For more information, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html}{Accessing Item Attributes}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{FilterExpression}{A string that contains conditions that DynamoDB applies after the
\code{Query} operation, but before the data is returned to you. Items that do
not satisfy the \code{FilterExpression} criteria are not returned.

A \code{FilterExpression} does not allow key attributes. You cannot define a
filter expression based on a partition key or a sort key.

A \code{FilterExpression} is applied after the items have already been read;
the process of filtering does not consume any additional read capacity
units.

For more information, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults}{Filter Expressions}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{KeyConditionExpression}{The condition that specifies the key values for items to be retrieved by
the \code{Query} action.

The condition must perform an equality test on a single partition key
value.

The condition can optionally perform one of several comparison tests on
a single sort key value. This allows \code{Query} to retrieve one item with a
given partition key value and sort key value, or several items that have
the same partition key value but different sort key values.

The partition key equality test is required, and must be specified in
the following format:

\code{partitionKeyName} \emph{=} \verb{:partitionkeyval}

If you also want to provide a condition for the sort key, it must be
combined using \code{AND} with the condition for the sort key. Following is
an example, using the \strong{=} comparison operator for the sort key:

\code{partitionKeyName} \code{=} \verb{:partitionkeyval} \code{AND} \code{sortKeyName} \code{=}
\verb{:sortkeyval}

Valid comparisons for the sort key condition are as follows:
\itemize{
\item \code{sortKeyName} \code{=} \verb{:sortkeyval} - true if the sort key value is
equal to \verb{:sortkeyval}.
\item \code{sortKeyName} \verb{&lt;} \verb{:sortkeyval} - true if the sort key value is
less than \verb{:sortkeyval}.
\item \code{sortKeyName} \verb{&lt;=} \verb{:sortkeyval} - true if the sort key value is
less than or equal to \verb{:sortkeyval}.
\item \code{sortKeyName} \verb{&gt;} \verb{:sortkeyval} - true if the sort key value is
greater than \verb{:sortkeyval}.
\item \code{sortKeyName} \verb{&gt;= } \verb{:sortkeyval} - true if the sort key value is
greater than or equal to \verb{:sortkeyval}.
\item \code{sortKeyName} \code{BETWEEN} \verb{:sortkeyval1} \code{AND} \verb{:sortkeyval2} - true
if the sort key value is greater than or equal to \verb{:sortkeyval1},
and less than or equal to \verb{:sortkeyval2}.
\item \verb{begins_with (} \code{sortKeyName}, \verb{:sortkeyval} \verb{)} - true if the sort
key value begins with a particular operand. (You cannot use this
function with a sort key that is of type Number.) Note that the
function name \code{begins_with} is case-sensitive.
}

Use the \code{ExpressionAttributeValues} parameter to replace tokens such as
\verb{:partitionval} and \verb{:sortval} with actual values at runtime.

You can optionally use the \code{ExpressionAttributeNames} parameter to
replace the names of the partition key and sort key with placeholder
tokens. This option might be necessary if an attribute name conflicts
with a DynamoDB reserved word. For example, the following
\code{KeyConditionExpression} parameter causes an error because \emph{Size} is a
reserved word:
\itemize{
\item \verb{Size = :myval}
}

To work around this, define a placeholder (such a \verb{#S}) to represent the
attribute name \emph{Size}. \code{KeyConditionExpression} then is as follows:
\itemize{
\item \verb{#S = :myval}
}

For a list of reserved words, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html}{Reserved Words}
in the \emph{Amazon DynamoDB Developer Guide}.

For more information on \code{ExpressionAttributeNames} and
\code{ExpressionAttributeValues}, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html}{Using Placeholders for Attribute Names and Values}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ExpressionAttributeNames}{One or more substitution tokens for attribute names in an expression.
The following are some use cases for using \code{ExpressionAttributeNames}:
\itemize{
\item To access an attribute whose name conflicts with a DynamoDB reserved
word.
\item To create a placeholder for repeating occurrences of an attribute
name in an expression.
\item To prevent special characters in an attribute name from being
misinterpreted in an expression.
}

Use the \strong{\\#} character in an expression to dereference an attribute
name. For example, consider the following attribute name:
\itemize{
\item \code{Percentile}
}

The name of this attribute conflicts with a reserved word, so it cannot
be used directly in an expression. (For the complete list of reserved
words, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html}{Reserved Words}
in the \emph{Amazon DynamoDB Developer Guide}). To work around this, you
could specify the following for \code{ExpressionAttributeNames}:
\itemize{
\item \verb{\\\{"#P":"Percentile"\\\}}
}

You could then use this substitution in an expression, as in this
example:
\itemize{
\item \verb{#P = :val}
}

Tokens that begin with the \strong{:} character are \emph{expression attribute
values}, which are placeholders for the actual value at runtime.

For more information on expression attribute names, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html}{Specifying Item Attributes}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{ExpressionAttributeValues}{One or more values that can be substituted in an expression.

Use the \strong{:} (colon) character in an expression to dereference an
attribute value. For example, suppose that you wanted to check whether
the value of the \emph{ProductStatus} attribute was one of the following:

\code{Available | Backordered | Discontinued}

You would first need to specify \code{ExpressionAttributeValues} as follows:

\verb{\\\{ ":avail":\\\{"S":"Available"\\\}, ":back":\\\{"S":"Backordered"\\\}, ":disc":\\\{"S":"Discontinued"\\\} \\\}}

You could then use these values in an expression, such as this:

\verb{ProductStatus IN (:avail, :back, :disc)}

For more information on expression attribute values, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html}{Specifying Conditions}
in the \emph{Amazon DynamoDB Developer Guide}.}
}
\description{
The \code{Query} operation finds items based on primary key values. You can
query any table or secondary index that has a composite primary key (a
partition key and a sort key).
}
\details{
Use the \code{KeyConditionExpression} parameter to provide a specific value
for the partition key. The \code{Query} operation will return all of the
items from the table or index with that partition key value. You can
optionally narrow the scope of the \code{Query} operation by specifying a
sort key value and a comparison operator in \code{KeyConditionExpression}. To
further refine the \code{Query} results, you can optionally provide a
\code{FilterExpression}. A \code{FilterExpression} determines which items within
the results should be returned to you. All of the other results are
discarded.

A \code{Query} operation always returns a result set. If no matching items
are found, the result set will be empty. Queries that do not return
results consume the minimum number of read capacity units for that type
of read operation.

DynamoDB calculates the number of read capacity units consumed based on
item size, not on the amount of data that is returned to an application.
The number of capacity units consumed will be the same whether you
request all of the attributes (the default behavior) or just some of
them (using a projection expression). The number will also be the same
whether or not you use a \code{FilterExpression}.

\code{Query} results are always sorted by the sort key value. If the data
type of the sort key is Number, the results are returned in numeric
order; otherwise, the results are returned in order of UTF-8 bytes. By
default, the sort order is ascending. To reverse the order, set the
\code{ScanIndexForward} parameter to false.

A single \code{Query} operation will read up to the maximum number of items
set (if using the \code{Limit} parameter) or a maximum of 1 MB of data and
then apply any filtering to the results using \code{FilterExpression}. If
\code{LastEvaluatedKey} is present in the response, you will need to paginate
the result set. For more information, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Query.html#Query.Pagination}{Paginating the Results}
in the \emph{Amazon DynamoDB Developer Guide}.

\code{FilterExpression} is applied after a \code{Query} finishes, but before the
results are returned. A \code{FilterExpression} cannot contain partition key
or sort key attributes. You need to specify those attributes in the
\code{KeyConditionExpression}.

A \code{Query} operation can return an empty result set and a
\code{LastEvaluatedKey} if all the items read for the page of results are
filtered out.

You can query a table, a local secondary index, or a global secondary
index. For a query on a table or on a local secondary index, you can set
the \code{ConsistentRead} parameter to \code{true} and obtain a strongly
consistent result. Global secondary indexes support eventually
consistent reads only, so do not specify \code{ConsistentRead} when querying
a global secondary index.
}
\section{Request syntax}{
\preformatted{svc$query(
  TableName = "string",
  IndexName = "string",
  Select = "ALL_ATTRIBUTES"|"ALL_PROJECTED_ATTRIBUTES"|"SPECIFIC_ATTRIBUTES"|"COUNT",
  AttributesToGet = list(
    "string"
  ),
  Limit = 123,
  ConsistentRead = TRUE|FALSE,
  KeyConditions = list(
    list(
      AttributeValueList = list(
        list(
          S = "string",
          N = "string",
          B = raw,
          SS = list(
            "string"
          ),
          NS = list(
            "string"
          ),
          BS = list(
            raw
          ),
          M = list(
            list()
          ),
          L = list(
            list()
          ),
          NULL = TRUE|FALSE,
          BOOL = TRUE|FALSE
        )
      ),
      ComparisonOperator = "EQ"|"NE"|"IN"|"LE"|"LT"|"GE"|"GT"|"BETWEEN"|"NOT_NULL"|"NULL"|"CONTAINS"|"NOT_CONTAINS"|"BEGINS_WITH"
    )
  ),
  QueryFilter = list(
    list(
      AttributeValueList = list(
        list(
          S = "string",
          N = "string",
          B = raw,
          SS = list(
            "string"
          ),
          NS = list(
            "string"
          ),
          BS = list(
            raw
          ),
          M = list(
            list()
          ),
          L = list(
            list()
          ),
          NULL = TRUE|FALSE,
          BOOL = TRUE|FALSE
        )
      ),
      ComparisonOperator = "EQ"|"NE"|"IN"|"LE"|"LT"|"GE"|"GT"|"BETWEEN"|"NOT_NULL"|"NULL"|"CONTAINS"|"NOT_CONTAINS"|"BEGINS_WITH"
    )
  ),
  ConditionalOperator = "AND"|"OR",
  ScanIndexForward = TRUE|FALSE,
  ExclusiveStartKey = list(
    list(
      S = "string",
      N = "string",
      B = raw,
      SS = list(
        "string"
      ),
      NS = list(
        "string"
      ),
      BS = list(
        raw
      ),
      M = list(
        list()
      ),
      L = list(
        list()
      ),
      NULL = TRUE|FALSE,
      BOOL = TRUE|FALSE
    )
  ),
  ReturnConsumedCapacity = "INDEXES"|"TOTAL"|"NONE",
  ProjectionExpression = "string",
  FilterExpression = "string",
  KeyConditionExpression = "string",
  ExpressionAttributeNames = list(
    "string"
  ),
  ExpressionAttributeValues = list(
    list(
      S = "string",
      N = "string",
      B = raw,
      SS = list(
        "string"
      ),
      NS = list(
        "string"
      ),
      BS = list(
        raw
      ),
      M = list(
        list()
      ),
      L = list(
        list()
      ),
      NULL = TRUE|FALSE,
      BOOL = TRUE|FALSE
    )
  )
)
}
}

\examples{
# This example queries items in the Music table. The table has a partition
# key and sort key (Artist and SongTitle), but this query only specifies
# the partition key value. It returns song titles by the artist named "No
# One You Know".
\donttest{svc$query(
  ExpressionAttributeValues = list(
    `:v1` = list(
      S = "No One You Know"
    )
  ),
  KeyConditionExpression = "Artist = :v1",
  ProjectionExpression = "SongTitle",
  TableName = "Music"
)}

}
\keyword{internal}
