% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdsdataservice_operations.R
\name{rdsdataservice_begin_transaction}
\alias{rdsdataservice_begin_transaction}
\title{Starts a SQL transaction}
\usage{
rdsdataservice_begin_transaction(database, resourceArn, schema,
  secretArn)
}
\arguments{
\item{database}{The name of the database.}

\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.}

\item{schema}{The name of the database schema.}

\item{secretArn}{[required] The name or ARN of the secret that enables access to the DB cluster.}
}
\value{
A list with the following syntax:\preformatted{list(
  transactionId = "string"
)
}
}
\description{
Starts a SQL transaction.\preformatted{ <important> <p>A transaction can run for a maximum of 24 hours. A transaction is terminated and rolled back automatically after 24 hours.</p> <p>A transaction times out if no calls use its transaction ID in three minutes. If a transaction times out before it's committed, it's rolled back automatically.</p> <p>DDL statements inside a transaction cause an implicit commit. We recommend that you run each DDL statement in a separate <code>ExecuteStatement</code> call with <code>continueAfterTimeout</code> enabled.</p> </important> 
}
}
\section{Request syntax}{
\preformatted{svc$begin_transaction(
  database = "string",
  resourceArn = "string",
  schema = "string",
  secretArn = "string"
)
}
}

\keyword{internal}
