% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_db_snapshot}
\alias{rds_create_db_snapshot}
\title{Creates a snapshot of a DB instance}
\usage{
rds_create_db_snapshot(DBSnapshotIdentifier, DBInstanceIdentifier, Tags)
}
\arguments{
\item{DBSnapshotIdentifier}{[required] The identifier for the DB snapshot.

Constraints:
\itemize{
\item Can't be null, empty, or blank
\item Must contain from 1 to 255 letters, numbers, or hyphens
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}

Example: \code{my-snapshot-id}}

\item{DBInstanceIdentifier}{[required] The identifier of the DB instance that you want to create the snapshot
of.

Constraints:
\itemize{
\item Must match the identifier of an existing DBInstance.
}}

\item{Tags}{}
}
\value{
A list with the following syntax:\preformatted{list(
  DBSnapshot = list(
    DBSnapshotIdentifier = "string",
    DBInstanceIdentifier = "string",
    SnapshotCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    Engine = "string",
    AllocatedStorage = 123,
    Status = "string",
    Port = 123,
    AvailabilityZone = "string",
    VpcId = "string",
    InstanceCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    MasterUsername = "string",
    EngineVersion = "string",
    LicenseModel = "string",
    SnapshotType = "string",
    Iops = 123,
    OptionGroupName = "string",
    PercentProgress = 123,
    SourceRegion = "string",
    SourceDBSnapshotIdentifier = "string",
    StorageType = "string",
    TdeCredentialArn = "string",
    Encrypted = TRUE|FALSE,
    KmsKeyId = "string",
    DBSnapshotArn = "string",
    Timezone = "string",
    IAMDatabaseAuthenticationEnabled = TRUE|FALSE,
    ProcessorFeatures = list(
      list(
        Name = "string",
        Value = "string"
      )
    ),
    DbiResourceId = "string",
    TagList = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  )
)
}
}
\description{
Creates a snapshot of a DB instance. The source DB instance must be in
the \code{available} or \code{storage-optimization} state.
}
\section{Request syntax}{
\preformatted{svc$create_db_snapshot(
  DBSnapshotIdentifier = "string",
  DBInstanceIdentifier = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
