% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dax_operations.R
\name{dax_describe_default_parameters}
\alias{dax_describe_default_parameters}
\title{Returns the default system parameter information for the DAX caching
software}
\usage{
dax_describe_default_parameters(MaxResults, NextToken)
}
\arguments{
\item{MaxResults}{The maximum number of results to include in the response. If more
results exist than the specified \code{MaxResults} value, a token is included
in the response so that the remaining results can be retrieved.

The value for \code{MaxResults} must be between 20 and 100.}

\item{NextToken}{An optional token returned from a prior request. Use this token for
pagination of results from this action. If this parameter is specified,
the response includes only results beyond the token, up to the value
specified by \code{MaxResults}.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  Parameters = list(
    list(
      ParameterName = "string",
      ParameterType = "DEFAULT"|"NODE_TYPE_SPECIFIC",
      ParameterValue = "string",
      NodeTypeSpecificValues = list(
        list(
          NodeType = "string",
          Value = "string"
        )
      ),
      Description = "string",
      Source = "string",
      DataType = "string",
      AllowedValues = "string",
      IsModifiable = "TRUE"|"FALSE"|"CONDITIONAL",
      ChangeType = "IMMEDIATE"|"REQUIRES_REBOOT"
    )
  )
)
}
}
\description{
Returns the default system parameter information for the DAX caching
software.
}
\section{Request syntax}{
\preformatted{svc$describe_default_parameters(
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
