% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodbstreams_operations.R
\name{dynamodbstreams_get_records}
\alias{dynamodbstreams_get_records}
\title{Retrieves the stream records from a given shard}
\usage{
dynamodbstreams_get_records(ShardIterator, Limit)
}
\arguments{
\item{ShardIterator}{[required] A shard iterator that was retrieved from a previous GetShardIterator
operation. This iterator can be used to access the stream records in
this shard.}

\item{Limit}{The maximum number of records to return from the shard. The upper limit
is 1000.}
}
\description{
Retrieves the stream records from a given shard.

Specify a shard iterator using the \code{ShardIterator} parameter. The shard
iterator specifies the position in the shard from which you want to
start reading stream records sequentially. If there are no stream
records available in the portion of the shard that the iterator points
to, \code{GetRecords} returns an empty list. Note that it might take multiple
calls to get to a portion of the shard that contains stream records.

\code{GetRecords} can retrieve a maximum of 1 MB of data or 1000 stream
records, whichever comes first.
}
\section{Request syntax}{
\preformatted{svc$get_records(
  ShardIterator = "string",
  Limit = 123
)
}
}

\examples{
\dontrun{
# The following example retrieves all the stream records from a shard.
svc$get_records(
  ShardIterator = "arn:aws:dynamodb:us-west-2:111122223333:table/Forum/stream/2015-05-20T20:..."
)
}

}
\keyword{internal}
