% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_update_table}
\alias{dynamodb_update_table}
\title{Modifies the provisioned throughput settings, global secondary indexes,
or DynamoDB Streams settings for a given table}
\usage{
dynamodb_update_table(AttributeDefinitions, TableName, BillingMode,
  ProvisionedThroughput, GlobalSecondaryIndexUpdates, StreamSpecification,
  SSESpecification)
}
\arguments{
\item{AttributeDefinitions}{An array of attributes that describe the key schema for the table and
indexes. If you are adding a new global secondary index to the table,
\code{AttributeDefinitions} must include the key element(s) of the new index.}

\item{TableName}{[required] The name of the table to be updated.}

\item{BillingMode}{Controls how you are charged for read and write throughput and how you
manage capacity. When switching from pay-per-request to provisioned
capacity, initial provisioned capacity values must be set. The initial
provisioned capacity values are estimated based on the consumed read and
write capacity of your table and global secondary indexes over the past
30 minutes.
\itemize{
\item \code{PROVISIONED} - Sets the billing mode to \code{PROVISIONED}. We recommend
using \code{PROVISIONED} for predictable workloads.
\item \code{PAY_PER_REQUEST} - Sets the billing mode to \code{PAY_PER_REQUEST}. We
recommend using \code{PAY_PER_REQUEST} for unpredictable workloads.
}}

\item{ProvisionedThroughput}{The new provisioned throughput settings for the specified table or
index.}

\item{GlobalSecondaryIndexUpdates}{An array of one or more global secondary indexes for the table. For each
index in the array, you can request one action:
\itemize{
\item \code{Create} - add a new global secondary index to the table.
\item \code{Update} - modify the provisioned throughput settings of an existing
global secondary index.
\item \code{Delete} - remove a global secondary index from the table.
}

For more information, see \href{http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html}{Managing Global Secondary Indexes}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{StreamSpecification}{Represents the DynamoDB Streams configuration for the table.

You will receive a \code{ResourceInUseException} if you attempt to enable a
stream on a table that already has a stream, or if you attempt to
disable a stream on a table which does not have a stream.}

\item{SSESpecification}{The new server-side encryption settings for the specified table.}
}
\description{
Modifies the provisioned throughput settings, global secondary indexes,
or DynamoDB Streams settings for a given table.
}
\details{
You can only perform one of the following operations at once:
\itemize{
\item Modify the provisioned throughput settings of the table.
\item Enable or disable Streams on the table.
\item Remove a global secondary index from the table.
\item Create a new global secondary index on the table. Once the index
begins backfilling, you can use \code{UpdateTable} to perform other
operations.
}

\code{UpdateTable} is an asynchronous operation; while it is executing, the
table status changes from \code{ACTIVE} to \code{UPDATING}. While it is
\code{UPDATING}, you cannot issue another \code{UpdateTable} request. When the
table returns to the \code{ACTIVE} state, the \code{UpdateTable} operation is
complete.
}
\section{Request syntax}{
\preformatted{svc$update_table(
  AttributeDefinitions = list(
    list(
      AttributeName = "string",
      AttributeType = "S"|"N"|"B"
    )
  ),
  TableName = "string",
  BillingMode = "PROVISIONED"|"PAY_PER_REQUEST",
  ProvisionedThroughput = list(
    ReadCapacityUnits = 123,
    WriteCapacityUnits = 123
  ),
  GlobalSecondaryIndexUpdates = list(
    list(
      Update = list(
        IndexName = "string",
        ProvisionedThroughput = list(
          ReadCapacityUnits = 123,
          WriteCapacityUnits = 123
        )
      ),
      Create = list(
        IndexName = "string",
        KeySchema = list(
          list(
            AttributeName = "string",
            KeyType = "HASH"|"RANGE"
          )
        ),
        Projection = list(
          ProjectionType = "ALL"|"KEYS_ONLY"|"INCLUDE",
          NonKeyAttributes = list(
            "string"
          )
        ),
        ProvisionedThroughput = list(
          ReadCapacityUnits = 123,
          WriteCapacityUnits = 123
        )
      ),
      Delete = list(
        IndexName = "string"
      )
    )
  ),
  StreamSpecification = list(
    StreamEnabled = TRUE|FALSE,
    StreamViewType = "NEW_IMAGE"|"OLD_IMAGE"|"NEW_AND_OLD_IMAGES"|"KEYS_ONLY"
  ),
  SSESpecification = list(
    Enabled = TRUE|FALSE,
    SSEType = "AES256"|"KMS",
    KMSMasterKeyId = "string"
  )
)
}
}

\examples{
# This example increases the provisioned read and write capacity on the
# Music table.
\donttest{svc$update_table(
  ProvisionedThroughput = list(
    ReadCapacityUnits = 10L,
    WriteCapacityUnits = 10L
  ),
  TableName = "MusicCollection"
)}

}
\keyword{internal}
